//
// File: outout_con.v
// Author:  Vincent H.-J. Chiou
// Date: 10/30/98
// Version:
// Abstract: output control
//
// Modification History:
// Date     By      Version  Change Description
// --------------------------------------------
// 10/30/98  v       1.0      original
// 10/31/98                   modify write
// 11/01/98                   modify read and debug
// 11/02/98                   debug
// 11/11/98          2.0      
// 11/23/98                   reset ic
// 11/25/98                   add order0,order1,out_order
// 11/27/98                   add change_bank signal
// 12/08/98          3.0      add refresh cycle

module QS_SWITCH(qs1,qs2,qs_switch,sqs);
  input qs1,qs2;
  input qs_switch;
  output sqs;
  wire sqs;
  assign sqs=(qs_switch)?qs2:qs1;
endmodule


module NOT_EMPTY(clk,
                 rst_n,
                 qs,  //from OUT_CON out_count[`QBIT_WIDTH]
                 q_we_n,
                 en_d_n,
                 b1_notempty,
                 b2_notempty);
  input clk;
  input rst_n;
  input qs;
  input q_we_n;
  input en_d_n;
  
  output b1_notempty;
  output b2_notempty;
  
  reg b1_notempty;
  reg b2_notempty;
 
  always @(negedge clk or negedge rst_n)
    begin
      if (!rst_n)
        begin
          b1_notempty=0;
          b2_notempty=0;
        end
      else
        case (qs)
          0:
            begin
              b1_notempty=b1_notempty|(~(q_we_n|en_d_n));
            end
          1:
            begin
              b2_notempty=b2_notempty|(~(q_we_n|en_d_n));
            end
        endcase
    end
endmodule
   
module AQ_SEL(qs,  // from OUT_CON ic[`Q_BIT_WIDTH]
              b1_reg_0,   // address info from queue 1
              b1_reg_1,
              b1_reg_2,
              b1_reg_3,
            //  b1_mode,
              b1_data,
              
              b2_reg_0,   // address info from queue 2
              b2_reg_1,
              b2_reg_2,
              b2_reg_3,
           //   b2_mode,
              b2_data,
              
              reg_0,   
              reg_1,
              reg_2,
              reg_3,
           //   mode_reg,
              data_r);
              
  parameter ADDR_BIT_WIDTH=`BS_WIDTH+`ROW_WIDTH+`COL_WIDTH;
  
  input qs;
  input [ADDR_BIT_WIDTH:0] b1_reg_0;
  input [ADDR_BIT_WIDTH:0] b1_reg_1;
  input [ADDR_BIT_WIDTH:0] b1_reg_2;
  input [ADDR_BIT_WIDTH:0] b1_reg_3;
//  input [`Q_BIT_WIDTH:0] b1_mode;
  input [`BANDWIDTH-1:0] b1_data;
  
  input [ADDR_BIT_WIDTH:0] b2_reg_0;
  input [ADDR_BIT_WIDTH:0] b2_reg_1;
  input [ADDR_BIT_WIDTH:0] b2_reg_2;
  input [ADDR_BIT_WIDTH:0] b2_reg_3;
//  input [`Q_BIT_WIDTH:0] b2_mode; 
  input [`BANDWIDTH-1:0] b2_data;
  
  output [ADDR_BIT_WIDTH:0] reg_0;
  output [ADDR_BIT_WIDTH:0] reg_1;
  output [ADDR_BIT_WIDTH:0] reg_2;
  output [ADDR_BIT_WIDTH:0] reg_3;
//  output [`Q_BIT_WIDTH:0] mode_reg; 
  output [`BANDWIDTH-1:0] data_r;
  
  reg [ADDR_BIT_WIDTH:0] reg_0;
  reg [ADDR_BIT_WIDTH:0] reg_1;
  reg [ADDR_BIT_WIDTH:0] reg_2;
  reg [ADDR_BIT_WIDTH:0] reg_3; 
//  reg [`Q_BIT_WIDTH:0] mode_reg; 
  reg [`BANDWIDTH-1:0] data_r;
  
  always @(qs or
           b1_reg_0 or
           b1_reg_1 or 
           b1_reg_2 or 
           b1_reg_3 or               
           b2_reg_0 or   
           b2_reg_1 or 
           b2_reg_2 or 
           b2_reg_3 or
           b1_data or 
           b2_data) // or
 //          b1_mode or
 //          b2_mode)
    begin
      case (qs)
        1'b0:
          begin
         //   mode_reg=b1_mode;
            data_r=b1_data;
            reg_0=b1_reg_0;   
            reg_1=b1_reg_1;
            reg_2=b1_reg_2;
            reg_3=b1_reg_3;
          end
        1'b1:
          begin
         //   mode_reg=b2_mode;
            reg_0=b2_reg_0;   
            reg_1=b2_reg_1;
            reg_2=b2_reg_2;
            reg_3=b2_reg_3;
            data_r=b2_data;
          end
      endcase
    end  
endmodule           



module OUT_CON(clk,        // clock
               rst_n,        // reset
               start,      // start to output
               request,    // request for input 
               qs,         // queue select from input control
               reg_0,      // address info from queue
               reg_1,
               reg_2,
               reg_3,
               data_in,    // data from data mem
               dq_in,      // data from SDRAM
               mode_reg0,   // mode from address queue0
               mode_reg1,   // mode from address queue0 
               
               ready,      // ready to receive 
               
               cke,        // clock enable
               cs_n,       // chip select
               ras_n,      // ras 
               cas_n,      // cas
               we_n,       // write enable
               bs,         // bank select
               dqm,        // dqm               
               addr_bits,  // address bits to SDRAM       
               dq_out,     // data output to SDRAM
               
               o_qs,       // from ic[`Q_BIT_WIDTH] 
               o2_qs,
               qs_switch,
               q_we_n,     // data mem write enablle
               en_d_n,     // data mem enable
               row,        // data mem row address
               data_out,   // data output to data mem  
               
               se,
               sin,
               sout);   
               
               
  parameter ADDR_BIT_WIDTH=`BS_WIDTH+`ROW_WIDTH+`COL_WIDTH;
  parameter [3:0] S0=0,S1=1,S2=2,S3=3,S4=4,S5=5,S6=6,S7=7,S8=8,S9=9,
    S10=10,S11=11,S12=12,S13=13,S14=14,S15=15;
  parameter HI_Z='hz;
  
  parameter TRC     =6;
  parameter TRP     =3;  // depend on latency
  parameter TRSC    =2;
  parameter TRCD    =3;  // depend on latency
  parameter LATENCY =3;
  parameter BL      =4;  // burst length
  parameter BL_BIT_WIDTH=2; // =log(BL)
  parameter MODE2CYCLE=BL+TRP;
  
  /********* module I/O variable definne **********************/
  input se;
  input sin;
              
  input clk;
  input rst_n;
  input start;
  input request;
  input qs;
  input [ADDR_BIT_WIDTH:0] reg_0;
  input [ADDR_BIT_WIDTH:0] reg_1;
  input [ADDR_BIT_WIDTH:0] reg_2;
  input [ADDR_BIT_WIDTH:0] reg_3;
  input [`BANDWIDTH-1:0]   data_in;
  input [`DATA_WIDTH-1:0]  dq_in;
  input [`BS_WIDTH:0] mode_reg0;
  input [`BS_WIDTH:0] mode_reg1;
  output sout;
  output ready;
  output cke;
  output cs_n;
  output ras_n;
  output cas_n;
  output we_n;
  output [`BS_WIDTH-1:0] bs;
  output dqm;
  output [`ROW_WIDTH-1:0] addr_bits;
  output [`DATA_WIDTH-1:0] dq_out;
  
  output o_qs;
  output o2_qs;
  output qs_switch;
  output q_we_n;
  output en_d_n;
  output [`Q_BIT_WIDTH-1:0] row;
  output [`BANDWIDTH-1:0] data_out;
  
  reg ready;
  reg cke;
  reg cs_n;
  reg ras_n;
  reg cas_n;
  reg we_n;
  reg [`BS_WIDTH-1:0] bs;
  reg dqm;
  reg [`ROW_WIDTH-1:0] addr_bits;
  reg [`DATA_WIDTH-1:0] dq_out;
  
  wire o_qs;
  reg q_we_n;
  reg en_d_n;
  reg [`Q_BIT_WIDTH-1:0] row;
  reg [`BANDWIDTH-1:0] data_out;

  /********** local variable define *************************/
  reg [`Q_SIZE-1:0] reg_rw;
  reg [`BS_WIDTH-1:0] reg_bs [`Q_SIZE-1:0];
  reg [`ROW_WIDTH-1:0] reg_row [`Q_SIZE-1:0];
  reg [`COL_WIDTH-1:0] reg_col [`Q_SIZE-1:0];
  reg [3:0] current_state;
  reg [`BS_WIDTH*`Q_SIZE-1:0] order_table [7:0];
  reg [`Q_BIT_WIDTH-1:0] out_order [`Q_SIZE-1:0];
  reg [`Q_BIT_WIDTH-1:0] order0 [`Q_SIZE-1:0];
  reg [`Q_BIT_WIDTH-1:0] order1 [`Q_SIZE-1:0];
  
  reg flag_out,flag_in;
  reg ready_tmp;
  reg [`Q_BIT_WIDTH-1:0] index_current,index_next;
  reg pre_receive,post_receive;
  /***** delay variablle ***********************************/
  reg cke_tmp;
  reg cs_n_tmp;
  reg ras_n_tmp;
  reg cas_n_tmp;
  reg we_n_tmp;
  reg [`BS_WIDTH-1:0] bs_tmp;
  reg dqm_tmp;
  reg [`ROW_WIDTH-1:0] addr_bits_tmp;
  reg readytogo;
 // reg change_bank;
  reg cbr_index;
  
  /********* count variable ********************************/
  reg [1:0] lat_trp_trsc;  // max 3
  reg [3:0] trc_count;  // max 10  
  reg [1:0] trcd_count; // max 3
  reg [3:0] rf_count;
  reg [`Q_BIT_WIDTH:0] wc,ic;
  reg bl_ready;
  reg lat_ready;
  reg [3:0] wait_cycle; // max 16
  reg [3:0] wait_count; // max 16
  reg rw_flag;
  reg [`Q_BIT_WIDTH-1:0] map_qrow;
  reg [`DATA_WIDTH-1:0] data_buffer [BL-1:0];
  reg [`DATA_WIDTH-1:0] read_buffer [BL-1:0];
  reg [BL_BIT_WIDTH-1:0] bl_count;
  reg [1:0] next_mode;
  reg [`Q_BIT_WIDTH:0] out_count;
  wire rst;
  reg [10:0] rfc; // refresh counter
  
  /*** debug ***/
  // reg  tmp;
  
  task SETMODE;		// Mode Register Set command
      input dqm_in;
    begin
      cke_tmp = 1;
      cs_n_tmp = 0;
      ras_n_tmp = 0;
      cas_n_tmp = 0;
      we_n_tmp  = 0;
      bs_tmp  = 0;
      dqm_tmp   = dqm_in;
      addr_bits_tmp=12'b00100_011_0_010;
    end
  endtask
  
  task NOP;		// No operation command
    input dqm_in;
    begin
      cke_tmp = 1;
      cs_n_tmp = 0;
      ras_n_tmp = 1;
      cas_n_tmp = 1;
      we_n_tmp  = 1;
      dqm_tmp=dqm_in;
    end
  endtask

  task AUTO_REFRESH;	// AutoRefresh command
    input dqm_in;
    begin
      cke_tmp   = 1;
      cs_n_tmp  = 0;
      ras_n_tmp = 0;
      cas_n_tmp = 0;
      we_n_tmp  = 1;
      dqm_tmp   = dqm_in;
    end
  endtask

  task PRECHARGE_ALL;	// PrechargeAll command
    input dqm_in;
    begin
      cke_tmp = 1;
      cs_n_tmp = 0;
      ras_n_tmp = 0;
      cas_n_tmp = 1;
      we_n_tmp  = 0;
      addr_bits_tmp[10] = 1;
      dqm_tmp=dqm_in;
    end
  endtask
  
  
  task BANKACTIVE;		// BankActivate 
    input [`BS_WIDTH-1:0] bank;
    input [`ROW_WIDTH-1:0] addr;
    begin
      cke_tmp = 1;
      cs_n_tmp = 0;
      ras_n_tmp  = 0;
      cas_n_tmp  = 1;
      we_n_tmp   = 1;
      bs_tmp = bank;
      addr_bits_tmp= addr;
      dqm_tmp  = 0;
    end
  endtask
  

  task READ;		// Read command
    input [`BS_WIDTH-1:0] bank;
    input [`COL_WIDTH-1:0] addr;
    begin
      cke_tmp	  = 1;
      cs_n_tmp	  = 0;
      ras_n_tmp  = 1;
      cas_n_tmp  = 0;
      we_n_tmp   = 1;
      bs_tmp   = bank;
      addr_bits_tmp[10]   = 0;
      addr_bits_tmp[`COL_WIDTH-1:0] = addr;
      dqm_tmp    = 0;
    end
  endtask

  task READ_AP;		// Read and AutoPrecharge command
    input [`BS_WIDTH-1:0] bank;
    input [`COL_WIDTH-1:0] addr;
    begin
      cke_tmp	 = 1;
      cs_n_tmp = 0;
      ras_n_tmp = 1;
      cas_n_tmp = 0;
      we_n_tmp  = 1;
      bs_tmp  = bank;
      addr_bits_tmp[10]  = 1;
      addr_bits_tmp[`COL_WIDTH-1:0]= addr;
      dqm_tmp   = 0;
    end
  endtask

  task WRITE;		// Write command
    input [`BS_WIDTH-1:0] bank;
    input [`COL_WIDTH-1:0] addr;
    begin
      cke_tmp = 1;
      cs_n_tmp = 0;
      ras_n_tmp = 1;
      cas_n_tmp = 0;
      we_n_tmp  = 0;
      bs_tmp  = bank;
      addr_bits_tmp[10]  = 0;
      addr_bits_tmp[`COL_WIDTH-1:0]= addr;
      dqm_tmp   = 0;
    end
  endtask

  task WRITE_AP;		// Write and AutoPrecharge command
    input [`BS_WIDTH-1:0] bank;
    input [`COL_WIDTH-1:0] addr;
    begin
      cke_tmp = 1;
      cs_n_tmp = 0;
      ras_n_tmp = 1;
      cas_n_tmp = 0;
      we_n_tmp  = 0;
      bs_tmp    = bank;
      addr_bits_tmp[10]  = 1;
      addr_bits_tmp[`COL_WIDTH-1:0]= addr;
      dqm_tmp   = 0;
    end
  endtask
 
  task CHECK_LATENCY;
    begin
      if (lat_ready)
        begin
          if (lat_trp_trsc<LATENCY) lat_trp_trsc=lat_trp_trsc+1;
          else 
            begin
              bl_ready=1;
              lat_ready=0;  // stop latency counter
            end
        end
    end
  endtask
  
  task WRITESDRAM;
    begin
      if (bl_ready) // ready to write data to sdram
        begin
          flag_out=1;
          bl_count=bl_count+1;
          
          if (bl_count==BL-1) bl_ready=0;
        end
      else
        flag_out=0;
    end
  endtask
  
  task READSDRAM;
    begin
      if (bl_ready) // ready to read data from sdram
        begin
          flag_in=1;
          
         // data_buffer[bl_count]=dq_in;
          bl_count=bl_count+1;
         
          if (bl_count<BL-1) 
            begin
            pre_receive=1;
            //  en_d_n=1;
            //  bl_count=bl_count+1;
            end
          else 
            begin
              pre_receive=0;
          //    out_count=out_count+1;
          //    row=order[map_qrow];
          //    data_out={data_buffer[0],data_buffer[1],data_buffer[2],
          //      data_buffer[3]};
          //    q_we_n=0;
          //    en_d_n=0;
            //  bl_count=0;
              bl_ready=0;
          //    map_qrow=map_qrow+1;

            end 
        end
      else 
        begin
          flag_in=0;
          pre_receive=1;
        //  en_d_n=1;
        end
      if (post_receive)
        begin
           out_count=out_count+1;
           row=out_order[map_qrow];
           data_out={read_buffer[0],read_buffer[1],read_buffer[2],
             read_buffer[3]};
           q_we_n=0;
           en_d_n=0;
           map_qrow=map_qrow+1;
        end
      else en_d_n=1;
    end
  endtask
  
  assign rst=~rst_n;
  assign o2_qs=out_count[`Q_BIT_WIDTH];
  assign qs_switch=rw_flag;
  assign o_qs=ic[`Q_BIT_WIDTH];
  
  always @(posedge clk)
    begin
      {order0[0],order0[1],order0[2],order0[3]}=order_table[mode_reg0];
      {order1[0],order1[1],order1[2],order1[3]}=order_table[mode_reg1];
    end
  
  always @(negedge clk)
    begin
      if (flag_in) read_buffer[bl_count]=dq_in;
      post_receive=~pre_receive;
    end
    
  always @(reg_0 or reg_1 or reg_2 or reg_3)
    begin
      {reg_rw[0],reg_bs[0],reg_row[0],reg_col[0]}=reg_0;
      {reg_rw[1],reg_bs[1],reg_row[1],reg_col[1]}=reg_1;
      {reg_rw[2],reg_bs[2],reg_row[2],reg_col[2]}=reg_2;
      {reg_rw[3],reg_bs[3],reg_row[3],reg_col[3]}=reg_3;
    end
  
  always @(current_state or ic  or qs or ready_tmp or rst)
    begin
      if (current_state>9)
        if (ic[`Q_BIT_WIDTH]!=qs) ready=1;
        else ready=0;
      else ready=ready_tmp;
    end
    
  always @(negedge clk)
    begin
      cke=cke_tmp;
      cs_n=cs_n_tmp;
      ras_n=ras_n_tmp;
      cas_n=cas_n_tmp;
      we_n=we_n_tmp;
      bs=bs_tmp;
      dqm=dqm_tmp;
      addr_bits=addr_bits_tmp;
      
    end


    always @(negedge clk)
      begin
        case (flag_out)
          0: dq_out='hz;
          1: dq_out=data_buffer[bl_count];
        endcase
      end
      
    
    
  always @(posedge clk or posedge rst)
    begin
      if (rst)
        begin
          order_table[0]=8'b00011011;
          order_table[1]=8'b00100111;
          order_table[2]=8'b00011110;
          order_table[3]=8'b01001011;
          order_table[4]=8'b00100111;
          order_table[5]=8'b00100111;
          order_table[6]=8'b00011110;
          order_table[7]=8'b00011011;
        end
      else
        begin
          order_table[0]=order_table[0];
          order_table[1]=order_table[1];
          order_table[2]=order_table[2];
          order_table[3]=order_table[3];
          order_table[4]=order_table[4];
          order_table[5]=order_table[5];
          order_table[6]=order_table[6];
          order_table[7]=order_table[7];
        end
    end  
      
  always @(posedge clk or posedge rst)
    begin
      if (rst)
        begin
          ready_tmp=0;
          out_count=~0;
          en_d_n=1;
        //  flag_out=0;
          
        //  rw_flag=0;
        //  readytogo=0;
          ic=0;
        //  pre_receive=1;
        //  next_mode=0;
        //  flag_in=0;
          current_state=S0;
        end
      else
        begin      
          case (current_state) // synopsys full_case
            S0:            /* initial */
              begin
                rw_flag=0;
                readytogo=0;  
                next_mode=0;
              //  out_count=~0;
                flag_out=0;
                flag_in=0;
              //  ready_tmp=0;
              //  ic=0;
                cke_tmp=1;
                cs_n_tmp=1;
                dqm_tmp=1;
                pre_receive=1;
              //  en_d_n=1;
              //  change_bank=0;
                current_state=S1;
              end
            S1:           // precharge all
              begin
                PRECHARGE_ALL(1);
                lat_trp_trsc=1;
                current_state=S2;
              end
            S2:          // wait time Trc
              begin
                NOP(1);
                if (lat_trp_trsc<(TRP-1))
                  begin
                    lat_trp_trsc=lat_trp_trsc+1;
                    current_state=S2;
                  end
                else 
                  begin
                    rf_count=0;
                    current_state=S3;
                  end
              end
            S3:         // auto refresh
              begin
                rf_count=rf_count+1;
                cbr_index=0;
                AUTO_REFRESH(1);
                trc_count=1;
                current_state=S4;
              end
            S4:
              begin
                NOP(1);
                if (trc_count<(TRC-1))
                  begin
                    trc_count=trc_count+1;
                    current_state=S4;
                  end
                else 
                  if (rf_count[3]==1) current_state=S5;
                  else current_state=S3;
              end
            S5:
              begin
                SETMODE(1);
                rfc=0;
                lat_trp_trsc=1;
                current_state=S6;
              end
            S6:
              begin
                rfc=rfc+1;
                NOP(1);
                if (lat_trp_trsc<(TRSC-1))
                  begin
                    lat_trp_trsc=lat_trp_trsc+1;
                    current_state=S6;
                  end
                else 
                  begin
                    ready_tmp=0;
                    current_state=S7;
                  end
              end
            S7:            // idle , wait for request
              begin
                rfc=rfc+1;
                NOP(0);
                if (request) 
                  begin
                    wc=0;
                    ready_tmp=1;
                    current_state=S8;
                  end
                else
                  begin
                    current_state=S7;
                  end
              end
            S8:
              begin
                rfc=rfc+1;
                NOP(0);
                wc=wc+1;
                if (wc[`Q_BIT_WIDTH]==0)
                  current_state=S8;
                else 
                  begin
                    ready_tmp=0;
                    current_state=S9;
                  end
              end
            S9:           // idle , wait for output
              begin
                rfc=rfc+1;
                NOP(0);
                if (start)
                  begin
                    rw_flag=reg_rw[0];
                    bl_count=~0;
                 //   if (rw_flag) bl_count=~0;
                 //   else bl_count=~0;
                    
                    trcd_count=0;
                    lat_trp_trsc=0;
                    wait_count=0;
                    bl_ready=0;
                    lat_ready=0;
                 //   change_bank=0;
                    map_qrow=0;
                    
                //    {order[0],order[1],order[2],order[3]}=
                //      order_table[mode_reg];

                    current_state=S10;
                  end
                else 
                  begin
                    current_state=S9;
                  end
              end
            S10:          // send bank active
              begin
                rfc=rfc+1;
                if (rw_flag)
                  begin
                    if (readytogo)
                      begin
                        lat_ready=1;
                        lat_trp_trsc=1;
                        READSDRAM;
                        readytogo=0;
                      end
                    else
                      begin
                        CHECK_LATENCY;
                        READSDRAM;
                      end
                  end
                else 
                  begin
                    en_d_n=1;
                    WRITESDRAM;
                  end
                
                if (ic[`Q_BIT_WIDTH]==0)
                  index_current=order0[ic[`Q_BIT_WIDTH-1:0]];
                else index_current=order1[ic[`Q_BIT_WIDTH-1:0]];
                
                BANKACTIVE(reg_bs[index_current],
                  reg_row[index_current]);
                trcd_count=1;
                current_state=S11;
              end
            S11: 
              begin
                rfc=rfc+1;
                if (rw_flag)
                  begin
                    CHECK_LATENCY;
                    READSDRAM;
                  end
                else 
                  begin
                    WRITESDRAM;
                  end
            
                NOP(0);
                if (trcd_count<(TRCD-1))
                  begin
                    trcd_count=trcd_count+1;
                    current_state=S11;
                  end
                else 
                  begin
                    if (!rw_flag)
                      begin
                        // read data from data mem
                        if (ic[`Q_BIT_WIDTH]==0)
                          row=order0[ic[`Q_BIT_WIDTH-1:0]];
                        else  row=order1[ic[`Q_BIT_WIDTH-1:0]];
                        q_we_n=1;
                        en_d_n=0;
                      end
                    current_state=S12;
                  end
              end
            S12:       // send read write command
              begin
                rfc=rfc+1;
                if (ic[`Q_BIT_WIDTH-1:0]==`Q_SIZE-1)
                  begin
                    next_mode=2;
                    if (rfc>750) cbr_index=1;
                    else cbr_index=0;
                  end
                else
                  begin
                    if (ic[`Q_BIT_WIDTH]==0)
                      begin
                        index_current=order0[ic[`Q_BIT_WIDTH-1:0]];
                        index_next=order0[ic[`Q_BIT_WIDTH-1:0]+1];
                      end
                    else
                      begin
                        index_current=order1[ic[`Q_BIT_WIDTH-1:0]];
                        index_next=order1[ic[`Q_BIT_WIDTH-1:0]+1];
                      end
                      
                    if (reg_bs[index_current]!=reg_bs[index_next])
                      next_mode=0;  // bank interleavinng mode
                    else 
                      if (reg_row[index_current]==reg_row[index_next])
                        next_mode=1;  // page mode
                      else next_mode=2;  
                  end
                  
                  
                if (rw_flag)  // read
                  begin
                    if (out_count[`Q_BIT_WIDTH-1:0]==3)
                      if (ic[`Q_BIT_WIDTH]==0)
                        {out_order[0],out_order[1],out_order[2],out_order[3]}=
                          order_table[mode_reg0];
                      else 
                        {out_order[0],out_order[1],out_order[2],out_order[3]}=
                          order_table[mode_reg1];
                    readytogo=1;
                    CHECK_LATENCY;
                    READSDRAM;
                    // set time to wait
                    case (next_mode) // synopsys full_case
                      0:  // bank interleaving 
                        begin
                          READ_AP(reg_bs[index_current],
                            reg_col[index_current]);
                            
                   /*  if BL>(TRCD-1) ,uncomment following code */         
                    //      if (BL>TRCD)
                    //        begin
                    //          wait_cycle=BL-TRCD;
                    //          wait_count=1;
                    //          if (wait_cycle==1)
                    //            begin
                    //              ic=ic+1;
                    //              current_state=S10;
                    //            end
                    //          else
                    //            current_state=S13;
                    //        end
                    //      else 
                   /****************************************/       
                   /*  if BL<=TRCD ,uncomment follwing code */        
                   //         begin
                              ic=ic+1;
                              current_state=S10;
                   //         end
                   /***************************************/         
                        end
                
                      1:  // page mode
                        begin
                          READ(reg_bs[index_current],
                            reg_col[index_current]);
                          wait_cycle=BL;
                          wait_count=1;
                          current_state=S13;
                        end
              
                      2:
                        begin
                          READ_AP(reg_bs[index_current],
                            reg_col[index_current]);
                          wait_cycle=BL+LATENCY;
                          wait_count=1;
                          current_state=S13;
                        end
                    endcase
                  end
                else      //write
                  begin
                    bl_ready=1;
                   {data_buffer[0],data_buffer[1],data_buffer[2],
                      data_buffer[3]}=data_in;
                    
                    WRITESDRAM;
                    case (next_mode) //synopsys full_case
                      0:
                        begin
                          WRITE_AP(reg_bs[index_current],
                            reg_col[index_current]);
                          wait_cycle=BL>>1;
                          wait_count=1;
                   /*       if (wait_cycle==1)
                            begin
                              ic=ic+1;
                              en_d_n=1;
                              current_state=S10;
                            end
                          else 
                            begin   */
                              en_d_n=1;
                              current_state=S13;
                   /*         end  */
                        end
                    
                      1:
                        begin
                          WRITE(reg_bs[index_current],
                            reg_col[index_current]);
                          wait_cycle=BL;
                          wait_count=1;
                          en_d_n=1;
                          current_state=S13;
                        end
                   
                      2:
                        begin
                          WRITE_AP(reg_bs[index_current],
                            reg_col[index_current]);
                          wait_cycle=MODE2CYCLE;
                          wait_count=1;
                          en_d_n=1;
                          current_state=S13;
                        end
                    endcase
                  end          
              end
            S13:
              begin
                rfc=rfc+1;
                if (rw_flag)
                  begin
                    if (readytogo)
                      begin
                        lat_ready=1;
                        lat_trp_trsc=1;
                     //   READSDRAM;
                        readytogo=0;
                      end
                    else
                      begin
                        CHECK_LATENCY;
                     //   READSDRAM;
                      end
                    READSDRAM;
                  end
                else 
                  begin
                    WRITESDRAM;
                  end
            
                NOP(0);
                if (wait_count<(wait_cycle-1))
                  begin
                    wait_count=wait_count+1;
                    current_state=S13;
                  end
                else
                  begin
                    
                    if (next_mode==1) 
                      begin
                        if (!rw_flag)
                          begin
                        // read data from data mem
                            if (ic[`Q_BIT_WIDTH]==0)
                              row=order0[ic[`Q_BIT_WIDTH-1:0]];
                            else  row=order1[ic[`Q_BIT_WIDTH-1:0]];
                            q_we_n=1;
                            en_d_n=0;
                          end
                        ic=ic+1;
                        current_state=S12;
                      end
                    else 
                      begin
                        if (cbr_index) current_state=S14;
                        else
                          begin
                            ic=ic+1;
                            current_state=S10;
                          end
                      end
                      
                  end
              end
            S14:
              begin
                rfc=0;
                AUTO_REFRESH(1);
                trc_count=1;
                current_state=S15;
              end
            S15:
              begin
                NOP(1);
                if (trc_count<(TRC-1))
                  begin
                    trc_count=trc_count+1;
                    current_state=S15;
                  end
                else 
                  begin
                    ic=ic+1;
                    current_state=S10;
                  end 
              end
          endcase
        end
    end
endmodule
