//
// File: input_c.v
// Author:  Vincent H.-J. Chiou
// Date: 10/29/98
// Version:
// Abstract: input control
//
// Modification History:
// Date     By      Version  Change Description
// --------------------------------------------
// 10/29/98  v               original



module INPUT_C(clk,      // clock
               rst_n,      // reset
               ready,    // ready to receive
               we_n,     // write enable
               
               qs,       // queue select
               q_row,    // queue index
               we_d_n,   // queue data write enable
               en_a1_n,  // address queue 1 enable 
               en_a2_n); // address queue 2 enable 
               
                          
  parameter ADDR_WIDTH=`BS_WIDTH+`ROW_WIDTH+`COL_WIDTH;
  parameter S0=0,S1=1;
  
  input clk;
  input rst_n;
  input ready;
  input we_n;
  
  output qs;
  output [`Q_BIT_WIDTH-1:0] q_row;
  output we_d_n;
  output en_a1_n;
  output en_a2_n;
  
  reg qs;
  reg [`Q_BIT_WIDTH-1:0] q_row;
  reg we_d_n;
  reg en_a1_n;
  reg en_a2_n;
  
/******* local variable *********/
  wire rst=~rst_n;
  reg current_state,next_state;
  reg [`Q_BIT_WIDTH:0] ic;  // including qs (left most bit)

  
  always @(posedge clk or posedge rst)
    begin
      if (rst) current_state=S0;
      else current_state=next_state;
    end
  
  always @(negedge clk or negedge rst_n)
    begin
      if (!rst_n) ic=0;
      else
        if (ready) ic=ic+1;
    end
     
  always @(posedge clk or posedge rst)
    begin
      if (rst) 
        begin
          q_row=0;
          qs=0;
        end
      else
        if (ready) 
          begin
            qs=ic[`Q_BIT_WIDTH];
            q_row=ic[`Q_BIT_WIDTH-1:0];
            
          end
        
    end
    
  always @(current_state or ready or ic  or we_n )
    begin
      case (current_state)
        S0:
          begin
         //   ic=0;
            en_a1_n=1;
            en_a2_n=1;
            we_d_n=1;
          //  qs=0;
          //  q_row=0;
            next_state=S1;
          end
        S1:
          begin
            if (ready)
              begin
             //   qs=ic[`Q_BIT_WIDTH];
                en_a1_n=ic[`Q_BIT_WIDTH];
                en_a2_n=~ic[`Q_BIT_WIDTH];
             //   q_row=ic[`Q_BIT_WIDTH-1:0];
                
                if (!we_n) // if write enable then store data to queue
                  begin
                    we_d_n=0;
                  end
                else 
                  begin
                    we_d_n=1;
                  end 
            //    if (!clk)
            //      ic=ic+1;
              end
            else
              begin
                en_a1_n=1;
                en_a2_n=1;
                we_d_n=1;
              end
            next_state=S1;
          end
      endcase
    end
    
endmodule

      
      
