//
// File: data_queue.v
// Author:  Vincent H.-J. Chiou
// Date: 10/29/98
// Version:
// Abstract: data queue
//
// Modification History:
// Date     By      Version  Change Description
// --------------------------------------------
// 10/29/98  v               original

module BANK(clk,     

            en_n_1,      // access enable
            we_n_1,      // write enable
            row_1,       // row address
            data_in_1,   // data write to data mem
            
            en_n_2,      // access enable
            we_n_2,      // write enable
            row_2,       // row address
            data_out_2,   // data write to data mem
            
            en_n_3,      // access enable
            we_n_3,      // write enable
            row_3,       // row address
            data_in_3,   // data write to data mem            
            data_out_3); // data read from data mem
            
  input clk;
  input en_n_1;
  input we_n_1;
  input [`Q_BIT_WIDTH-1:0] row_1;
  input [`BANDWIDTH-1:0] data_in_1;
  
  input en_n_2;
  input we_n_2;
  input [`Q_BIT_WIDTH-1:0] row_2;
  output [`BANDWIDTH-1:0] data_out_2;
  
  input en_n_3;
  input we_n_3;
  input [`Q_BIT_WIDTH-1:0] row_3;
  input [`BANDWIDTH-1:0] data_in_3;
  output [`BANDWIDTH-1:0] data_out_3;
  
  reg [`BANDWIDTH-1:0] data_out_2;
  reg [`BANDWIDTH-1:0] data_out_3;
  /********** local variable ********************/
  reg [`BANDWIDTH-1:0] cell [`Q_SIZE-1:0];
  
     
  /* flip flop method */
  always @(negedge clk)
    begin
      if (!en_n_1) // enable
        begin
          if (!we_n_1) // write
            cell[row_1]=data_in_1;
        end
      
        
      if (!en_n_2) // enable
        begin
          if (we_n_2) // read
            data_out_2=cell[row_2];
          else data_out_2='hz;
        end
      else 
        data_out_2='hz; 
        
      if (!en_n_3) // enable
        begin
          if (we_n_3) // read
            data_out_3=cell[row_3];
          else // write
            cell[row_3]=data_in_3;
        end
      else // disable
        data_out_3='hz;
      
    end 
    
      
endmodule

  
