
/***********************************************************************
This confidential and proprietary software may be used
only as authorized by a licensing agreement from NTHU CS VLSI/CAD Lab.
In the event of publication, the following notice is
applicable:

(C) COPYWRIGHT 1998 NTHU CS VLSI/CAD LAB.
ALL RIGHTS RESERVED

The entire notice above must be reproduced on all
authorized copies.

File Name       : abritrate.v
Version         : 1.0
Date            : July 22, 1998
Simulator       : VERILOG-XL 2.5
Dependencies    : None

Author          : Vincent H.-J Chiou
Email           : vinchiou@nthucad.cs.nthu.edu.tw
Phone           : +886-3-571-5131 ext. 3557 3512
Company         : NTHU CS VLSI/CAD Lab.
Model           : UltraHelios 16Mbits DRAM Macro Specification
                  1048576 X 16-bit Dynamic RAM
Rev.            : 3.0

Limitation      : No limitation.

Description     : this module decide INPUT_C, DATA2PRO and OUTPUT_CON
                  can access which data memory  

Coding Style Revised:
Reviser         :
Date            :
Version         :

Modification History:
Date        By      Version             Change Description
=========================================================
1998/10/20   vincent   1.0                 Original
1998/11/16             5.0           
=========================================================

***********************************************************************/


 
/***********************************************************************
* Module:ABRITRATE 
* Input: m1_qs,m1_en_n,m2_qs,m2_en_n,m3_qs,m3_en_n
* Output: m1b1_en_n,m1b2_en_n,m2b1_en_n,m2b2_en_n,m3b1_en_n,m3b2_en_n
* Description:this module decide INPUT_C, DATA2PRO and OUTPUT_CON
                  can access which data memory   
* Synthesizable: Yes (Synopsys 1997.08)
***********************************************************************/

module ABRITRATE(m1_qs,
                 m1_en_n, // signal from INPUT_C
                 
                 m2_qs_n,
                 m2_en_n, // signal from DATA2PRO
                 
                 m3_qs,
                 m3_en_n, // signal from OUTPUT_CON
                 
                 m1b1_en_n,
                 m1b2_en_n,
                 m2b1_en_n,
                 m2b2_en_n,
                 m3b1_en_n,
                 m3b2_en_n);

                 

  input m1_qs;
  input m1_en_n; // signal from INPUT_C
  
  input m2_qs_n;               
  input m2_en_n; // signal from DATA2PRO
  
  input m3_qs;               
  input m3_en_n; // signal from OUTPUT_CON
  
  output m1b1_en_n;
  output m1b2_en_n;
  output m2b1_en_n;
  output m2b2_en_n;
  output m3b1_en_n;
  output m3b2_en_n;
  
  reg m1b1_en_n;
  reg m1b2_en_n;
  reg m2b1_en_n;
  reg m2b2_en_n;
  reg m3b1_en_n;
  reg m3b2_en_n;
  
  wire m2_qs=~m2_qs_n;
  
  always @(m1_qs or m1_en_n)
    begin
      if (m1_qs==0) 
        begin
          m1b1_en_n=m1_en_n;
          m1b2_en_n=1;
        end
      else  
        begin
          m1b1_en_n=1;
          m1b2_en_n=m1_en_n;
        end
    end
  
  always @(m2_qs or m2_en_n)
    begin
      if (m2_qs==0) 
        begin
          m2b1_en_n=m2_en_n;
          m2b2_en_n=1;
        end
      else  
        begin
          m2b1_en_n=1;
          m2b2_en_n=m2_en_n;
        end
    end
    
  always @(m3_qs or m3_en_n)
    begin
      if (m3_qs==0) 
        begin
          m3b1_en_n=m3_en_n;
          m3b2_en_n=1;
        end
      else  
        begin
          m3b1_en_n=1;
          m3b2_en_n=m3_en_n;
        end
    end
    
endmodule  
  
                 
