/*
 *  Description: Video Engine Interconnection
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : ve653a
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
 *  6-JUN-97:  Introduce bypass wire
 * 10-JUN-97:  acb_config, gnbase & mu
 * 29-AUG-97:  mu extended to 8 bits
*/

module  ve653a(
  vp_clk,
  rx_VP_PCLK, 
  rx_ld,
  data_valid,
  rx_DATA_IMMINENT,
  rstxxa_n,
  rx_do,
  correct,
  filtercode,
  offset,
  rcomp,
  g1comp,
  g2comp,
  bcomp,
  m00,
  n00,
  m01,
  n01,
  m02,
  n02,
  m10,
  n10,
  m11,
  n11,
  m12,
  n12,
  m20,
  n20,
  m21,
  n21,
  m22,
  n22,
  apcor,
  gamcor,
  linespace,
  accscale,
  zcode0,
  zcode1,
  zcode2,
  zcode3,
  hjog,
  vjog,
  evenfirst,
  skip,
  qcif,
  zoom,
  thresh,
  color_bars,
  self_timing,
  vp_dmcode,
  acb_config,
  acb_gnbase,
  acb_mu,
  LINE_NUMBER,
  hz30,
  defcor,
  racc,
  gacc,
  bacc,
  black_acc,
  exp_acc,
  lacc0,
  lacc1,
  lacc2,
  lacc3,
  lacc4,
  lacc5,
  lacc6,
  lacc7,
  acb00,
  acb01,
  acb02,	 
  acb10,	 
  acb11,	 
  acb12,	 
  acb20,	 
  acb21,	 
  acb22,
  vo,
  fclk,
  ve_end_of_frame,
  f_int,
  fst,
  lst,
  odd,
  yuvnot
);

  input           vp_clk,
                  rx_VP_PCLK;

  input     [2:0] rx_ld;

  input           data_valid,
                  rx_DATA_IMMINENT,
                  rstxxa_n;
  
  input     [7:0] rx_do;
  
  input           correct;

  input     [1:0] filtercode;

  input     [7:0] offset,
                  rcomp,
                  g1comp,
                  g2comp,
                  bcomp,
                  m00,
                  n00,
                  m01,
                  n01,
                  m02,
                  n02,
                  m10,
                  n10,
                  m11,
                  n11,
                  m12,
                  n12,
                  m20,
                  n20,
                  m21,
                  n21,
                  m22,
                  n22,
                  apcor;

  input     [3:0] gamcor;

  input     [3:0] linespace;

  input     [2:0] accscale;

  input     [7:0] zcode0,
                  zcode1,
                  zcode2,
                  zcode3;

  input           hjog,
                  vjog,
                  evenfirst,
                  skip,
                  qcif,
                  zoom;

  input     [7:0] thresh,
		  vp_dmcode,
                  acb_config,
                  acb_gnbase,
                  acb_mu;

  input           color_bars,
                  self_timing;

  input     [8:0] LINE_NUMBER;

  input           hz30;

  input     [5:0] defcor;

  output    [7:0] racc,
                  gacc,
                  bacc,
                  black_acc,
                  exp_acc,
                  lacc0,
                  lacc1,
                  lacc2,
                  lacc3,
                  lacc4,
                  lacc5,
                  lacc6,
                  lacc7,
                  acb22,
		  acb21,
		  acb20,
		  acb12,
		  acb11,
		  acb10,
		  acb02,
		  acb01,
		  acb00;


  output    [7:0] vo;

  output          fclk,
                  ve_end_of_frame,
                  f_int,
                  fst,
                  lst;

  input           odd;
  input           yuvnot;

  wire      [3:0] apthresh = apcor[7:4];

  wire      [3:0] apintens = apcor[3:0];

  wire      [4:0] defcoef  = defcor[4:0];

  wire            defenab  = ~defcor[5] & correct;
  wire            acb_remote = ~acb_config[0];
  wire            acb_freeze = acb_config[1];
  wire            acb_pregain = acb_config[2];


vpe653a vpe (
  .vjog(vjog), 
  .vp_clk(vp_clk), 
  .qcif(qcif), 
  .hz30(hz30),
  .evenfirst(evenfirst), 
  .self_timing(self_timing), 
  .ycof22(m22),
  .ycof21(m21), 
  .ycof20(m20), 
  .ycof12(m12), 
  .ycof11(m11), 
  .ycof10(m10),
  .ycof02(m02), 
  .ycof01(m01), 
  .ycof00(m00), 
  .rcof22(n22), 
  .rcof21(n21),
  .rcof20(n20), 
  .rcof12(n12), 
  .rcof11(n11), 
  .rcof10(n10), 
  .rcof02(n02),
  .rcof01(n01), 
  .rcof00(n00), 
  .gamcor(gamcor), 
  .apthresh(apthresh),
  .apcor(apintens), 
  .zcode3(zcode3), 
  .zcode2(zcode2), 
  .zcode1(zcode1),
  .zcode0(zcode0), 
  .accscale(accscale), 
  .ve_end_of_frame(ve_end_of_frame),
  .thresh(thresh), 
  .exp_acc(exp_acc), 
  .racc(racc), 
  .gacc(gacc), 
  .bacc(bacc),
  .vo(vo), 
  .fclk(fclk), 
  .lacc7(lacc7), 
  .lacc6(lacc6),
  .lacc5(lacc5), 
  .lacc4(lacc4), 
  .lacc3(lacc3), 
  .lacc2(lacc2), 
  .lacc1(lacc1),
  .lacc0(lacc0), 
  .black_acc(black_acc), 
  .hjog(hjog), 
  .rx_do(rx_do), 
  .offset(offset),
  .rcomp(rcomp), 
  .g2comp(g2comp), 
  .g1comp(g1comp), 
  .bcomp(bcomp),
  .filtercode(filtercode), 
  .correct(defenab), 
  .defcor(defcoef),
  .color_bars(color_bars), 
  .rx_DATA_IMMINENT(rx_DATA_IMMINENT), 
  .data_valid(data_valid),
  .rx_VP_PCLK(rx_VP_PCLK), 
  .resetb(rstxxa_n), 
  .linespace(linespace),
  .rx_ld(rx_ld), 
  .rxlcnt(LINE_NUMBER), 
  .skip(skip), 
  .zoom(zoom),
  .vp_dmcode(vp_dmcode),
  .f_int(f_int), 
  .fst(fst), 
  .lst(lst),
  .odd(odd),
  .yuvnot(yuvnot),
  .acb_gnbase(acb_gnbase[3:0]),
  .acb_mu(acb_mu),
  .acb_remote(acb_remote),
  .acb_freeze(acb_freeze),
  .acb_pregain(acb_pregain),
  .acb22(acb22), 
  .acb21(acb21), 
  .acb20(acb20), 
  .acb12(acb12), 
  .acb11(acb11), 
  .acb10(acb10), 
  .acb02(acb02),
  .acb01(acb01), 
  .acb00(acb00) 
);

endmodule
