/*
 *  Description: Receiver Interconnection
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : rx653a
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/

module rx653a (
               vi, 
               clk14, 
               rstxxa_n, 
               CAMERA_X, 
               SOFDATA_IMMINENT, 
               DATA_OUT, 
               LINE_CODE, 
               DATA_VALID, 
               DATA_VALID_PRE, 
               DATA_VALID_POSEN,
               DATA_IMMINENT, 
               PHASE_ERROR, 
               NIBBLE_ERROR,
               BYTE_ERROR, 
               SENSOR_CLOCK, 
               vp_clk, 
               rx_VP_PCLK, 
               CLKDIV,
               HOT_PHASEIN,
               OVERRIDE,
               self_timing,
               ERROR_MASK,
               fineh,
               finel,
               coarseh,
               coarsel,
               cam_gain,
               LINE_NUMBER,
               HOT_PHASEOUT,
               cam_devicel,
               cam_deviceh,
               cam_statin,
               sft_rst
              );

  input  [3:0] vi;
  input        clk14, 
               rstxxa_n;
  output [7:0] DATA_OUT;
  output [2:0] LINE_CODE;
  output       DATA_VALID, 
               DATA_VALID_PRE, 
               DATA_VALID_POSEN, 
               DATA_IMMINENT, 
               SOFDATA_IMMINENT, 
               PHASE_ERROR;
  output       NIBBLE_ERROR, 
               BYTE_ERROR, 
               SENSOR_CLOCK;
  output       CAMERA_X, 
               vp_clk, 
               rx_VP_PCLK;

//  inout [599:0] all_buns;

  input  [1:0] CLKDIV;
  input  [1:0] HOT_PHASEIN;
  input        OVERRIDE;
  input        self_timing;
  input        ERROR_MASK;

  output       fineh;
  output [7:0] finel;
  output       coarseh;
  output [7:0] coarsel;
  output [2:0] cam_gain;
  output [8:0] LINE_NUMBER;
  output [1:0] HOT_PHASEOUT;
  output [7:0] cam_devicel;
  output [7:0] cam_deviceh;
  output [5:0] cam_statin;

  input [1:0] sft_rst;

  reg fineh, coarseh;
  reg [7:0] finel, coarsel;
  reg [2:0] cam_gain;
  reg [7:0] cam_devicel,cam_deviceh;
  reg [4:0] cam_status;
  reg [6:0] cam_irq;

  wire [1:0] CLKDIV, HOT_PHASEIN, HOT_PHASEOUT;
  wire OVERRIDE;
  wire [7:0] SOFDATA_OUT;
  wire [8:0] PIXEL_COUNT, LINE_NUMBER;

//  wire RESETB = ~(sft_rst[1] | ~rstxxa_n); // cam_setup0[2]

  RECEIVER rec_ (
    .clk14(clk14), 
    .rx_sftrst_n(~sft_rst[1]), 
    .vi(vi), 
    .INHIBIT_96(sft_rst[0]), 
    .CLKDIV(CLKDIV),
    .BYTE_ERROR(rec_BYTE_ERROR), 
    .NIBBLE_ERROR(rec_NIBBLE_ERROR), 
    .LINE_NUMBER(LINE_NUMBER), 
    .LINE_CODE(LINE_CODE),
    .SENSOR_CLOCK(SENSOR_CLOCK), 
    .DATA_OUT(DATA_OUT), 
    .DATA_VALID(DATA_VALID), 
    .DATA_VALID_PRE(DATA_VALID_PRE), 
    .DATA_VALID_POSEN(DATA_VALID_POSEN), 
    .DATA_IMMINENT(DATA_IMMINENT),
    .HOT_PHASEIN(HOT_PHASEIN), 
    .HOT_PHASEOUT(HOT_PHASEOUT), 
    .PHASE_ERROR(rec_PHASE_ERROR), 
    .NO_CAMERA(NO_CAMERA), 
    .vp_clk(vp_clk), 
    .VP_CLOCKME(self_timing),
    .rx_VP_PCLK(rx_VP_PCLK), 
    .OVERRIDE(OVERRIDE), 
    .SOFDATA_OUT(SOFDATA_OUT), 
    .SOFDATA_VALID(SOFDATA_VALID), 
    .SOFDATA_VALID_negen(SOFDATA_VALID_negen), 
    .SOFDATA_IMMINENT(SOFDATA_IMMINENT),
    .PIXEL_COUNT(PIXEL_COUNT), 
    .rstxxa_n(rstxxa_n), 
    .ERROR_MASK(ERROR_MASK)
    );

  assign cam_statin = {~NO_CAMERA,cam_status};


// edge detector for error conditions.
  always @ (posedge vp_clk or negedge rstxxa_n)   
    if (!rstxxa_n)
      cam_irq <= 0;
    else
      cam_irq <= {{rec_BYTE_ERROR, rec_NIBBLE_ERROR, rec_PHASE_ERROR} & ~cam_irq[2:0],
        NO_CAMERA, rec_BYTE_ERROR, rec_NIBBLE_ERROR, rec_PHASE_ERROR};
  
  assign CAMERA_X = NO_CAMERA ^ cam_irq[3];
  assign {BYTE_ERROR, NIBBLE_ERROR, PHASE_ERROR} = cam_irq[6:4]; 

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         begin
            fineh       <= 0; 
            finel       <= 0; 
            coarseh     <= 0; 
            coarsel     <= 0;
            cam_gain    <= 0; 
            cam_devicel <= 0; 
            cam_deviceh <= 0; 
            cam_status  <= 0;
         end//Following added instead of case statements to aid synthesis SE
      else
         if (SOFDATA_VALID_negen)
            if (PIXEL_COUNT == 'h42)
               begin
                  fineh       <= SOFDATA_OUT;
                  finel       <= finel; 
                  coarseh     <= coarseh; 
                  coarsel     <= coarsel;
                  cam_gain    <= cam_gain; 
                  cam_devicel <= cam_devicel; 
                  cam_deviceh <= cam_deviceh; 
                  cam_status  <= cam_status;
               end
            else
            if (PIXEL_COUNT == 'h44) 
               begin
                  fineh       <= fineh;
                  finel       <= SOFDATA_OUT;
                  coarseh     <= coarseh; 
                  coarsel     <= coarsel;
                  cam_gain    <= cam_gain; 
                  cam_devicel <= cam_devicel; 
                  cam_deviceh <= cam_deviceh; 
                  cam_status  <= cam_status;
               end
            else
            if (PIXEL_COUNT == 'h46) 
               begin
                  fineh       <= fineh;
                  finel       <= finel; 
                  coarseh     <= SOFDATA_OUT;
                  coarsel     <= coarsel;
                  cam_gain    <= cam_gain; 
                  cam_devicel <= cam_devicel; 
                  cam_deviceh <= cam_deviceh; 
                  cam_status  <= cam_status;
               end
            else
            if (PIXEL_COUNT == 'h48) 
               begin
                  fineh       <= fineh;
                  finel       <= finel; 
                  coarseh     <= coarseh; 
                  coarsel     <= SOFDATA_OUT;
                  cam_gain    <= cam_gain; 
                  cam_devicel <= cam_devicel; 
                  cam_deviceh <= cam_deviceh; 
                  cam_status  <= cam_status;
               end
            else
            if (PIXEL_COUNT == 'h4a) 
               begin
                  fineh       <= fineh;
                  finel       <= finel; 
                  coarseh     <= coarseh; 
                  coarsel     <= coarsel;
                  cam_gain    <= SOFDATA_OUT;
                  cam_devicel <= cam_devicel; 
                  cam_deviceh <= cam_deviceh; 
                  cam_status  <= cam_status;
               end
            else 
            if (PIXEL_COUNT == 'h02) 
               begin
                  fineh       <= fineh;
                  finel       <= finel; 
                  coarseh     <= coarseh; 
                  coarsel     <= coarsel;
                  cam_gain    <= cam_gain; 
                  cam_devicel <= SOFDATA_OUT;
                  cam_deviceh <= cam_deviceh; 
                  cam_status  <= cam_status;
               end
            else 
            if (PIXEL_COUNT == 'h04) 
               begin
                  fineh       <= fineh;
                  finel       <= finel; 
                  coarseh     <= coarseh; 
                  coarsel     <= coarsel;
                  cam_gain    <= cam_gain; 
                  cam_devicel <= cam_devicel; 
                  cam_deviceh <= SOFDATA_OUT;
                  cam_status  <= cam_status;
               end
            else 
            if (PIXEL_COUNT == 'h06) 
               begin
                  fineh       <= fineh;
                  finel       <= finel; 
                  coarseh     <= coarseh; 
                  coarsel     <= coarsel;
                  cam_gain    <= cam_gain; 
                  cam_devicel <= cam_devicel; 
                  cam_deviceh <= cam_deviceh; 
                  cam_status  <= SOFDATA_OUT;
               end
            else 
               begin
                  fineh       <= fineh;
                  finel       <= finel; 
                  coarseh     <= coarseh; 
                  coarsel     <= coarsel;
                  cam_gain    <= cam_gain; 
                  cam_devicel <= cam_devicel; 
                  cam_deviceh <= cam_deviceh; 
                  cam_status  <= cam_status;
               end
         else
            begin
               fineh       <= fineh;
               finel       <= finel; 
               coarseh     <= coarseh; 
               coarsel     <= coarsel;
               cam_gain    <= cam_gain; 
               cam_devicel <= cam_devicel; 
               cam_deviceh <= cam_deviceh; 
               cam_status  <= cam_status;
            end
    end


endmodule //of rx653
