/*
 *  Description: Line RAM Instantiation
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : rgbrams
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/

`timescale 1ns / 10ps

module rgbrams(out3, out2, out1, out0, web3, web2, web1, web0, in3, in2,
        in1, in0, ceb3, ceb2, ceb1, ceb0, ad1, ad0);

  output [7:0] out3;
  output [7:0] out2;
  output [7:0] out1;
  output [7:0] out0;
  input  web3;
  input  web2;
  input  web1;
  input  web0;
  input  [7:0] in3;
  input  [7:0] in2;
  input  [7:0] in1;
  input  [7:0] in0;
  input  ceb3;
  input  ceb2;
  input  ceb1;
  input  ceb0;
  input  [8:0] ad1;
  input  [8:0] ad0;


  supply1 VDD;
  supply0 VSS;


  SRAM356X8 u3(
               .CEB(ceb2), 
               .WEB(web2), 
               .A(ad1[8:0]), 
               .IN(in2[7:0]), 
               .OUT(out2[7:0]), 
               .OEB(VSS)
              );
  SRAM356X8 u2(
               .CEB(ceb1), 
               .WEB(web1), 
               .A(ad1[8:0]), 
               .IN(in1[7:0]), 
               .OUT(out1[7:0]), 
               .OEB(VSS)
              );
  SRAM356X8 u4(
               .CEB(ceb3), 
               .WEB(web3), 
               .A(ad1[8:0]), 
               .IN(in3[7:0]), 
               .OUT(out3[7:0]), 
               .OEB(VSS)
              );
  SRAM356X8 u1(
               .CEB(ceb0), 
               .WEB(web0), 
               .A(ad0[8:0]), 
               .IN(in0[7:0]), 
               .OUT(out0[7:0]), 
               .OEB(VSS)
              );


endmodule
// ----------------------------------------------
