/*
 *  Description: RGB Interploation
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : rgb_interp
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/

//--------------------------------------------------------------


/*****************************************************************
Smooth RGB and Sharp G generation
some resourceful resource-sharing here
*****************************************************************/

module rgb_interp (
                   lin0, 
                   lin1, 
                   lin2, 
                   lin3, 
                   vp_clk, 
                   rx_VP_PCLK, 
                   resetb,
                   pclkd1, 
                   pclkd2, 
                   menv, 
                   intqcif, 
                   gseflag, 
                   rsflag, 
                   smooth, 
                   ushp12, 
                   monoout
                  );

input   [7:0] lin0, 
              lin1, 
              lin2, 
              lin3;
input         pclkd1, 
              pclkd2;
input         vp_clk, 
              rx_VP_PCLK, 
              resetb, 
              menv, 
              intqcif, 
              gseflag, 
              rsflag;
output  [7:0] smooth, 
              monoout;
output [11:0] ushp12;
reg     [7:0] smooth, 
              monoout;
reg     [7:0] smoothchoice;
reg     [7:0] rsmooth, 
              bsmooth;
wire    [8:0] insum11, 
              midsum, 
              outersum;
wire    [9:0] insum, 
              insum11u1, 
              midsumu1, 
              cornersum;
wire          rsel, 
              gsel;
reg     [7:0] ix3sig, 
              ix1sig;
reg     [7:0] gouter, 
              ginner, 
              gouterd1, 
              ginnerd1;
reg     [8:0] midsumd1, 
              midsumd2;
reg     [9:0] ox3sig, 
              ox1sig;
reg     [9:0] insumd1, 
              insumd2, 
              insumd3, 
              cornersumd1, 
              cornersumd2, 
              cornersumd3, 
              cornersumd4;
reg    [10:0] softcold1, 
              softcold2, 
              softcold3, 
              softcold4;
reg    [11:0] ushp12;
wire   [10:0] outsum11, 
              softcol, 
              squaresum;
wire   [11:0] outsumu4, 
              squaresumu1, 
              outersoft, 
              ushp12early;
wire   [12:0] gsmoothu5;
wire   [12:0] gsharpu3;
wire   [14:0] ushpu5;
wire    [7:0] line0, 
              line1, 
              line2, 
              line3;
wire    [7:0] gsmooth;
wire    [7:0] outsum;
reg           pclkd3, 
              qcifoff;

// generate pclkd3 locally for synth/loading reasons
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
			pclkd3 <= 0;
		else
			pclkd3 <= pclkd2;
	end
	
// red out flag, allows sharing of red & blue interpolation back ends
	assign rsel = pclkd1 | pclkd2;
	assign gsel = pclkd1 | pclkd3;

// envelopes
	assign line0 = (menv & !(intqcif & rsflag)) ? lin0 : 0;
	assign line1 = (menv & !(intqcif & rsflag)) ? lin1 : 0;
	assign line2 = (menv & !(intqcif & rsflag)) ? lin2 : 0;
	assign line3 = (menv & !(intqcif & rsflag)) ? lin3 : 0;

// input G switchbox
// in QCIF, ginner and gouter are red and new green - so we re-use storage for late reds
	always @ (line0 or line1 or line2 or line3 or gseflag or intqcif) begin
		case(gseflag)
			0:	begin
					gouter = line0;
					ginner = line2;
				end
			1:	begin
					gouter = intqcif ? line0 : line3;
					ginner = intqcif ? line2 : line1;
				end
		endcase
	end

// pipelined sombrero filters for smooth and sharp G
	assign midsumu1 = intqcif ? {line2,1'b1} + {line2,1'b1} :
								{ginner,1'b1} + {ginnerd1,1'b1};
	assign midsum = midsumu1[9:1];
	assign outersum = gouter + gouterd1;
	assign cornersum = intqcif ? {line0,1'b0} + {line3,1'b0} : midsum + outersum;
	assign softcol = cornersum + {midsum,1'b1};
	assign outersoft = intqcif ? softcol + softcold4 : softcol + softcold2;
	assign gsmoothu5 = intqcif ? outersoft + {softcold2,1'b0} :
								outersoft + {softcold1,1'b0};
	assign gsmooth = gsmoothu5[12:5];
	assign squaresumu1 = intqcif ? {cornersum,1'b1} + {cornersumd4,1'b1} :
								{cornersum,1'b1} + {cornersumd2,1'b1};
	assign squaresum = squaresumu1[11:1];
	assign gsharpu3 = intqcif ? {1'b0,midsumd2,3'd0} - {2'd0,squaresum} :
								{1'b0,midsumd1,3'd0} - {2'd0,squaresum};
	assign ushpu5 = {gsharpu3,2'd0} - {2'd0,gsmoothu5};
	assign ushp12early = ushpu5[14:3];

// input R & B switchbox
	always @ (line0 or line1 or line2 or line3 or
				ginnerd1 or gouterd1 or gseflag or intqcif) begin
		case(gseflag)
			0:	begin
					ix3sig = line1;
					ix1sig = line3;
				end
			1:	begin
					ix3sig = intqcif ? ginnerd1 : line2;
					ix1sig = intqcif ? gouterd1 : line0;
				end
		endcase
	end

// partial sums comprising 3 of one input plus the other, rounding
// used once per memory/pixel cycle
	assign insum11u1 = {ix3sig,1'b1}+ {ix1sig,1'b1};
	assign insum11 = insum11u1[9:1];
	assign insum = insum11 + {ix3sig,1'b1};

// output R & B switchbox
	always @ (insum or insumd1 or insumd2 or insumd3
					or rsflag or gseflag or rsel or intqcif) begin
		case({rsflag,gseflag,rsel})
			0:	begin
					ox3sig = insumd2;
					ox1sig = insum;
				end
			1:	begin
					ox3sig = insumd1;
					ox1sig = insumd3;
				end
			2:	begin
					ox3sig = insumd1;
					ox1sig = insumd3;
				end
			3:	begin
					ox3sig = intqcif ? insum : insumd2;
					ox1sig = intqcif ? insumd2 : insum;
				end
			4:	begin
					ox3sig = insumd1;
					ox1sig = insumd3;
				end
			5:	begin
					ox3sig = insumd2;
					ox1sig = insum;
				end
			6:	begin
					ox3sig = insumd2;
					ox1sig = insum;
				end
			7:	begin
					ox3sig = insumd1;
					ox1sig = insumd3;
				end
		endcase
	end

// output sums comprising 3 of one partial plus the other, non-rounding
// downshift 4 uses earlier rounding
// used twice per memory/pixel cycle
	assign outsum11 = ox3sig + ox1sig;
	assign outsumu4 = outsum11 + {ox3sig,1'b0};
	assign outsum = outsumu4[11:4];

// store partial R & B 3x+y sums, G inner, outer, cornersums, midsums and soft columns
// big area history needed for QCIF unfortunately
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			cornersumd4 <= 0;
			cornersumd3 <= 0;
			cornersumd2 <= 0;
			cornersumd1 <= 0;
			softcold4 <= 0;
			softcold3 <= 0;
			softcold2 <= 0;
			softcold1 <= 0;
			gouterd1 <= 0;
			ginnerd1 <= 0;
			insumd3 <= 0;
			insumd2 <= 0;
			insumd1 <= 0;
			midsumd2 <= 0;
			midsumd1 <= 0;
		end else begin
			cornersumd4 <= rx_VP_PCLK ? cornersumd3 : cornersumd4;
			cornersumd3 <= rx_VP_PCLK ? cornersumd2 : cornersumd3;
			cornersumd2 <= rx_VP_PCLK ? cornersumd1 : cornersumd2;
			cornersumd1 <= rx_VP_PCLK ? cornersum : cornersumd1;
			softcold4 <= rx_VP_PCLK ? softcold3 : softcold4;
			softcold3 <= rx_VP_PCLK ? softcold2 : softcold3;
			softcold2 <= rx_VP_PCLK ? softcold1 : softcold2;
			softcold1 <= rx_VP_PCLK ? softcol : softcold1;
			gouterd1 <= rx_VP_PCLK ? gouter : gouterd1;
			ginnerd1 <= rx_VP_PCLK ? ginner : ginnerd1;
			insumd3 <= rx_VP_PCLK ? insumd2 : insumd3;
			insumd2 <= rx_VP_PCLK ? insumd1 : insumd2;
			insumd1 <= rx_VP_PCLK ? insum : insumd1;
			midsumd2 <= rx_VP_PCLK ? midsumd1 : midsumd2;
			midsumd1 <= rx_VP_PCLK ? midsum : midsumd1;
		end
	end

// catch smooth R for stable pickup by vp_clk

// catch smooth B for stable pickup by vp_clk

// catch unsharp for apcor
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			ushp12 <= 0;
		end else begin
			ushp12 <= pclkd2 ? (qcifoff ? 0 : ushp12early) : ushp12;
		end
	end

// catch G smooth for exp monitor
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			monoout <= 0;
		end else begin
			monoout <= pclkd3 ? (qcifoff ? 0 : gsmooth) : monoout;
		end
	end

// select output

// turn off non-pixels in QCIF mode
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			qcifoff <= 0;
		end else begin
			qcifoff <= pclkd1 ? (intqcif & (rsflag | !gseflag)) : qcifoff;
		end
	end

// clock out
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			smooth <= 0;
		end else begin
//			smooth <= qcifoff ? 0 : smoothchoice;
			case ({qcifoff,rsel,gsel})
						2: smooth <= outsum; // R
						1: smooth <= gsmooth; // G
						0: smooth <= outsum; // B
						3: smooth <= smooth; // B held
					default: smooth <= 0; 	// suppressed in QCIF mode
			endcase
		end
	end

endmodule
