/*
 *  Description: Line RAM Output Buffer
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : ramcatch
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/

module ramcatch (vp_clk,
                 resetb,
                 intqcif,
                 rsflag,
                 ramadd,
                 rcatch0_posen,
                 rcatch1_posen,
                 rcatch2_posen,
                 rcatch3_posen,
				in0, in1, in2, in3, out0, out1, out2, out3);
	input [7:0] in0, in1, in2, in3;
        input vp_clk, 
              resetb, 
              intqcif, 
              rsflag, 
              ramadd, 
              rcatch0_posen, 
              rcatch1_posen, 
              rcatch2_posen, 
              rcatch3_posen;
	output [7:0] out0, out1, out2, out3;
	reg [7:0] out0, out1, out2, out3;
	wire [8:0] gsum;
	wire [7:0] gsumds1;

	assign gsum = in0 + in1;
	assign gsumds1 = gsum[8:1];

        always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			out0 <= 0;
		end else begin
                        if (rcatch0_posen)
                           out0 <= in0;
                        else
                           out0 <= out0;
		end
	end

        always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			out1 <= 0;
		end else begin
                        if (rcatch1_posen)
                           out1 <= (intqcif & rsflag & ramadd) ? gsumds1 : in1;
                        else
                           out1 <= out1;
		end
	end

        always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			out2 <= 0;
		end else begin
                        if (rcatch2_posen)
                           out2 <= in2;
                        else
                           out2 <= out2;
		end
	end

        always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			out3 <= 0;
		end else begin
                        if (rcatch3_posen)
                           out3 <= in3;
                        else
                           out3 <= out3;
		end
	end

endmodule
