/*
 *  Description: Pixel Clock gen.
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : pxlclkgen
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/





module pxlclkgen (
                  vp_clk,
                  enph0,
                  enph2,
                  rstxxa_n, 
                  rx_sftrst_n, 
                  NO_CAMERA, 
                  VP_CLOCKME, 
                  TOPNIBBLE, 
                  rx_VP_PCLK
                 );

input        vp_clk, 
             enph0,  
             enph2,  
             rstxxa_n,  
             rx_sftrst_n,  
             NO_CAMERA,  
             VP_CLOCKME,  
             TOPNIBBLE;

output       rx_VP_PCLK;

reg          rx_VP_PCLK, 
             TNIBBLE;
wire         ASYNCTNIB;

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         TNIBBLE <= 1'b0;
      else
         if (!rx_sftrst_n)
            TNIBBLE <= 1'b0;
         else
            if (enph0)
               TNIBBLE <= TOPNIBBLE;
            else
               TNIBBLE <= TNIBBLE;
   end

assign ASYNCTNIB = TNIBBLE & enph2;

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         rx_VP_PCLK <= 1'b0;
      else
         if (!rx_sftrst_n)
            rx_VP_PCLK <= 1'b0;
         else
            if (NO_CAMERA & (~VP_CLOCKME))
               rx_VP_PCLK <= 1'b0;
            else
               rx_VP_PCLK <= ASYNCTNIB;
end

endmodule //
