/*
 *  Description: Sample Phase Selector
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : phasesel
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/



module phasesel (
                 vp_clk,
                 rstxxa_n,         //Asynchronous
                 rx_sftrst_n,      //clocked by clk14
                 enph0,            //clocked by vp_clk
                 sync_hotphasein,  //clocked by vp_clk
                 sync_override,    //clocked by vp_clk
                 end_of_lock,      //combin from vp_clk
                 ph0data,          //clocked by vp_clk
                 ph1data,          //clocked by vp_clk_n
                 ph2data,          //clocked by vp_clk
                 ph3data,          //clocked by vp_clk_n
                 ok0_ph0,          //clocked by vp_clk 
                 sync_ok0_ph1,     //clocked by vp_clk 
                 ok0_ph2,          //clocked by vp_clk 
                 sync_ok0_ph3,     //clocked by vp_clk 
                 ok1_ph0,          //clocked by vp_clk
                 sync_ok1_ph1,     //clocked by vp_clk
                 ok1_ph2,          //clocked by vp_clk
                 sync_ok1_ph3,     //clocked by vp_clk
                 gooddata,         //clocked by vp_clk
                 fail,             //clocked by vp_clk
                 hotphaseout       //clocked by vp_clk
                );

        
input        vp_clk,
             rstxxa_n,
             rx_sftrst_n,
             enph0;
input  [1:0] sync_hotphasein;
input        sync_override,
             end_of_lock;
input  [3:0] ph0data,
             ph1data,
             ph2data,
             ph3data,
             ok0_ph0,
             sync_ok0_ph1,
             ok0_ph2,
             sync_ok0_ph3,
             ok1_ph0,
             sync_ok1_ph1,
             ok1_ph2,
             sync_ok1_ph3;

output [3:0] gooddata;
output       fail;
output [1:0] hotphaseout;


reg    [3:0] gooddata;
reg          fail;
reg    [1:0] hotphaseout;

reg    [3:0] found9;
reg          int_fail;
reg    [1:0] int_phase;

 
reg          okp0,
             okp1, 
             okp2, 
             okp3;

   always @(ok0_ph0 or 
            sync_ok0_ph1 or 
            ok0_ph2 or 
            sync_ok0_ph3 or 
            ok1_ph0 or 
            sync_ok1_ph1 or 
            ok1_ph2 or 
            sync_ok1_ph3
           ) 
      begin
         okp0 =  ((ok0_ph0[3] | ok1_ph0[3]) & 
                  (ok0_ph0[2] | ok1_ph0[2]) &
                  (ok0_ph0[1] | ok1_ph0[1]) &
                  (ok0_ph0[0] | ok1_ph0[0]));
         okp1 =  ((sync_ok0_ph1[3] | sync_ok1_ph1[3]) & 
                  (sync_ok0_ph1[2] | sync_ok1_ph1[2]) &
                  (sync_ok0_ph1[1] | sync_ok1_ph1[1]) &
                  (sync_ok0_ph1[0] | sync_ok1_ph1[0]));
         okp2 =  ((ok0_ph2[3] | ok1_ph2[3]) & 
                  (ok0_ph2[2] | ok1_ph2[2]) &
                  (ok0_ph2[1] | ok1_ph2[1]) &
                  (ok0_ph2[0] | ok1_ph2[0]));
         okp3 =  ((sync_ok0_ph3[3] | sync_ok1_ph3[3]) & 
                  (sync_ok0_ph3[2] | sync_ok1_ph3[2]) &
                  (sync_ok0_ph3[1] | sync_ok1_ph3[1]) &
                  (sync_ok0_ph3[0] | sync_ok1_ph3[0]));
      end

//for marginal case when all data is good
//First  : look for ok0_ph[3:0] = 9 (other option is 6 if bus is assumed
//         to be kept together)
//Second : the found9 bus is used to see where the split in the data
//         values occurs.
//However: the result will depend upon the time at which the comparison
//         with 9 is done.
//         If enph0 is 1, the comparison is being made after all 4
//         ok0_ph[3:0] values have been updated.
//         If enph0 is 0, the comparison is being made after the update
//         of only 2 phases so we invert the value for 2 of the phases.
//
//
   always @(ph0data or
            ph1data or
            ph2data or
            ph3data or
            enph0
           )
      begin
         
         if (ph0data == 4'b1001)
            found9[0] = 1'b1;
         else
            found9[0] = 1'b0;
         if (ph1data == 4'b1001)
            found9[1] = 1'b1;
         else
            found9[1] = 1'b0;
         if (ph2data == 4'b1001)
            found9[2] = enph0;
         else
            found9[2] = ~enph0;
         if (ph3data == 4'b1001)
            found9[3] = enph0;
         else
            found9[3] = ~enph0;

      end


//Choice of int_phase and int_fail
   always @(okp0 or
            okp1 or
            okp2 or
            okp3 or
            found9 or
            sync_hotphasein
           )
      begin
         case ({okp0,okp1,okp2,okp3})
            4'b0000,
            4'b0001,
            4'b0010,
            4'b0011,
            4'b0100,
            4'b0101,
            4'b0110,
            4'b1000,
            4'b1001,
            4'b1010,
            4'b1100 : begin 
                         int_phase = sync_hotphasein; 
                         int_fail  = 1; 
                      end
            4'b0111 : begin
                         int_phase = 2'b10; 
                         int_fail  = 0; 
                      end
            4'b1011 : begin
                         int_phase = 2'b11; 
                         int_fail  = 0; 
                      end
            4'b1101 : begin
                         int_phase = 2'b00; 
                         int_fail  = 0; 
                      end
            4'b1110 : begin
                         int_phase = 2'b01; 
                         int_fail  = 0; 
                      end
            4'b1111 : begin
                         int_fail  = 0; 
                         case (found9)
                            4'b0000,
                            4'b1111 : int_phase = 2'b10; 
                            4'b0001,
                            4'b1110 : int_phase = 2'b11; 
                            4'b0011,
                            4'b1100 : int_phase = 2'b00; 
                            4'b0111,
                            4'b1000 : int_phase = 2'b01; 
                            4'b0010,
                            4'b0100,
                            4'b0101,
                            4'b0110,
                            4'b1001,
                            4'b1010,
                            4'b1011,
                            4'b1101 : int_phase = 2'b00;//Ought never reach here
                                                        //because all these
                                                        //options indicate data
                                                        //shorter than 4 phases
                         endcase
                      end
         endcase
      end


always @(posedge vp_clk or negedge rstxxa_n)
   if (!rstxxa_n) 
      begin
         gooddata    <= 4'b0000;
         hotphaseout <= 2'b00;
         fail        <= 0;
      end
   else
      if (!rx_sftrst_n) 
         begin
            gooddata    <= 4'b0000;
            hotphaseout <= 2'b00;
            fail        <= 0;
         end
      else
         begin
            if (enph0)
               case (hotphaseout)
                  4'b00 : begin
                             gooddata    <= ph0data;
                          end
                  4'b01 : begin
                             gooddata    <= ph1data;
                          end
                  4'b10 : begin
                             gooddata    <= ph2data;
                          end
                  4'b11 : begin
                             gooddata    <= ph3data;
                          end
               endcase
            else
               begin
                  gooddata    <= gooddata;
               end
            if (sync_override)
               begin
                  hotphaseout <= sync_hotphasein;
                  fail        <= 1'b0;
               end
            else
               if (end_of_lock)
                  begin
                     if (!int_fail)
                        hotphaseout <= int_phase;
                     else
                        hotphaseout <= sync_hotphasein;

                     fail        <= int_fail;
                  end
               else
                  begin
                     hotphaseout <= hotphaseout;
                     fail        <= fail;
                  end
         end



 
endmodule
