/*
 *  Description: Main Video Engine (top)
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : main
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
 * 05-JUN-97:  rewire as VVL653, expanded dmcode, framegrab signals
 * 06-JUN-97:  Introduce bypass mode and yuvnot
 * 09-JUN-97:  Replace 8-bit [rgb]acc with 12-bit [rgb]acci from m_mon outwards
*/
 

module main(
            vp_clk, 
            rx_VP_PCLK, 
            resetb,  
            qlinekill, 
            ugo1st,
            edg656,
            stndrd,
            vsolid,
            frerun,
            intpix,
            fldid,
            bypass,
            yuvnot,
            remote,
            lin0, 
            lin1, 
            lin2, 
            lin3,
            rcof00, 
            rcof01, 
            rcof02, 
            rcof10, 
            rcof11, 
            rcof12, 
            rcof20, 
            rcof21, 
            rcof22,
            ycof00, 
            ycof01, 
            ycof02, 
            ycof10, 
            ycof11, 
            ycof12, 
            ycof20, 
            ycof21, 
            ycof22,
            intskip,
            olcnt, 
            gamcorreg, 
            apcor, 
            apthresh,
            accscale, 
            thresh, 
            zonecode0, 
            zonecode1, 
            zonecode2, 
            zonecode3,
            vlenv, 
            menv, 
            intzoom, 
            intqcif, 
            gseflag, 
            rsflag, 
            oenv, 
            fclk, 
            vo,
            expacc, 
            racci, 
            gacci, 
            bacci, 
            f_int, 
            flenv, 
            llenv, 
            sof, 
            ve_end_of_frame, 
            eofe
           );

input  [7:0] lin0, 
             lin1, 
             lin2, 
             lin3;
input  [7:0] rcof00, 
             rcof01, 
             rcof02, 
             rcof10, 
             rcof11, 
             rcof12, 
             rcof20, 
             rcof21, 
             rcof22;
input  [7:0] ycof00, 
             ycof01, 
             ycof02, 
             ycof10, 
             ycof11, 
             ycof12, 
             ycof20, 
             ycof21, 
             ycof22;
input  [7:0] thresh, 
             zonecode0, 
             zonecode1, 
             zonecode2, 
             zonecode3;
input        ugo1st,
             edg656,
             stndrd,
             vsolid,
             frerun,
             intpix,
             fldid,
             yuvnot,
             remote,
             bypass;
input  [2:0] accscale;
input  [8:0] olcnt;
output [7:0] expacc;
output [11:0] racci, 
              gacci, 
              bacci;
output       fclk, 
             sof, 
             ve_end_of_frame, 
             eofe;
input        intskip,  
             qlinekill;
input  [3:0] gamcorreg, 
             apcor, 
             apthresh;
input        vp_clk, 
             rx_VP_PCLK, 
             resetb, 
             vlenv, 
             menv, 
             intzoom, 
             intqcif, 
             gseflag, 
             rsflag, 
             oenv;
input        f_int, 
             flenv, 
             llenv;
wire   [7:0] expacc; 
wire   [11:0] racci, 
              gacci, 
              bacci;
wire   [7:0] smooth, 
             monoout, 
             fullyuv;
wire   [8:0] matrixout;
wire         pclkd1, 
             pclkd2, 
             pclkd3;
wire  [11:0] ushpint;
wire   [8:0] gamcorout;
output [7:0] vo;

        ctrl_src   cl1 (
                        .vp_clk(vp_clk), 
                        .rx_VP_PCLK(rx_VP_PCLK), 
                        .resetb(resetb),
                        .pclkd1(pclkd1), 
                        .pclkd2(pclkd2), 
                        .pclkd3(pclkd3)
                       );

        rgb_interp rg1 (
                        .lin0(lin0), 
                        .lin1(lin1), 
                        .lin2(lin2), 
                        .lin3(lin3), 
                        .vp_clk(vp_clk), 
                        .rx_VP_PCLK(rx_VP_PCLK), 
                        .resetb(resetb), 
                        .pclkd1(pclkd1), 
                        .pclkd2(pclkd2), 
                        .menv(menv), 
                        .intqcif(intqcif), 
                        .gseflag(gseflag), 
                        .rsflag(rsflag), 
                        .smooth(smooth), 
                        .ushp12(ushpint), 
                        .monoout(monoout)
                       );
        matrix     ma1 (
                        .insig(smooth), 
                        .resetb(resetb), 
                        .vp_clk(vp_clk), 
                        .cof00(rcof00), 
                        .cof01(rcof01), 
                        .cof02(rcof02), 
                        .cof10(rcof10), 
                        .cof11(rcof11), 
                        .cof12(rcof12), 
                        .cof20(rcof20), 
                        .cof21(rcof21), 
                        .cof22(rcof22), 
                        .ushpin(ushpint), 
                        .oenv(oenv), 
                        .apcor(apcor), 
                        .apthresh(apthresh), 
                        .rhot(pclkd3), 
                        .pclkd1(pclkd1), 
                        .xhot(pclkd2), 
                        .out(matrixout), 
                        .oenvd2(oenvd2), 
                        .oenvd6(oenvd6)
                       );
        gamcor     ga1 (
                        .in(matrixout), 
                        .resetb(resetb), 
                        .vp_clk(vp_clk), 
                        .gamcorreg(gamcorreg), 
                        .out(gamcorout)
                       );
        colspace   co1 (
                        .insig(gamcorout), 
                        .resetb(resetb), 
                        .vp_clk(vp_clk), 
                        .cof00(ycof00), 
                        .cof01(ycof01), 
                        .cof02(ycof02), 
                        .cof10(ycof10), 
                        .cof11(ycof11), 
                        .cof12(ycof12), 
                        .intqcif(intqcif), 
                        .rsflag(rsflag), 
                        .gseflag(gseflag), 
                        .frerun(frerun),
                        .cof20(ycof20), 
                        .cof21(ycof21), 
                        .cof22(ycof22), 
                        .rhot(pclkd3), 
                        .ghot(rx_VP_PCLK), 
                        .pclkd1(pclkd1), 
                        .xhot(pclkd2), 
                        .oenvd6(oenvd6), 
                        .out(fullyuv)
                       );
        coder422   cod (
                        .in(fullyuv), 
                        .rawin(lin3), 
                        .rgbin(gamcorout[8:1]), 
                        .resetb(resetb), 
                        .vp_clk(vp_clk), 
                        .oenvd6(oenvd6), 
                        .intzoom(intzoom), 
                        .zenv(zenv), 
                        .f_int(f_int), 
                        .flenv(flenv), 
                        .llenv(llenv), 
                        .qlinekill(qlinekill), 
                        .ugo1st(ugo1st),
                        .edg656(edg656),
                        .stndrd(stndrd),
                        .frerun(frerun),
                        .intpix(intpix),
                        .fldid(fldid),
                        .bypass(bypass), 
                        .yuvnot(yuvnot),
                        .intqcif(intqcif), 
                        .uhot(pclkd2), 
                        .yhot(pclkd3), 
                        .vhot(rx_VP_PCLK), 
                        .xhot(pclkd1), 
                        .vo(vo), 
                        .fclk(fclk)
                       );

        m_mon      mm1 (
                        .vp_clk(vp_clk), 
                        .rx_VP_PCLK(rx_VP_PCLK), 
                        .pclkd1(pclkd1), 
                        .resetb(resetb), 
                        .oenv(oenv), 
                        .oenvd2(oenvd2), 
                        .vlenv(vlenv), 
                        .monosig(monoout), 
                        .matrixsig(matrixout[8:1]), 
                        .intqcif(intqcif), 
                        .accscale(accscale), 
                        .thresh(thresh), 
                        .zonecode0(zonecode0), 
                        .zonecode1(zonecode1), 
                        .zonecode2(zonecode2), 
                        .zonecode3(zonecode3), 
                        .olcnt(olcnt), 
                        .remote(remote), 
                        .expacc(expacc), 
                        .racci(racci), 
                        .gacci(gacci), 
                        .bacci(bacci), 
                        .zenv(zenv), 
                        .sof(sof), 
                        .eofearly(eofe), 
                        .ve_end_of_frame(ve_end_of_frame)
                       );

endmodule
