/*
 *  Description: Exposure accum's
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : m_mon
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
 * 09-JUN-97:  12-bit stats output [rgb]acci, for !remote case
*/

module m_mon (
              vp_clk, 
              rx_VP_PCLK, 
              pclkd1, 
              resetb, 
              oenv, 
              oenvd2, 
              vlenv, 
              monosig, 
              matrixsig,
              intqcif, 
              accscale, 
              thresh, 
              zonecode0, 
              zonecode1, 
              zonecode2, 
              zonecode3, 
              olcnt,
              remote,
              expacc, 
              racci, 
              gacci, 
              bacci, 
              zenv, 
              sof, 
              eofearly, 
              ve_end_of_frame
             );
	input        vp_clk, 
	             rx_VP_PCLK, 
	             pclkd1, 
	             resetb, 
	             intqcif, 
	             oenv, 
	             oenvd2, 
	             remote, 
	             vlenv;
	input  [7:0] matrixsig;
	input  [7:0] monosig, 
	             thresh, 
	             zonecode0, 
	             zonecode1, 
	             zonecode2,
	             zonecode3;
	input  [2:0] accscale;
	input  [8:0] olcnt;
	output [7:0] expacc;
	output [11:0] racci, 
	              gacci, 
	              bacci;
	output       zenv, 
	             sof, 
	             eofearly, 
	             ve_end_of_frame;


// !FRIG FOR SHORTS
`define HSIZEX2 704
`define HSIZEBY4 88
`define OVSTART 14
`define VSIZEBY8 36
`define ALLONES 4194303
`define RBITEXT 8192
`define RBITINT 512
`define HIBIT 21
`define LOBIT 14
`define LOWERBIT 10
	wire accloadenv, dumpclk;
	reg vlenvd1p, vlenvd2p, vlenvd3p, vlenvd4p, zenv;
	reg oenvd3;
//	reg vlenvd1n, vlenvd2n, vlenvd3n, vlenvn, oenvd3;
//	reg vzonelast, vzonechange, hzonechange, lastpixzone;
	reg lastcifline, lastqcifline, lastzoomline, hzonechange;
	wire sof, eofearly, ve_end_of_frame; // , sofresetb, od3resetb;
	reg [16:0] szmonosig;
	reg [9:0] zmonosig;
	reg [7:0] zonerow, expacc;
	reg [11:0] racci, gacci, bacci;
	reg [12:0] sigsel;
	wire [14:0] sigselsc;
	reg [1:0] gaincode, mhzcnt, mvzcnt;
	reg [6:0] mpcnt;
	reg [22:0] accout, accoutd1, accoutd2, accoutd3;
	wire [22:0] accint;

//        wire dumpclk_pre,
//             dumpclk_posen;

// regs needed for vp_clk synchronisation:

	reg rx_VP_PCLK_edge,oenv_edge;


//        assign dumpclk_pre   = vlenvd1p & (!vlenv);
//        assign dumpclk_posen = dumpclk_pre & (!dumpclk);

// delayed oenv signal for holding counters reset
// *** Modified for synchronization ***
// negedge rx_VP_PCLK => posedge vp_clk
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  oenvd3 <= 0;
                  rx_VP_PCLK_edge <= 0;
                end
		else
                begin
                  if ((rx_VP_PCLK_edge) & (!rx_VP_PCLK))
                  begin
                    oenvd3 <= oenv;
                  end
                  rx_VP_PCLK_edge <= rx_VP_PCLK;
                end
	end

// od3resetb not necessary because = synchronous reset.
//	assign od3resetb = resetb & oenvd3;

// zoned pixel counter
// *** Modified for synchronization ***
// !od3resetb => !oenvd3

  always @(posedge vp_clk or negedge resetb) begin
    if(!resetb) begin
     	mpcnt <= 0;
     	mhzcnt <= 0;
     	hzonechange <= 0;
    end
    else if(!oenvd3) begin // synchronous reset
      mpcnt <= 0;
      mhzcnt <= 0;
      hzonechange <= 0;
    end
    else begin
      if (rx_VP_PCLK) begin
	if((mpcnt + 1) >= `HSIZEBY4) begin
	  mpcnt <= 0;
     	  mhzcnt <= (mhzcnt + 1);
	  hzonechange <= 0;
     	end
	else begin
	  if((mpcnt + 1) >= (`HSIZEBY4 - 1)) begin
     	    mpcnt <= (mpcnt + 1);
     	    mhzcnt <= mhzcnt;
     	    hzonechange <= 1;
     	  end
     	  else begin
     	    mpcnt <= (mpcnt + 1);
     	    mhzcnt <= mhzcnt;
     	    hzonechange <= 0;
     	  end
     	end
      end
    end
  end

// zoned line counter
// late mod for speed-up

// sofresetb not necessary because = synchronous reset.
//	assign sofresetb = resetb & !sof;

// *** Modified for synchronization ***
// !sofresetb => !sof
// negedge oenv => posedge vp_clk
// integrated two consecutive always blocks into one (same sensitivity list)

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  mvzcnt <= 0;
                  lastcifline <= 0;
                  lastqcifline <= 0;
                  lastzoomline <= 0;
                  oenv_edge <= 0;
                end
		else
                begin
                  if (sof) // synchronous reset
                  begin
                    mvzcnt <= 0;
                    lastcifline <= 0;
                    lastqcifline <= 0;
                    lastzoomline <= 0;
                  end
                  else if ((oenv_edge) & (!oenv))
                  begin
                    if(olcnt > ((`VSIZEBY8 << 3) + (`OVSTART - 3))) mvzcnt <= 0;
                    else if(olcnt > ((`VSIZEBY8 << 2) + (`VSIZEBY8 << 1) + (`OVSTART - 3))) mvzcnt <= 3;
                    else if(olcnt > ((`VSIZEBY8 << 2) + (`OVSTART - 3))) mvzcnt <= 2;
                    else if(olcnt > ((`VSIZEBY8 << 1) + (`OVSTART - 3))) mvzcnt <= 1;
                    else mvzcnt <= 0;
                    if(olcnt == ((`VSIZEBY8 << 3) + (`OVSTART - 2)))
                    begin
                      lastcifline <= 1;
                      lastqcifline <= 1;
                      lastzoomline <= 0;
                    end
                    else if(olcnt == ((`VSIZEBY8 << 2) + (`OVSTART - 2)))
                    begin
                      lastcifline <= 1;
                      lastqcifline <= 1;
                      lastzoomline <= 0;
                    end
                    else if(olcnt == ((`VSIZEBY8 << 2) + (`VSIZEBY8 << 1) + `VSIZEBY8 + (`OVSTART - 2)))
                    begin
                      lastcifline <= 1;
                      lastqcifline <= 0;
                      lastzoomline <= 0;
                    end
                    else if(olcnt == ((`VSIZEBY8 << 2) + (`VSIZEBY8 << 1) + (`OVSTART - 2)))
                    begin
                      lastcifline <= 1;
                      lastqcifline <= 0;
                      lastzoomline <= 0;
                    end
                    else if(olcnt == ((`VSIZEBY8 << 2) + `VSIZEBY8 + (`OVSTART - 2)))
                    begin
                      lastcifline <= 1;
                      lastqcifline <= 0;
                      lastzoomline <= 0;
                    end
                    else if(olcnt == ((`VSIZEBY8 << 1) + `VSIZEBY8 + (`OVSTART - 2)))
                    begin
                      lastcifline <= 1;
                      lastqcifline <= 0;
                      lastzoomline <= 0;
                    end
                    else if(olcnt == ((`VSIZEBY8 << 1) + (`OVSTART - 2)))
                    begin
                      lastcifline <= 1;
                      lastqcifline <= 0;
                      lastzoomline <= 0;
                    end
                    else if(olcnt == (`VSIZEBY8 + (`OVSTART - 2)))
                    begin
                      lastcifline <= 1;
                      lastqcifline <= 0;
                      lastzoomline <= 0;
                    end
                    else if(olcnt == ((`VSIZEBY8 << 2) + (`OVSTART - 3)))
                    begin
                      lastcifline <= 0;
                      lastqcifline <= 0;
                      lastzoomline <= 1;
                    end
                    else if(olcnt == ((`VSIZEBY8 << 2) + (`VSIZEBY8 << 1) + (`OVSTART - 3)))
                    begin
                      lastcifline <= 0;
                      lastqcifline <= 0;
                      lastzoomline <= 1;
                    end
                    else
                    begin
                      lastcifline <= 0;
                      lastqcifline <= 0;
                      lastzoomline <= 0;
                    end
                  end
                  oenv_edge <= oenv;
                end
	end

// last pixel output, CIF & QCIF modes

// centre zone output for zoom mode
	always @ (oenvd2 or mvzcnt or mhzcnt) begin
		case({!oenvd2,mvzcnt,mhzcnt})
			5,6,9,10: zenv = 1;
			default: zenv = 0;
		endcase
	end

// zone decoder and zone gain, includes envelope
	always @ (mvzcnt or mhzcnt or monosig or oenvd2 or
			zonecode0 or zonecode1 or zonecode2 or zonecode3) begin
	 	case(mvzcnt)
			0:	zonerow = zonecode0;
			1:	zonerow = zonecode1;
			2:	zonerow = zonecode2;
			3:	zonerow = zonecode3;
		endcase
	 	case(mhzcnt)
			0:	gaincode = zonerow[1:0];
			1:	gaincode = zonerow[3:2];
			2:	gaincode = zonerow[5:4];
			3:	gaincode = zonerow[7:6];
		endcase
	 	case(gaincode)
			0:	zmonosig = 0;
			1:	zmonosig = oenvd2 ? {2'd0,monosig} : 0;
			2:	zmonosig = oenvd2 ? {1'd0,monosig,1'd0} : 0;
			3:	zmonosig = oenvd2 ? {monosig,2'd0} : 0;
		endcase
	end

// accscale
	always @ (zmonosig or accscale) begin
		case(accscale)
			0:	szmonosig = {7'd0,zmonosig};
			1:	szmonosig = {6'd0,zmonosig,1'd0};
			2:	szmonosig = {5'd0,zmonosig,2'd0};
			3:	szmonosig = {4'd0,zmonosig,3'd0};
			4:	szmonosig = {3'd0,zmonosig,4'd0};
			5:	szmonosig = {2'd0,zmonosig,5'd0};
			6:	szmonosig = {1'd0,zmonosig,6'd0};
			7:	szmonosig = {zmonosig,7'd0};
		endcase
	end

// input selection, thresholding RGB
	always @ (pclkd1 or szmonosig or matrixsig or thresh) begin
		sigsel = pclkd1 ? szmonosig[16:4] : ((matrixsig > thresh) ? {8'd0,matrixsig[7:3]} : 0);
	end

// accumulator shared 4 ways: exp (hot on rx_VP_PCLK), R, G, B
// note buried clipper
	assign sigselsc = intqcif ? {sigsel,2'd0} : {2'd0,sigsel};
	assign accint = sigselsc + accoutd3;
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			accoutd3 <= 0;
			accoutd2 <= 0;
			accoutd1 <= 0;
			accout <= 0;
		end else begin
			accoutd3 <= accoutd2;
			accoutd2 <= accoutd1;
			accoutd1 <= accout[`HIBIT+1] ? `ALLONES : accout;
			accout <= accloadenv ? (remote ? `RBITEXT : `RBITINT) : accint;
		end
	end

// catchers
// *** Modified for synchronization ***
// vp_clk_n => vp_clk

        always @(posedge vp_clk or negedge resetb) begin
		if(!resetb)
			expacc <= 0;
		else
                   if (dumpclk)
			expacc <= accoutd3[`HIBIT:`LOBIT];
                   else
                      expacc <= expacc;
	end

// *** Modified for synchronization ***
// vp_clk_n => vp_clk

        always @(posedge vp_clk or negedge resetb) begin
		if(!resetb)
			racci <= 0;
		else
                   if (dumpclk)
			racci <= accoutd2[`HIBIT:`LOWERBIT];
                   else
                      racci <= racci;
	end

// *** Modified for synchronization ***
// vp_clk_n => vp_clk

        always @(posedge vp_clk or negedge resetb) begin
		if(!resetb)
			gacci <= 0;
		else
                   if (dumpclk)
			gacci <= accoutd1[`HIBIT:`LOWERBIT];
                   else
                      gacci <= gacci;
	end

// *** Modified for synchronization ***
// vp_clk_n => vp_clk

        always @(posedge vp_clk or negedge resetb) begin
		if(!resetb)
			bacci <= 0;
		else
                   if (dumpclk)
			bacci <= accout[`HIBIT:`LOWERBIT];
                   else
                      bacci <= bacci;
	end

// chain for acc clear and load, also generates sof & ve_end_of_frame blips
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			vlenvd4p <= 0;
			vlenvd3p <= 0;
			vlenvd2p <= 0;
			vlenvd1p <= 0;
		end else begin
			vlenvd4p <= vlenvd3p;
			vlenvd3p <= vlenvd2p;
			vlenvd2p <= vlenvd1p;
			vlenvd1p <= vlenv;
		end
	end

// *** Modified for synchronization ***
// vp_clk_n => vp_clk

// Removed for pipeline synchronization...
/*
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			vlenvd3n <= 0;
			vlenvd2n <= 0;
			vlenvd1n <= 0;
			vlenvn <= 0;
		end else begin
			vlenvd3n <= vlenvd3p;
			vlenvd2n <= vlenvd2p;
			vlenvd1n <= vlenvd1p;
			vlenvn <= vlenv;
		end
	end
*/

	assign eofearly = vlenvd1p & !vlenv;
	assign sof = !vlenvd1p & vlenv;
	assign accloadenv = !vlenvd4p & vlenv;
	assign dumpclk = vlenvd1p & !vlenv;
	assign ve_end_of_frame = vlenvd2p & !vlenvd1p;

endmodule
