/*
 *  Description: Input Processor (top)
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : inproc
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/



/*************************************************
Top level
*************************************************/
module inproc (
               rx_do, 
               resetb, 
               vp_clk, 
               pclkd1, 
               pclkd2, 
               pclkd4, 
               evenfirst, 
               ienv, 
               hjog, 
               vjog, 
               intqcif,
               eof, 
               lefthalf, 
               lefthalfd1, 
               rflag, 
               defcor, 
               filtercode, 
               correct, 
               barsrq, 
               rx_ld, 
               lcnt, 
               rx_DATA_IMMINENT, 
               data_valid, 
               linespace,
               baraddr, 
               offset, 
               rcomp, 
               g1comp, 
               g2comp, 
               bcomp,
               blackacc, 
               lacc0, 
               lacc1, 
               lacc2, 
               lacc3, 
               lacc4, 
               lacc5, 
               lacc6, 
               lacc7,
               out
              );

input  [7:0] rx_do, 
             offset, 
             rcomp, 
             g1comp, 
             g2comp, 
             bcomp;
input  [4:0] defcor;
input  [1:0] filtercode;
input  [2:0] rx_ld;
input  [3:0] linespace;
input  [8:0] lcnt;
input  [8:0] baraddr;
input        resetb, 
             vp_clk, 
             pclkd1, 
             pclkd2, 
             pclkd4, 
             evenfirst, 
             ienv, 
             hjog, 
             vjog, 
             intqcif;
input        rx_DATA_IMMINENT, 
             data_valid;
input        barsrq, 
             correct;
input        eof, 
             lefthalf, 
             lefthalfd1, 
             rflag;
output [7:0] out;
output [7:0] blackacc, 
             lacc0, 
             lacc1, 
             lacc2, 
             lacc3, 
             lacc4, 
             lacc5, 
             lacc6, 
             lacc7;
wire   [7:0] blackacc, 
             lacc0, 
             lacc1, 
             lacc2, 
             lacc3, 
             lacc4, 
             lacc5, 
             lacc6, 
             lacc7;
wire   [7:0] sigint;
wire         rflag, 
             pclkd1, 
             pclkd2, 
             pclkd4, 
             lefthalf, 
             lefthalfd1;
wire   [7:0] out;

def_cor   de1 (
               .rx_do(rx_do), 
               .resetb(resetb), 
               .vp_clk(vp_clk), 
               .pclkd4(pclkd4), 
               .defcor(defcor), 
               .filtercode(filtercode), 
               .correct(correct), 
               .out(sigint)
              );

gain_offs ga1 (
               .in(sigint), 
               .resetb(resetb), 
               .vp_clk(vp_clk), 
               .pclkd2(pclkd2), 
               .barsrq(barsrq), 
               .evenfirst(evenfirst), 
               .lefthalfd1(lefthalfd1), 
               .intqcif(intqcif), 
               .ienv(ienv),
               .hjog(hjog), 
               .rflag(rflag), 
               .baraddr(baraddr), 
               .offset(offset), 
               .rcomp(rcomp), 
               .g1comp(g1comp), 
               .g2comp(g2comp), 
               .bcomp(bcomp), 
               .out(out)
              );

i_mon     im1 (
               .rx_do(rx_do), 
               .resetb(resetb), 
               .vp_clk(vp_clk), 
               .pclkd2(pclkd2), 
               .rx_ld(rx_ld), 
               .lcntlsb(lcnt[0]), 
               .linespace(linespace), 
               .rx_DATA_IMMINENT(rx_DATA_IMMINENT), 
               .data_valid(data_valid),
               .eof(eof), 
               .lefthalf(lefthalf), 
               .evenfirst(evenfirst),
               .hjog(hjog), 
               .vjog(vjog),
               .blackacc(blackacc), 
               .lacc0(lacc0), 
               .lacc1(lacc1), 
               .lacc2(lacc2), 
               .lacc3(lacc3), 
               .lacc4(lacc4), 
               .lacc5(lacc5), 
               .lacc6(lacc6), 
               .lacc7(lacc7)
              );

endmodule
