/*
 *  Description: Black and Flicker accum's.
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : i_mon
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/

module i_mon (
              rx_do, 
              resetb, 
              vp_clk, 
              pclkd2, 
              rx_ld, 
              lcntlsb, 
              linespace, 
              rx_DATA_IMMINENT, 
              data_valid,
              eof, 
              lefthalf, 
              evenfirst, 
              hjog, 
              vjog,
              blackacc, 
              lacc0, 
              lacc1, 
              lacc2, 
              lacc3, 
              lacc4, 
              lacc5, 
              lacc6, 
              lacc7
             );
`define BK 2
`define VL 3
`define EOF 5


input        vp_clk, 
             pclkd2, 
             resetb, 
             rx_DATA_IMMINENT, 
             data_valid;
input  [7:0] rx_do;
input        lcntlsb, 
             eof, 
             lefthalf, 
             evenfirst, 
             hjog, 
             vjog;
input  [2:0] rx_ld;
input  [3:0] linespace;
output [7:0] blackacc, 
             lacc0, 
             lacc1, 
             lacc2, 
             lacc3, 
             lacc4, 
             lacc5, 
             lacc6, 
             lacc7;
reg    [7:0] blackacc, 
             lacc0, 
             lacc1, 
             lacc2, 
             lacc3, 
             lacc4, 
             lacc5, 
             lacc6, 
             lacc7;
reg    [7:0] blackacci, 
             lacci0, 
             lacci1, 
             lacci2, 
             lacci3, 
             lacci4, 
             lacci5, 
             lacci6, 
             lacci7;
reg   [15:0] accout;
reg    [4:0] scnt;
reg    [3:0] accptr, 
             oldaccptr;
reg    [8:0] hotword;
wire   [8:0] clkword;
wire   [7:0] accoutds7;
reg          laccenv, 
             laccenv_int, 
             laccblip, 
             clearblip;
wire  [15:0] accint, 
             newval;
wire         cresetb;

// regs needed for vp_clk synchronisation:

reg rx_DATA_IMMINENT_edge,data_valid_edge,eof_edge;
reg [8:0] clkword_edge;

// line accumulation envelope
// *** Modified for synchronization ***
// posedge rx_DATA_IMMINENT => posedge vp_clk
//
// Combined two always blocks in this one...

	always @ (posedge vp_clk or negedge resetb)
        begin
		if(!resetb)
                begin
                  laccenv <= 0;
                  laccenv_int = 0;
                  rx_DATA_IMMINENT_edge <= 0;
		  laccblip <= 0;
                end
		else
                begin
                  if ((!rx_DATA_IMMINENT_edge) & (rx_DATA_IMMINENT))
                  begin
                    if(rx_ld == `BK)
                    begin
                      laccenv <= 0;
                      laccenv_int = 0;
                    end
                    else if(rx_ld == `VL)
                    begin
                      if(accptr < 9)
                      begin
                        if((scnt + 1) > linespace)
                        begin
                          laccenv <= 1;
                          laccenv_int = 1;
                        end
                        else
                        begin
                          laccenv <= 0;
                          laccenv_int = 0;
                        end
                      end
                      else
                      begin
                        laccenv <= 0;
                        laccenv_int = 0;
                      end
                    end
                    else
                    begin
                      laccenv <= 0;
                      laccenv_int = 0;
                    end
                  end
		  laccblip <= laccenv_int & rx_DATA_IMMINENT;
                  rx_DATA_IMMINENT_edge <= rx_DATA_IMMINENT;
                end
	end

// *** Modified for synchronization ***
// posedge vp_clk_n => posedge vp_clk
// Removed for "fixes"
/*
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
			laccblip <= 0;
		else
			laccblip <= laccenv & rx_DATA_IMMINENT;
	end
*/

// vertical position tracker
// *** Modified for synchronization ***
// negedge rx_DATA_IMMINENT => posedge vp_clk

	always @ (posedge vp_clk or negedge resetb)
        begin
		if(!resetb)
                begin
                  scnt <= 0;
                  accptr <= 0;
                  oldaccptr <= 0;
		end
                else
                begin
                  if ((rx_DATA_IMMINENT_edge) & (!rx_DATA_IMMINENT))
                  begin
                    if(rx_ld == `BK)
                    begin
                      scnt <= linespace;
                      accptr <= 0;
                    end
                    else if(rx_ld == `VL)
                    begin
                      if(accptr < 9)
                      begin
                        if((scnt + 1) > linespace)
                        begin
                          scnt <= 0;
                          accptr <= accptr + 1;
                        end
                        else
                        begin
                          scnt <= (scnt + 1);
                          accptr <= accptr;
                        end
                      end
                      else
                      begin
                        scnt <= 0;
                        accptr <= accptr;
                      end
                    end
                    else
                    begin
                      scnt <= 0;
                      accptr <= 0;
                    end
                    oldaccptr <= accptr;
                  end
		end
	end

// clear signal for accumulators (note gated reset - assumes black comes before data in a frame)

//  *** Not necessary after synchronization of reset:
//	assign cresetb = !laccblip & resetb & !eof;

//	assign data_validlacc = laccenv & data_valid;
//	always @ (posedge data_validlacc or negedge cresetb) begin

// *** Modified for synchronization ***
// posedge data_valid => posedge vp_clk
// negedge cresetb => negedge resetb, (laccblip)|(eof)

	always @ (posedge vp_clk or negedge resetb)
        begin
		if(!resetb)
                begin
                  clearblip <= 1;
                  data_valid_edge <= 0;
                end
		else begin
                  if ((laccblip)|(eof))
		    clearblip <= 1;
		  else if ((!data_valid_edge) & (data_valid))
                    clearblip <= 0;
                  data_valid_edge <= data_valid;
                end
	end

// load registers
// *** Modified for synchronization ***
// posedge rx_DATA_IMMINENT => posedge vp_clk

	always @ (posedge vp_clk or negedge resetb)
        begin
		if(!resetb)
                begin
                  hotword <= 0;
		end
                else
                begin
                  if ((!rx_DATA_IMMINENT_edge) & (rx_DATA_IMMINENT))
                  hotword <= (1 << oldaccptr);
		end
	end

	assign clkword = clearblip ? hotword : 0;

// main 17-bit accumulator, rounding bit different for black
// only use green data in the laccs
// !FRIG for SHORT LINE
	assign newval = ((accptr == 0) | (laccenv && ((lefthalf != (hjog == evenfirst)) == (lcntlsb == vjog)))) ? rx_do : 0;
//	assign newval = ((accptr == 0) | (laccenv && ((lefthalf != (hjog == evenfirst)) == (lcntlsb == vjog)))) ? (rx_do << 3): 0;
	assign accint = newval + accout;

	always @ (posedge vp_clk or negedge resetb)
        begin
                if(!resetb)
                  accout <= 0;
                else
                  accout <= pclkd2 ? (clearblip ? ((accptr == 0) ? 64 : 128) : accint) : accout;
	end

// clipping window 7-bits up for black
	function [7:0] hiclip7;
		input[15:0] rx_do;
		case(rx_do[15])
			0:      hiclip7 = rx_do[14:7];
			1:      hiclip7 = 8'd255;
		endcase
	endfunction
	assign accoutds7 = hiclip7(accout);

// distribute results to temp space, no clip for laccs

// *** Created for synchronization ***
// generates the clkword_edge vector

	always @ (posedge vp_clk or negedge resetb)
        begin
                if(!resetb)
                begin
                  clkword_edge <= 0;
		end
                else
                begin
                  clkword_edge <= clkword;
		end
	end

// *** Modified for synchronization ***
// posedge clkword[0] => posedge vp_clk

	always @ (posedge vp_clk or negedge resetb)
        begin
		if(!resetb)
                begin
                  blackacci <= 0;
		end
                else
                begin
                  if ((!clkword_edge[0]) & (clkword[0]))
                  blackacci <= accoutds7;
		end
	end

// *** Modified for synchronization ***
// posedge clkword[1] => posedge vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  lacci0 <= 0;
		end
                else
                begin
                  if ((!clkword_edge[1]) & (clkword[1]))
                  lacci0 <= accout[15:8];
		end
	end

// *** Modified for synchronization ***
// posedge clkword[2] => posedge vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  lacci1 <= 0;
		end
                else
                begin
                  if ((!clkword_edge[2]) & (clkword[2]))
                  lacci1 <= accout[15:8];
		end
	end

// *** Modified for synchronization ***
// posedge clkword[3] => posedge vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  lacci2 <= 0;
		end
                else
                begin
                  if ((!clkword_edge[3]) & (clkword[3]))
                  lacci2 <= accout[15:8];
		end
	end

// *** Modified for synchronization ***
// posedge clkword[4] => posedge vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  lacci3 <= 0;
		end
                else
                begin
                  if ((!clkword_edge[4]) & (clkword[4]))
                  lacci3 <= accout[15:8];
		end
	end

// *** Modified for synchronization ***
// posedge clkword[5] => posedge vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  lacci4 <= 0;
		end
                else
                begin
                  if ((!clkword_edge[5]) & (clkword[5]))
                  lacci4 <= accout[15:8];
		end
	end

// *** Modified for synchronization ***
// posedge clkword[6] => posedge vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  lacci5 <= 0;
		end
                else
                begin
                  if ((!clkword_edge[6]) & (clkword[6]))
                  lacci5 <= accout[15:8];
		end
	end

// *** Modified for synchronization ***
// posedge clkword[7] => posedge vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  lacci6 <= 0;
		end
                else
                begin
                  if ((!clkword_edge[7]) & (clkword[7]))
                  lacci6 <= accout[15:8];
		end
	end

// *** Modified for synchronization ***
// posedge clkword[8] => posedge vp_clk

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
                begin
                  lacci7 <= 0;
		end
                else
                begin
                  if ((!clkword_edge[8]) & (clkword[8]))
                  lacci7 <= accout[15:8];
		end
	end

// stabilise results
// could use latches here (and many other places!)
// *** Modified for synchronization ***
// posedge eof => posedge vp_clk

	always @ (posedge vp_clk or negedge resetb)
        begin
		if(!resetb)
                begin
                  blackacc <= 0;
                  lacc0 <= 0;
                  lacc1 <= 0;
                  lacc2 <= 0;
                  lacc3 <= 0;
                  lacc4 <= 0;
                  lacc5 <= 0;
                  lacc6 <= 0;
                  lacc7 <= 0;
                  eof_edge <= 0;
		end
                else
                begin
                  if ((!eof_edge) & (eof))
                  begin
                    blackacc <= blackacci;
                    lacc0 <= lacci0;
                    lacc1 <= lacci1;
                    lacc2 <= lacci2;
                    lacc3 <= lacci3;
                    lacc4 <= lacci4;
                    lacc5 <= lacci5;
                    lacc6 <= lacci6;
                    lacc7 <= lacci7;
                  end
                  eof_edge <= eof;
		end
	end

endmodule
