/*
 *  Description: Gamma value
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : gamsel
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/

module gamsel (in, resetb, vp_clk, fval, gamcorreg, out);
	parameter DBITS = 8;
	parameter CBITS = 6;
	parameter OBITS = 10;
	input[8:0] in;
	input resetb, vp_clk;
	input[6:0] fval;
	input[3:0] gamcorreg;
	output[8:0] out;
	reg[8:0] out;
	wire[8:0] finalval;
	wire[5:0] gamcorint;
	wire[9:0] fmult;
	wire[9:0] gval;

	assign gamcorint = {2'd0,gamcorreg};

	function [OBITS-1:0] tm070610;
		input [DBITS-1:0] dat;
		input [CBITS-1:0] cof;
		reg [DBITS+CBITS-1:0] fullprod;
		reg [DBITS-2:0] hiprod;
		reg [CBITS-1:0] loprod;
		reg [CBITS-3:0] lotmp;
		reg [CBITS:0] mbcof;
		reg [DBITS:0] pp, pp1;
		reg [DBITS:0] ppsds2;
		reg [DBITS+3:0] pps;

		integer i;

		begin
			mbcof = {cof,1'b0};
			ppsds2 = 0;
			lotmp = 0;
			for(i=2; i<=CBITS; i = i + 2) begin
				case(mbcof[2:0])
					0:      pp1 = 0;
					1:      pp1 = {1'b0,dat};
					2:      pp1 = {1'b0,dat};
					3:      pp1 = {dat,1'b0};
					4:      pp1 = {dat,1'b0};
					5:      pp1 = {1'b0,dat};
					6:      pp1 = {1'b0,dat};
					7:      pp1 = 0;
				endcase
				case(mbcof[2])
					0:      pp = pp1;
					1:      pp = ~pp1;
				endcase
				pps = {ppsds2[DBITS],ppsds2[DBITS],ppsds2,mbcof[2]}
					+ {mbcof[2],mbcof[2],pp,mbcof[2]};
				ppsds2 = {pps[DBITS+3:3]};
				loprod = {pps[2:1],lotmp};
				mbcof = mbcof >> 2;
				lotmp = loprod >> 2;
			end
			hiprod = pps[DBITS+1:3];
			fullprod = {hiprod,loprod};
			tm070610 = fullprod[DBITS+CBITS-3:DBITS+CBITS-(OBITS+2)];
		end

	endfunction

	assign fmult = tm070610(fval,gamcorint);
	assign gval = {in,1'b1} + fmult;

	assign finalval = gval[9:1];

	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			out <= 0;
		end else begin
			out <= finalval;
		end
	end

endmodule
