/*
 *  Description: Defect correction
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : def_cor
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/

`define SMBRRO 0
`define SHODEF 1
`define LHCOPY 2
`define RHCOPY 3
/*************************************************
Defect correction module.
*************************************************/
module def_cor (rx_do, resetb, vp_clk, pclkd4, defcor, filtercode, correct, out);
	parameter DBITS8 = 10;
	parameter CBITS8 = 6;
	parameter OBITS8 = 9;
	parameter RBITPOSN8 = (DBITS8+CBITS8) - (OBITS8+1);

	input [7:0] rx_do;
	input [CBITS8-2:0] defcor;
	input [1:0] filtercode;
	input vp_clk, pclkd4, resetb, correct;
	output [7:0] out;
	reg [7:0] out;
	reg [7:0] dd1, dd2, dd3, dd4, selection;
	reg [7:0] rout, rin, lin, lout, estpixds2;
	reg [8:0] outsum, insum;
	reg [9:0] allsum;
	reg [11:0] estpix;
	wire [CBITS8-1:0] defcorint;
	wire [OBITS8-1:0] allsumx;

// defect correct
	assign defcorint = correct ? {1'b0,defcor} : 0;

	function [OBITS8-1:0] rm100409;
		input [DBITS8-1:0] dat;
		input [CBITS8-1:0] cof;
		reg [DBITS8+CBITS8-1:0] fullprod;
		reg [DBITS8:0] hiprod;
		reg [CBITS8-1:0] loprod;
		reg [CBITS8-3:0] lotmp;
		reg [CBITS8:0] mbcof;
		reg [DBITS8:0] pp, pp1;
		reg [DBITS8:0] ppsds2;
		reg [DBITS8+3:0] pps;

		integer i;

		begin
			mbcof = {cof,1'b0};
			ppsds2 = 1 << RBITPOSN8;
			lotmp = 0;
			for(i=2; i<=CBITS8; i = i + 2) begin
				case(mbcof[2:0])
                    0:      pp1 = 0;
                    1:      pp1 = {dat[DBITS8-1],dat};
                    2:      pp1 = {dat[DBITS8-1],dat};
                    3:      pp1 = {dat,1'b0};
                    4:      pp1 = {dat,1'b0};
                    5:      pp1 = {dat[DBITS8-1],dat};
                    6:      pp1 = {dat[DBITS8-1],dat};
                    7:      pp1 = 0;
				endcase
				case(mbcof[2])
					0:      pp = pp1;
					1:      pp = ~pp1;
				endcase
                pps = {ppsds2[DBITS8],ppsds2[DBITS8],ppsds2,mbcof[2]}
                    + {pp[DBITS8],pp[DBITS8],pp,mbcof[2]};
				ppsds2 = {pps[DBITS8+3:3]};
				loprod = {pps[2:1],lotmp};
				mbcof = mbcof >> 2;
				lotmp = loprod >> 2;
			end
			hiprod = pps[DBITS8+3:3];
			fullprod = {hiprod,loprod};
			rm100409 = fullprod[DBITS8+CBITS8-1:DBITS8+CBITS8-OBITS8];
		end

	endfunction

	assign allsumx = rm100409(allsum,defcorint);

// mode select
	always @ (rx_do or dd1 or dd2 or dd3 or dd4 or estpixds2 or correct or filtercode) begin
		case(filtercode)
			`LHCOPY:	begin rout = dd1; rin = dd1; lin = dd1; lout = dd1; end
			`RHCOPY:	begin rout = dd3; rin = dd3; lin = dd3; lout = dd3; end
		   default:	begin rout = rx_do; rin = dd1; lin = dd3; lout = dd4; end
		endcase
		case(correct)
			0:	out = dd2;
			1:	out = (filtercode == `SHODEF) ? 255 : estpixds2;
		endcase
	end

// Mexican hat filter in 1-D
	always @ (rout or rin or lin or lout or allsumx) begin
		outsum = rout + lout;
		insum = rin + lin;
// take this out
//	allsum = {insum[8],insum} + {~outsum[8],~outsum};
//      estpix = {allsumx,2'b1} + {1'b0,insum,1'b1};
//      estpixds2 = estpix[9:2];
// put this in
	allsum = {1'b0,insum} + {1'b1,~outsum};
	estpix = {allsumx[8],allsumx,2'b1} + {2'b0,insum,1'b1};
	case({estpix[11],estpix[10]})
                  0: estpixds2 = estpix[9:2];
                  1: estpixds2 = 255;
            default: estpixds2 = 0;
        endcase
// bug fixed !
	end

// delay line for FIR filter, and output register
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			dd4 <= 0;
			dd3 <= 0;
			dd2 <= 0;
			dd1 <= 0;
		end else begin
			dd4 <= pclkd4 ? dd3 : dd4;
			dd3 <= pclkd4 ? dd2 : dd3;
			dd2 <= pclkd4 ? dd1 : dd2;
			dd1 <= pclkd4 ? rx_do : dd1;
		end
	end

endmodule
