/*
 *  Description: Pixel Enable and delayed versions
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : ctrl_src
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/


// !FRIG FOR SHORTS
`define HSIZEX2 704
`define HSIZEBY4 88
`define OVSTART 14
`define VSIZEBY8 36
`define ALLONES 4194303
`define RBIT 8192
`define HIBIT 21
`define LOBIT 14
/*
*/
/*
`define HSIZEX2 80
`define HSIZEBY4 10
`define OVSTART 8
`define VSIZEBY8 4
`define ALLONES 65535
`define RBIT 128
`define HIBIT 15
`define LOBIT 8
*/


module ctrl_src(
                vp_clk,
                rx_VP_PCLK, 
                resetb,
                pclkd1, 
                pclkd2, 
                pclkd3);


	input  vp_clk, 
               rx_VP_PCLK, 
               resetb;
        output pclkd1,
               pclkd2,
               pclkd3;
	reg    pclkd1, 
               pclkd2, 
               pclkd3;

// *** Removed these during resynchronization ***
//        assign pclkd3_pre   = pclkd2n;
//        assign pclkd3_negen = pclkd3 & (!pclkd3_pre);

// safe chain for controls (overkill maybe but this has to work)
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			pclkd3 <= 0;
			pclkd2 <= 0;
			pclkd1 <= 0;
		end else begin
			pclkd3 <= pclkd2;
			pclkd2 <= pclkd1;
			pclkd1 <= rx_VP_PCLK;
		end
	end

// *** This block is not necessary anymore after resynch ***
/*
	always @ (posedge vp_clk_n or negedge resetb) begin
		if(!resetb) begin
			pclkd3n <= 0;
			pclkd2n <= 0;
			pclkd1n <= 0;
			pclkn <= 0;
		end else begin
			pclkd3n <= pclkd3;
			pclkd2n <= pclkd2;
			pclkd1n <= pclkd1;
			pclkn <= rx_VP_PCLK;
		end
	end
*/

endmodule
