/*
 *  Description: Colour Space Conversion
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : colspace
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
 * 05-JUN-97:  introduce dmcode components
*/



/*************************************************
RGB to YCbCr conversion
Note interpretation of coeffs: 1st line (Y) c = .5(c' + .5)
other lines (Cb Cr) c = 2c'.
Here X cycle comes before RGB, to let combinatorial gamma computation settle
rhot is pclkd2
*************************************************/
module colspace (insig, resetb, vp_clk, cof00, cof01, cof02, cof10, cof11, cof12,
				intqcif, rsflag, gseflag,
				frerun,
		cof20, cof21, cof22, rhot, ghot, pclkd1, xhot, oenvd6, out);
	parameter DBITS8 = 10;
	parameter CBITS8 = 8;
	parameter OBITS8 = 11;
	parameter RBITPOSN8 = (DBITS8+CBITS8) - (OBITS8+1);

	input [DBITS8-2:0] insig;
	input [CBITS8-1:0] cof00, cof01, cof02, cof10, cof11, cof12, cof20, cof21, cof22;
	input intqcif, rsflag, gseflag;
	input vp_clk, resetb, rhot, ghot, pclkd1, xhot, oenvd6;
	input frerun;
	output [7:0] out;
	reg [7:0] out;
	wire [7:0] outclip;
	reg [8:0] rline, gline, bline, rlinei, glinei, blinei;
	reg gsed1, gsed2, gsed3;
	reg [10:0] yline;
	reg [CBITS8-1:0] rcofsel, gcofsel, bcofsel;
	wire [CBITS8-1:0] rcofsele, gcofsele, bcofsele;
	wire [DBITS8:0] rlinesep16;
	wire [DBITS8-1:0] rlinese, glinese, blinese;
	wire [OBITS8-1:0] rlineprod, glineprod, blineprod;
	wire [11:0] gbprodsum;
	wire [11:0] rgbprodsum;
	wire [13:0] fullsum;
	wire [10:0] finalsum;
	wire [10:0] gbsum;
	wire [10:0] ylinee;
	wire [11:0] rgbsum;
	wire [10:0] rgbsumds1;
	wire bhotspread, rgdatapassing;

	assign rgdatapassing = rhot | ghot;
	assign bhotspread = pclkd1;

// sign extend caught colors
	assign rlinese = {1'b0,rline};
	assign glinese = {1'b0,gline};
	assign blinese = {1'b0,bline};

// truncating multiplier
	function [OBITS8-1:0] tm100811;
		input [DBITS8-1:0] dat;
		input [CBITS8-1:0] cof;
		reg [DBITS8+CBITS8-1:0] fullprod;
		reg [DBITS8:0] hiprod;
		reg [CBITS8-1:0] loprod;
		reg [CBITS8-3:0] lotmp;
		reg [CBITS8:0] mbcof;
		reg [DBITS8:0] pp, pp1;
		reg [DBITS8:0] ppsds2;
		reg [DBITS8+3:0] pps;

		integer i;

		begin
			mbcof = {cof,1'b0};
//			ppsds2 = 1 << RBITPOSN8;
			ppsds2 = 0;
			lotmp = 0;
			for(i=2; i<=CBITS8; i = i + 2) begin
				case(mbcof[2:0])
					0:      pp1 = 0;
					1:      pp1 = {1'b0,dat};
					2:      pp1 = {1'b0,dat};
					3:      pp1 = {dat,1'b0};
					4:      pp1 = {dat,1'b0};
					5:      pp1 = {1'b0,dat};
					6:      pp1 = {1'b0,dat};
					7:      pp1 = 0;
				endcase
				case(mbcof[2])
					0:      pp = pp1;
					1:      pp = ~pp1;
				endcase
				pps = {ppsds2[DBITS8],ppsds2[DBITS8],ppsds2,mbcof[2]}
					+ {mbcof[2],mbcof[2],pp,mbcof[2]};
				ppsds2 = {pps[DBITS8+3:3]};
				loprod = {pps[2:1],lotmp};
				mbcof = mbcof >> 2;
				lotmp = loprod >> 2;
			end
			hiprod = pps[DBITS8+3:3];
			fullprod = {hiprod,loprod};
			tm100811 = fullprod[DBITS8+CBITS8-1:DBITS8+CBITS8-OBITS8];
		end

	endfunction

// coefficient & yline (what's added in, y or the 128 offset for UV) selection
/*
	always @ (cof00 or cof01 or cof02 or cof10 or cof11 or cof12 or
			cof20 or cof21 or cof22 or rline or gline or bline or
			in or ind1 or rgbsumds1 or cofctrl) begin
		case(cofctrl)
			1:	begin
					rcofsel = cof00;
					gcofsel = cof01;
					bcofsel = cof02;
					rlinei = rline;
					glinei = gline;
					blinei = bline;
					yline = rgbsumds1;
				end
			2:	begin
					rcofsel = cof10;
					gcofsel = cof11;
					bcofsel = cof12;
					rlinei = rline;
					glinei = gline;
					blinei = bline;
					yline = 11'd256;
				end
		default: begin
					rcofsel = cof20;
					gcofsel = cof21;
					bcofsel = cof22;
					rlinei = gline;
					glinei = ind1;
					blinei = in;
					yline = 11'd256;
				end
		endcase
	end
*/

// coefficient selection (pclkd1 at module i/p means output r hot here)
// NB processing order is UYVX, where X is null op
	always @ (cof00 or cof01 or cof02 or cof10 or cof11 or cof12 or cof20 or cof21
			or cof22 or rgbsumds1 or rhot or xhot or pclkd1 or ghot) begin
		casex({pclkd1,xhot,rhot})
		4'b100:	begin
						rcofsel = cof10;
						gcofsel = cof11;
						bcofsel = cof12;
//						yline = 11'd128;
						yline = 11'd256;
					end
		4'b010:	begin
						rcofsel = cof00;
						gcofsel = cof01;
						bcofsel = cof02;
						yline = rgbsumds1;
					end
		default:	begin
						rcofsel = cof20;
						gcofsel = cof21;
						bcofsel = cof22;
//						yline = 11'd128;
						yline = 11'd256;
					end
		endcase
	end
	assign rcofsele = (oenvd6 | frerun) ? rcofsel : 0;
	assign gcofsele = (oenvd6 | frerun) ? gcofsel : 0;
	assign bcofsele = (oenvd6 | frerun) ? bcofsel : 0;
	assign ylinee = (oenvd6 | frerun) ? yline : 0;

// data selection
	always @ (insig or rline or gline or blinei or bhotspread or rgdatapassing) begin
		case(rgdatapassing)
			0: begin
					rlinei = rline;
					glinei = gline;
				end
			1:	begin
					rlinei = gline;
					glinei = insig;
				end
		endcase
/*
		case(rhot)
			0: bline = insig;
			1: bline = blinei;
		endcase
*/
		case(bhotspread)
			0: bline = blinei;
			1: bline = insig;
		endcase
	end

// 3 multiplier instances
	assign rlineprod = tm100811(rlinese,rcofsele);
	assign glineprod = tm100811(glinese,gcofsele);
	assign blineprod = tm100811(blinese,bcofsele);

// sum the 3 products
	assign gbprodsum = {glineprod[10],glineprod} + {blineprod[10],blineprod};
	assign rgbprodsum = {rlineprod[10],rlineprod} + gbprodsum;

// also sum the 3 caught colors for the Y computation, downshift 1 bit
// 3 x sum required for Y coef recode
// why add 130?  128 (+ roundbit 2) downshifted 3 = 16, offset required for 601-coding
	assign gbsum = glinese + blinese;
	assign rlinesep16 = rlinese + 130;
	assign rgbsum = rlinesep16 + gbsum;
	assign rgbsumds1 = rgbsum[11:1];

	assign fullsum = {rgbprodsum[11],rgbprodsum,1'b1} + {2'd0,ylinee,1'b1};
// complete the rounding
	assign finalsum = xhot ? fullsum[13:3] : fullsum[12:2];

// clip to 8-bit
	function [7:0] clip;
		input[10:0] in;
		case(in[10])
			0:	begin
				case(in[8] | in[9])
 					0:	clip = in[7:0];
 					1:	clip = 8'd255;
				endcase
				end
			1:	clip = 8'd0;
		endcase
	endfunction

	assign outclip = clip(finalsum);

// color catcher, and output pipeline stage
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			rline <= 0;
			gline <= 0;
			blinei <= 0;
			out <= 0;
			gsed3 <= 0;
		end else begin
			rline <= rlinei;
			gline <= glinei;
			blinei <= bline;
			out <= (!frerun & intqcif & (rsflag | !(gseflag | gsed3))) ? 0 : outclip;
			gsed3 <= gsed2;
		end
	end

// chain to extend gse env (QCIF fudge)
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			gsed2 <= 0;
			gsed1 <= 0;
		end else begin
			gsed2 <= rhot ? gsed1 : gsed2;
			gsed1 <= rhot ? gseflag : gsed1;
		end
	end

endmodule
