/*
 *  Description: YUV 422 output formatter.
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : coder422
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
 * 05-JUN-97:  Introduce dmcode components, re-write fclk function
 * 06-JUN-97:  Introduce bypass mode
 * 10-JUN-97:  "task" bit in cword is stndrd
 * 11-JUN-97:  use localflenv as VBLANK in Rec-656 codes
 * 11-JUN-97:  change sense of edg656 
 * 12-JUN-97:  use QCIF fclk in bypass mode
 * 13-JUN-97:  reset localflenv to 1 (VBLANK)
 * 18-JUN-97:  inroduce vp_clk as bypass clock (PL)
*/



/*************************************************
4:4:4 to 4:2:0 conversion
Boxcar filters on chroma
Contains local control and address generation
uhot here is pclkd1
*************************************************/
module coder422 (
                 in, 
                 rawin, 
                 rgbin, 
                 resetb, 
                 vp_clk, 
                 oenvd6, 
                 intzoom, 
                 zenv,
                 f_int,
                 flenv,
                 llenv,
                 qlinekill, 
                 ugo1st,  
                 edg656,
                 stndrd,
                 frerun,
                 intpix,
                 fldid,  
                 bypass,  
                 yuvnot,  
                 intqcif, 
                 uhot, 
                 yhot, 
                 vhot, 
                 xhot,
                 vo, 
                 fclk
                );

input  [7:0] in,
             rgbin,
             rawin;
input        resetb, 
             vp_clk, 
             oenvd6, 
             intzoom, 
             zenv,
             f_int,
             flenv,
             llenv;
input        qlinekill,
             ugo1st,
             edg656,
             stndrd,
             frerun,
             intpix,
             fldid,
             bypass,
             yuvnot,
             intqcif,
             yhot, 
             xhot, 
             uhot, 
             vhot; 
output [7:0] vo;
output       fclk;

reg          fclk_;
reg    [7:0] uvpick, 
             uvpickd1, 
             uvpickd2, 
             uvpickd3, 
             uvpickd4;
reg    [9:0] sumd1; 
wire   [7:0] sum;
wire   [9:0] sumu2;
wire  [10:0] sumu3;
reg    [7:0] vo;
reg          cclear, 
             qclear, 
             zenvd3, 
             zenvd6;
reg          zenvd10, 
             zenvd14; 
wire         clear, 
             ysel;
reg          usel; 
wire         uvaccclk; 
reg    [7:0] cout,
             dout,
             vbus, 
             ubus, 
             ybus, 
             yd1, 
             yd2, 
             yd3;
wire         leftedgecopy, 
             oenvout;
reg          qpixkill, 
             oenvd10, 
             oenvuv0, 
             oenvuv1, 
             oenvoutc, 
             oenvoutmid, 
             oenvoutq;
wire   [3:0] cword;
reg    [3:0] pword;
reg          flenvd4,
             flenvd3,
             flenvd2,
             flenvd1,
             llenvd4,
             llenvd3,
             llenvd2,
             llenvd1;
reg          cstrtd6,
             cstrtd5;
wire         cenv,
             intblip,
             cstrtd4,
             cstrt,
             cstrtenv;
reg          localfldid,
             localflenv;
reg          clksig;

// compound to make the f2clk used in accumulation
	assign uvaccclk = uhot | vhot;

// further delay oenv for QCIF
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
			oenvd10 <= 0;
		else 
			oenvd10 <= vhot ? oenvd6 : oenvd10;
	end

// local versions of oenv
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			oenvoutq <= 0;
			oenvoutmid <= 0;
			oenvoutc <= 0;
			oenvuv1 <= 0;
			oenvuv0 <= 0;
		end else begin
			oenvoutq <= vhot ? oenvoutmid : oenvoutq;
			oenvoutmid <= uhot ? oenvoutc : oenvoutmid;
			oenvoutc <= vhot ? oenvuv1 : oenvoutc;
			oenvuv1 <= uhot ? oenvuv0 : oenvuv1;
			oenvuv0 <= uhot ? (intqcif ? oenvd10 : oenvd6) : oenvuv0;
		end
	end

// compound controls, leftedgecopy is to fake-up UV with index -1
	assign leftedgecopy = oenvuv0 & !oenvuv1;
	assign oenvout = intqcif ? oenvoutq : oenvoutc;

// freeze every other QCIF 'pixel'
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
			qpixkill <= 0;
		else
//			qpixkill <= intqcif ? (xhot ? (leftedgecopy ? 1 : ~qpixkill) : qpixkill) : 0;
			qpixkill <= intqcif ? (xhot ? ((oenvd6 | oenvout) ?  ~qpixkill : 0) : qpixkill) : 0;
	end

// delay & self-gate vertical line envelope for clean address start up

// y select components (historic 650 names), using leftedgecopy as line reset
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			qclear <= 1;
			cclear <= 1;
		end else begin
			qclear <= uvaccclk ? (leftedgecopy ? 0 : (cclear ? ~qclear : qclear)) : qclear;
//			qclear <= uvaccclk ? (leftedgecopy ? 1 : (cclear ? ~qclear : qclear)) : qclear;
			cclear <= uvaccclk ? (leftedgecopy ? 1 : ~cclear) : cclear;
		end
	end
	assign clear = intqcif ? qclear : cclear;
	assign ysel = ugo1st ? clear : ~clear;

// adder for 1-2-1 UV FIR
	assign sumu3 = {1'b0,uvpickd2,2'd3} + {2'd0,uvpickd4,1'b1};
	assign sumu2 = sumu3[10:1] + {2'd0,uvpick};
	assign sum = sumu2[9:2];

// delay line for UV FIR, and late sum for V select
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			uvpickd4 <= 0;
			uvpickd3 <= 0;
			uvpickd2 <= 0;
			uvpickd1 <= 0;
			uvpick <= 0;
			sumd1 <= 0;
		end else begin
			uvpickd4 <= (!intqcif & uvaccclk) | (intqcif & vhot) ? uvpickd3 : uvpickd4;
			uvpickd3 <= (!intqcif & uvaccclk) | (intqcif & vhot) ? uvpickd2 : uvpickd3;
			uvpickd2 <= (!intqcif & uvaccclk) | (intqcif & vhot) ? uvpickd1 : (leftedgecopy ? uvpick : uvpickd2);
			uvpickd1 <= (!intqcif & uvaccclk) | (intqcif & vhot) ? uvpick : uvpickd1;
			uvpick <= (!intqcif | !qpixkill) & uvaccclk ? in : uvpick;
			sumd1 <= (!intqcif & uvaccclk) | (intqcif & vhot) & uvaccclk ? sum : sumd1;
		end
	end

// output counter and partial-UV RAM address generator

// select control for U
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
			usel <= 0;
		else
			usel <= leftedgecopy ? 0 : ((vhot & !qpixkill) ? ~usel : usel);
//			usel <= leftedgecopy ? intqcif : ((vhot & !qpixkill) ? ~usel : usel);
	end

// catch YUV new and old
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			ybus <= 0;
			yd3 <= 0;
			yd2 <= 0;
			yd1 <= 0;
			ubus <= 0;
			vbus <= 0;
		end else begin
			ybus <= vhot ? (qpixkill ? ybus : yd2) : ybus;
//			ybus <= vhot ? (intqcif ? (qpixkill ? ybus : yd3) : yd2) : ybus;
			yd3 <= yhot ? (qpixkill ? yd3 : yd2) : yd3;
			yd2 <= yhot ? (qpixkill ? yd2 : yd1) : yd2;
			yd1 <= yhot ? (qpixkill ? yd1 : in) : yd1;
			ubus <= vhot ? (qpixkill ? ubus : sum) : ubus;
			vbus <= vhot ? (qpixkill ? vbus : sumd1) : vbus;
		end
	end

// select output
	always @ (ybus or ubus or vbus or oenvout or frerun or ysel or usel) begin
//		case({!oenvout,ysel,usel})
		case({!(oenvout | frerun),ysel,usel})
				0:		dout = vbus;
				1:		dout = ubus;
				3,2:	dout = ybus;
			default:	dout = 0;
		endcase
	end

// corrections to follow Rec-656, where EAV precedes SAV in lines
// re-time fldid, avoiding changes during active V & H
    always @ (negedge flenv or negedge resetb) begin
        if(!resetb)
            localfldid <= 0;
        else
            localfldid <= fldid;
    end
// re-time f_int, avoiding changes during active H
/*
    always @ (negedge llenv or negedge resetb) begin
        if(!resetb)
            localf_int <= 0;
        else
            localf_int <= f_int;
    end
*/

// embedded control envelope (Rec 656)
//    assign cenv = embedd & (llenv != llenvd4);
    assign cenv = !bypass & (llenv != llenvd4);

// build cword (Rec 656)
//  assign cword = {1'b1,localfldid,flenv | flenvd4,llenvd4};
    assign cword = {stndrd,localfldid,localflenv,llenvd4};

// build pword (Rec 656)
    always @ (cword) begin
        case(cword[2:0])
            0: pword = 4'd0;
            1: pword = 4'd13;
            2: pword = 4'd11;
            3: pword = 4'd6;
            4: pword = 4'd7;
            5: pword = 4'd10;
            6: pword = 4'd12;
            7: pword = 4'd1;
        endcase
    end

// select embedded control output
    always @ (flenvd4 or flenvd3 or flenvd2 or flenvd1 or flenv
                or llenvd4 or llenvd3 or llenvd2 or llenvd1 or llenv or cword or pword) begin
        if((flenv != flenvd1) || (llenv != llenvd1))
            cout = 255;
        else if((flenvd3 != flenvd4) || (llenvd3 != llenvd4))
            cout = {cword,pword};
        else cout = 0;
    end
 
// select overall (embedded control and data) output
    always @ (dout or cout or rawin or rgbin or bypass or yuvnot or cenv) begin
        if(bypass) begin
       	    if(yuvnot)
                vo = rgbin;
			else
                vo = rawin;
        end else if(cenv)
            vo = cout;
        else
            vo = dout;
    end

// delayed zoom env signal
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb)
			zenvd3 <= 0;
		else
			zenvd3 <= vhot ? zenv : zenvd3;
	end
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) begin
			zenvd14 <= 0;
			zenvd10 <= 0;
			zenvd6 <= 0;
		end else begin
			zenvd14 <= vhot ? zenvd10 : zenvd14;
			zenvd10 <= vhot ? zenvd6 : zenvd10;
			zenvd6 <= vhot ? zenvd3 : zenvd6;
		end
	end

// clock out the qual clock
	always @ (posedge vp_clk or negedge resetb) begin
		if(!resetb) 
			fclk_ <= 0;
		else begin
            clksig = frerun ? (intpix ? ((intqcif | bypass) ? (!intblip & (uhot | yhot))
                                                 : (!intblip & (yhot | xhot)))
                                      : ((intqcif | bypass) ? (uhot | yhot)
                                                 : (yhot | xhot)))
                            : (stndrd ? (intqcif ? cstrtenv & (uhot | yhot)
                                                 : cstrtenv & (yhot | xhot))
                                      : (intqcif ? ~((vhot | xhot) & oenvoutmid & !qlinekill)
                                                 : ~((vhot | uhot) & oenvuv1 & (!intzoom | zenvd10))));
			fclk_ <= edg656 ? clksig : !clksig;
        end
    end

    assign fclk = yuvnot & bypass ? vp_clk : fclk_; 
// cstrt is composite for case embedd & !frerun
    assign cstrt = flenv | llenv;
    assign cstrtd4 = flenvd4 | llenvd4;
    assign cstrtenv = (!(intqcif & qlinekill) & oenvout) | (cstrt != cstrtd4);

// intblip is to kill frerun o/p clks per o/p line, just after line-end codes, if intpix=1
    assign intblip = !cstrtd4 & cstrtd6;

// delayed version of flenv & llenv
    always @ (posedge vp_clk or negedge resetb) begin
        if(!resetb) begin
            cstrtd6 <= 0;
            cstrtd5 <= 0;
            flenvd4 <= 0;
            flenvd3 <= 0;
            flenvd2 <= 0;
            flenvd1 <= 0;
            llenvd4 <= 0;
            llenvd3 <= 0;
            llenvd2 <= 0;
            llenvd1 <= 0;
            localflenv <= 1;
        end else begin
            cstrtd6 <= vhot ? cstrtd5 : cstrtd6;
            cstrtd5 <= (intqcif ? vhot : uhot) ? cstrtd4 : cstrtd5;
            flenvd4 <= vhot ? flenvd3 : flenvd4;
            flenvd3 <= (intqcif ? vhot : uhot) ? flenvd2 : flenvd3;
            flenvd2 <= vhot ? flenvd1 : flenvd2;
            flenvd1 <= (intqcif ? vhot : uhot) ? flenv : flenvd1;
            llenvd4 <= vhot ? llenvd3 : llenvd4;
            llenvd3 <= (intqcif ? vhot : uhot) ? llenvd2 : llenvd3;
            llenvd2 <= vhot ? llenvd1 : llenvd2;
            llenvd1 <= (intqcif ? vhot : uhot) ? llenv : llenvd1;
  // delay and extend flenv to cover EAV and next SAV
            localflenv <= (vhot && ((flenvd3 & !flenvd4) || (llenvd3 & !llenvd4))) ? flenv : localflenv;
        end
    end

endmodule
