/* 
 *  Description: VP Register File and "cache"
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : ch653a
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
 * 28-MAY-97:  vp_test_data ->vp_dmcode
 *  2-JUN-97:  40x exposure algorithm implemented
 *  6-JUN-97:  bypass wire
 * 10-JUN-97:  aec/acb registers (cam_at/cr removed)
 * 12-JUN-97:  voeb introduced as vp_control1[7]
 * 13-JUN-97:  acb_config[3] switches acbxx/lacc0-7
 * 18-JUN-97:  aec has priority over ale in ad
 * 19-JUN-97:  four frame cycle introduced
 * 15-JUL-97:  en,up,small_step comb. loop removed
 * 25-AUG-97:  write_63/255 now takes effect on Bunches1-2
 * 28-AUG-97:  mask f_int component of int with vp_control2[7]
 *  2-SEP-97:  card[1] bug (in ix = ix-1) fixed
*/


module ch653a (
  ad, 
  din, 
  dout, 
  wr63, 
  wr_n, 
  rd_n, 
  ale, 
  vpen, 
  si_act,  
  mhz14,
  rstb, 
  fineh,
  finel,
  coarseh,
  coarsel,
  cam_gain,
  racc,
  gacc,
  bacc,
  black_acc,
  exp_acc,
  lacc0,
  lacc1,
  lacc2,
  lacc3,
  lacc4,
  lacc5,
  lacc6,
  lacc7,
  acb00,
  acb01,
  acb02,	 
  acb10,	 
  acb11,	 
  acb12,	 
  acb20,	 
  acb21,	 
  acb22,
  scl_sif,
  sda_sif,
  LINE_NUMBER,
  HOT_PHASEOUT,
  cam_devicel,
  cam_deviceh,
  cam_statin,
  offset,
  rcomp,
  g1comp,
  g2comp,
  bcomp,
  m00,
  n00,
  m01,
  n01,
  m02,
  n02,
  m10,
  n10,
  m11,
  n11,
  m12,
  n12,
  m20,
  n20,
  m21,
  n21,
  m22,
  n22,
  apcor,
  gamcor,
  linespace,
  accscale,
  zcode0,
  zcode1,
  zcode2,
  zcode3,
  CLKDIV,
  HOT_PHASEIN,
  OVERRIDE,
  hjog,
  vjog,
  evenfirst,
  skip,
  qcif,
  zoom,
  yuvnot,
  thresh,
  color_bars,
  self_timing,
  ERROR_MASK,
  fast_serial,
  acc_sda_scl,
  vp_dmcode,
  acb_config,
  acb_gnbase,
  acb_mu,
  cam_tms,
  cam_setup0,
  cam_setup1,
  cam_setup2,
  cam_setup3,
  defcor,
  all_x,
  irq,
  eof,
  wrb,
  rdb,
  int,
  oe_n,
  voeb,
  f_int,
  sif
);

  parameter r_len=62, ch_len=10;
  parameter EXP_MAX_25FPS       = 18'h25DB6;    // {302,438}
  parameter EXP_MAX_30FPS       = 18'h25D68;    // {302,360}
  parameter A_MAX_EXP_25FPS     = 18'h211B6;    // {264,438} = EXP_MAX*(1-1/8)
  parameter A_MAX_EXP_30FPS     = 18'h21168;    // {264,360} = EXP_MAX*(1-1/8)
  parameter A_MIN_EXP_25FPS     = 18'h0578B;    // {43,395} = EXP_MAX*(1/4)
  parameter A_MIN_EXP_30FPS     = 18'h05768;    // {43,360} = EXP_MAX*(1/4)
  parameter EXP_MIN             = 18'h00000;    // absolute zero
  parameter GAIN_MAX            = 3'b111;       // max allowable gain setting
  parameter GAIN_MIN            = 3'b0;         // minimum gain
  parameter A_MIN_GAIN          = 3'b111;       // almost min gain!


  input     [7:0] din;

  output    [7:0] dout;

  output    [1:0] oe_n,
                  sif; 

  output          wr63, 
                  wrb, 
                  int, 
                  rdb;

  input           wr_n, 
                  mhz14, 
                  rd_n, 
                  vpen, 
                  ale, 
                  rstb, 
                  si_act, 
                  eof, 
                  f_int;

  input           fineh;

  input     [7:0] finel;

  input           coarseh;

  input     [7:0] coarsel;

  input     [2:0] cam_gain;

  input     [7:0] racc,
                  gacc,
                  bacc,
                  black_acc,
                  exp_acc,
                  lacc0,
                  lacc1,
                  lacc2,
                  lacc3,
                  lacc4,
                  lacc5,
                  lacc6,
                  lacc7,
       		  acb00,
       		  acb01,
       		  acb02,	 
       		  acb10,	 
       		  acb11,	 
       		  acb12,	 
       		  acb20,	 
       		  acb21,	 
       		  acb22;         
 
  input           scl_sif,
                  sda_sif;

  input     [8:0] LINE_NUMBER;

  input     [1:0] HOT_PHASEOUT;

  input     [7:0] cam_devicel,
                  cam_deviceh;

  input     [5:0] cam_statin;

  output    [7:0] offset,
                  rcomp,
                  g1comp,
                  g2comp,
                  bcomp,
                  m00,
                  n00,
                  m01,
                  n01,
                  m02,
                  n02,
                  m10,
                  n10,
                  m11,
                  n11,
                  m12,
                  n12,
                  m20,
                  n20,
                  m21,
                  n21,
                  m22,
                  n22,
                  apcor;

  output    [3:0] gamcor;

  output    [3:0] linespace;

  output    [2:0] accscale;

  output    [7:0] zcode0,
                  zcode1,
                  zcode2,
                  zcode3;

  output    [1:0] CLKDIV,
                  HOT_PHASEIN;

  output          OVERRIDE,
                  hjog,
                  vjog,
                  evenfirst,
                  skip,
                  qcif,
                  zoom,
                  voeb,
                  yuvnot;

  output    [7:0] thresh;

  output          color_bars,
                  self_timing,
                  ERROR_MASK,
                  fast_serial,
                  acc_sda_scl;

  output    [7:0] vp_dmcode,
                  acb_config,
                  acb_gnbase,
                  acb_mu,
                  cam_tms;
                          
  output    [7:0] cam_setup0,
                  cam_setup1,
                  cam_setup2,
                  cam_setup3;

  output    [5:0] defcor;

  input     [4:0] irq;

  output    [7:0] ad;

  output   [20:0] all_x; //exposure cache.

  wire            wrb    = ~vpen || wr_n || ad[7:6];

  reg       [7:0] offset,
                  rcomp,
                  g1comp,
                  g2comp,
                  bcomp,
                  m00,
                  n00,
                  m01,
                  n01,
                  m02,
                  n02,
                  m10,
                  n10,
                  m11,
                  n11,
                  m12,
                  n12,
                  m20,
                  n20,
                  m21,
                  n21,
                  m22,
                  n22,
                  apcor;

  reg       [3:0] gamcor;

  reg       [7:0] vp_control2;

  wire      [2:0] accscale  = vp_control2[6:4];

  wire      [3:0] linespace = vp_control2[3:0];
 
  reg       [7:0] zcode0,
                  zcode1,
                  zcode2,
                  zcode3;

  reg       [7:0] vp_control0;

  wire      [1:0] CLKDIV      = vp_control0[1:0];
  wire      [1:0] HOT_PHASEIN = vp_control0[3:2];

  wire            OVERRIDE    = vp_control0[4];
  wire            hjog        = vp_control0[5];
  wire            vjog        = vp_control0[6];
  wire            evenfirst   = vp_control0[7];

  reg       [7:0] vp_control1;

  wire            skip        = vp_control1[0];
  wire            qcif        = vp_control1[2];
  wire            zoom        = vp_control1[3];
  wire            yuvnot      = vp_control1[4];
  wire            voeb        = vp_control1[7];


  reg       [7:0] thresh;

  reg       [7:0] vp_test_control;
                                   //      sif[1:0],
                                   //      all_buns[388:385]

  wire            color_bars  = vp_test_control[0];
  wire            self_timing = vp_test_control[1];
  wire            ERROR_MASK  = vp_test_control[2];
  wire            fast_serial = vp_test_control[3];
  wire            acc_sda_scl = vp_test_control[6];

  reg       [7:0] vp_dmcode;

  reg       [7:0] acb_config,
                  acb_gnbase,
                  acb_mu,
                  cam_tms,
                  aec_config,
                  aec_tl,
                  aec_tc,
                  aec_th;

  reg       [4:0] vp_status_reg;

  wire      [7:0] cam_status;

  wire      [1:0] si_active;

  reg       [7:0] cam_setup0,
                  cam_setup1,
                  cam_setup2,
                  cam_setup3;

  reg       [7:0] defcor_reg;

  wire      [5:0] defcor      = defcor_reg[5:0];


//for all_x
  reg             fineh_,
                  coarseh_;
  reg       [7:0] finel_,
                  coarsel_;
  reg       [2:0] cam_gain_;

  wire      [8:0] fine_ = {fineh_, finel_};
  wire      [8:0] coarse_ = {coarseh_, coarsel_};


  reg [r_len-1:0] wck,
                  rck,
                  j;

  reg       [7:0] ad,
                  dout;

  reg       [5:0] a_c [ch_len-1:0];

  reg       [7:0] d_c [ch_len-1:0];

  reg       [3:0] ix;
  reg       [2:0] card;

  wire      [1:0] oe_n = ~vp_control1[6:5];

  reg up,
      small_step,
      en,
      eofd1;

  wire [2:0] gain_lim = aec_config[6:4];    // upper gain limit
  wire [1:0] step_size = aec_config[3:2];   // aec step size
  wire agc = aec_config[1]; // automatic gain control
  wire aec = aec_config[0]; // automatic exposure control
  wire agc_plus, agc_minus;

  integer incr_;
  integer large_step;

  assign sif = vp_test_control[5:4];
  assign rdb = ~vpen || rd_n || ad[7:6];

// pulse for sif message 
  wire wr63 = ad==63 && din[7:1] == 127 && a_c[0]<10 && !wrb ||
             (ad==47||ad>53&&ad<61) && !wrb
             || (eofd1 && aec);
// pulse for cache
  wire wr63_ = ad==63 && din[7:1] == 127 && !wrb ||
             (ad==47||ad>53&&ad<61) && !wrb;

  wire [7:0] c_d = d_c[ix];
  wire [5:0] c_a = a_c[ix];

  integer i;

  always  @ (posedge mhz14 or negedge rstb)
     if (~rstb) 
        ad <= 0;
     else if (eof && aec)
        ad <= 63;
     else if (ale)
        ad <= din;

  always @ (posedge mhz14 or negedge rstb)
     if (~rstb)
        card <= 0;
     else 
        begin 
           card[0] <= ~wrb;
           if (ix!=0 && card[1] && (eof || wr63_ && !din[0]) &&
              (a_c[0]>=10 || cam_status[1:0]==2))  // proper frame

             card[2] <= 1;
           else if (ix == 0)
	     card[2] <= 0;
	   if (ix == 0)
	     card[1] <= 0;
	   else
             card[1] <= card[1] || ad==63 && din[7:1] == 127 && !wrb;
        end

  always @ (posedge mhz14 or negedge rstb)
     if (~rstb) 
        begin
           for (i=0; i<ch_len; i=i+1)
              {a_c[i], d_c[i]} <= 0;
           ix <= 0;
        end
     else 
        if (card[1] && (eof || wr63_ && !din[0]) && // same as card
            (a_c[0]>=10 || cam_status[1:0]==2) || card[2])

           ix <= ix - {1{|ix}};
        else 
           if (!card[0] && !wrb &&
	       (ad>0 && ad<5  ||  // RGBcomp
	        ad>9 && ad<19 ||  // R/Ycoffs
	        ad>20 && ad<26))  //zones
              begin
                 {a_c[ix], d_c[ix]} <= {ad, din};
                 ix <= ix + {1{ix<ch_len-1}};
              end

  always @ (c_a or card or vp_control1)// or mhz14)
     if (~card[2])
        rck <= 0;
     else 
        begin
           j = 0;
           if (c_a<10 || c_a>20 && c_a<26)  // simple buffers
              j[c_a] = 1;
           else 
              if (vp_control1[1])           // ycoff/rcoff
                 j[c_a+16] = 1;             // 10-19/12-21
              else
                 j[c_a] = 1;
           rck <= j;
        end

  always @ (ad or wrb)
     if (wrb)
        for (i=0; i<r_len; i=i+1)
           wck[i] <= 0;
     else
        for (i=0; i<r_len; i=i+1)
           wck[i] <= i == ad;

  always @ (
            offset or
            rcomp or
            g1comp  or
            g2comp  or
            bcomp   or
            fineh or
            finel or
            coarseh or
            coarsel or
            cam_gain or
            n00 or
            m00 or
            n01 or
            m01 or
            n02 or
            m02 or
            n10 or
            m10 or
            n11 or
            m11 or
            n12 or
            m12 or
            n20 or
            m20 or
            n21 or
            m21 or
            n22 or
            m22 or
            apcor or
            gamcor or
            vp_control2 or
            zcode0 or
            zcode1 or
            zcode2 or
            zcode3 or
            racc or
            gacc or
            bacc or
            black_acc or
            exp_acc or
            lacc0 or
            lacc1 or
            lacc2 or
            lacc3 or
            lacc4 or
            lacc5 or
            lacc6 or
            lacc7 or
            acb00 or
            acb01 or
            acb02 or
            acb10 or
            acb11 or
            acb12 or
            acb20 or
            acb21 or
            acb22 or
            vp_control0 or
            vp_control1 or
            thresh or
            vp_test_control or
            sda_sif or
            scl_sif or
            vp_dmcode or
            acb_config or
            acb_gnbase or
            acb_mu or
            cam_tms or
            aec_config or
            aec_tl or
            aec_tc or
            aec_th or
            HOT_PHASEOUT or
            LINE_NUMBER or
            vp_status_reg or
            cam_devicel or
            cam_deviceh or
            cam_status or
            cam_setup0 or
            cam_setup1 or
            cam_setup2 or
            cam_setup3 or
            defcor_reg or
            ad
           )
   case (ad[5:0])
      0:   dout = offset;
      1:   dout = rcomp;
      2:   dout = g1comp; 
      3:   dout = g2comp; 
      4:   dout = bcomp;  
      5:   dout = fineh;
      6:   dout = finel;
      7:   dout = coarseh;
      8:   dout = coarsel;
      9:   dout = cam_gain;
      10:  dout = vp_control1[1] ? n00 : m00;
      11:  dout = vp_control1[1] ? n01 : m01;
      12:  dout = vp_control1[1] ? n02 : m02;
      13:  dout = vp_control1[1] ? n10 : m10;
      14:  dout = vp_control1[1] ? n11 : m11;
      15:  dout = vp_control1[1] ? n12 : m12;
      16:  dout = vp_control1[1] ? n20 : m20;
      17:  dout = vp_control1[1] ? n21 : m21;
      18:  dout = vp_control1[1] ? n22 : m22;
      19:  dout = apcor;       
      20:  dout = gamcor;       
      21:  dout = vp_control2;
      22:  dout = zcode0;
      23:  dout = zcode1;        
      24:  dout = zcode2;        
      25:  dout = zcode3;        
      26:  dout = racc;
      27:  dout = gacc;          
      28:  dout = bacc;          
      29:  dout = acb_config[3] ? acb00 : black_acc;
      30:  dout = exp_acc;       
      31:  dout = acb_config[3] ? acb01 : lacc0;
      32:  dout = acb_config[3] ? acb02 : lacc1;         
      33:  dout = acb_config[3] ? acb10 : lacc2;         
      34:  dout = acb_config[3] ? acb11 : lacc3;         
      35:  dout = acb_config[3] ? acb12 : lacc4;         
      36:  dout = acb_config[3] ? acb20 : lacc5;         
      37:  dout = acb_config[3] ? acb21 : lacc6;         
      38:  dout = acb_config[3] ? acb22 : lacc7;         
      39:  dout = vp_control0;
      40:  dout = vp_control1;
      41:  dout = thresh;
      42:  dout = {vp_test_control[7:6],sda_sif,scl_sif,vp_test_control[3:0]};
      43:  dout = vp_dmcode;
      44:  dout = acb_config;
      45:  dout = acb_gnbase;
      46:  dout = acb_mu;
      47:  dout = cam_tms;
      48:  dout = aec_config;
      49:  dout = aec_tl;
      50:  dout = aec_tc;
      51:  dout = aec_th;                       
      52:  dout = {HOT_PHASEOUT,LINE_NUMBER[0],vp_status_reg};   
      53:  dout = LINE_NUMBER[8:1];                   
      54:  dout = cam_devicel;                    
      55:  dout = cam_deviceh;                    
      56:  dout = cam_status;                     
      57:  dout = cam_setup0;   
      58:  dout = cam_setup1;                     
      59:  dout = cam_setup2;                     
      60:  dout = cam_setup3;                     
      61:  dout = defcor_reg;                 
      62:  dout = 'b00110000;  // vp_id
      63:  dout = 'b00110000;  // vp_id

   endcase


  assign si_active  = si_act || ix != 0;
  assign cam_status = {si_active,cam_statin};
  assign all_x      = {cam_gain_,coarsel_,coarseh_,finel_,fineh_};      // exposure cache

  wire w0   = wck[0];
  wire r4, r3, r2, r1, r0;
  wire w9, w8, w7, w6, w5;
  wire r10, r11, r12, r13, r14, r15, r16, r17, r18;
  wire r26, r27, r28, r29, r30, r31, r32, r33, r34;
  wire w19, w20;
  wire r25, r24, r23, r22, r21;
  wire w39, w40, w41, w42, w43, w44, w45, w46, w47, w48, w49, w50, w51;
  wire w61, w60, w59, w58, w57, w56, w55, w54, w53, w52;
  
  assign {r4,r3,r2,r1,r0}                                      = rck[4:0];
  assign {w9,w8,w7,w6,w5}                                      = wck[9:5];
  assign {r18,r17,r16,r15,r14,r13,r12,r11,r10}                 = rck[18:10];
  assign {r34,r33,r32,r31,r30,r29,r28,r27,r26}                 = rck[34:26];
  assign {w20,w19}                                             = wck[20:19];
  assign {r25,r24,r23,r22,r21}                                 = rck[25:21];
  assign {w51,w50,w49,w48,w47,w46,w45,w44,w43,w42,w41,w40,w39} = wck[51:39];
  assign {w61,w60,w59,w58,w57,w56,w55,w54,w53,w52}             = {wck[61:57], irq[4:0]};

  wire int = f_int && ~vp_control2[7] || vp_status_reg[4:0] != 0;


always @ (posedge mhz14 or negedge rstb)
   if (!rstb) begin
      eofd1 <= 0;
   end
   else begin
      eofd1 <= (eof & cam_statin[4] & ~cam_statin[1]);
   end

always @ (posedge mhz14 or negedge rstb)
   if (~rstb) begin
      offset <= 16;
      rcomp <= 201;
      g1comp <= 201;
      g2comp <= 201;
      bcomp <= 201;

      fineh_ <= 0;
      finel_ <= 0;
      coarseh_ <= 1;
      coarsel_ <= 45;
      cam_gain_ <= 0;
      incr_ = 154624;

      m00 <= 2;
      m01 <= 65;
      m02 <= 217;
      m10 <= 237;
      m11 <= 219;
      m12 <= 56;
      m20 <= 56;
      m21 <= 209;
      m22 <= 247;

      n00 <= 192;
      n01 <= 0;
      n02 <= 0;
      n10 <= 0;
      n11 <= 192;
      n12 <= 0;
      n20 <= 0;
      n21 <= 0;
      n22 <= 192;

      apcor <= 'h14;
      gamcor <= 8;

      vp_control2 <= 'h14;
      zcode0 <= 0;
      zcode1 <= 40;
      zcode2 <= 40;
      zcode3 <= 0;

      vp_control0 <= 1;
      vp_control1 <= 'h27;
      thresh <= 224;
      vp_test_control <= 0;
      vp_dmcode <= 'h1c;
      acb_config <= 1;
      acb_gnbase <= 8;
      acb_mu <= 4;
      cam_tms <= 0;
      aec_config <= 'h17;
      aec_tl <= 80;
      aec_tc <= 100;
      aec_th <= 120;
      vp_status_reg <= 0;

      cam_setup0 <= 9;
      cam_setup1 <= 'hc1;
      cam_setup2 <= 8;
      cam_setup3 <= 0;
      defcor_reg <= 8;
   end
   else begin
      if (w0 )  offset <= din;

      if (r1 )  rcomp <= c_d;
      if (r2 )  g1comp <= c_d;
      if (r3 )  g2comp <= c_d;
      if (r4 )  bcomp <= c_d;

      if (aec) begin
        if (eofd1 && en) begin
          incr_ = {coarse_,fine_} >> (small_step ? 6 : large_step);
          incr_ = (incr_ | ~|incr_);
          incr_ = incr_ ^ {18{~up}};
          incr_ =  ({coarse_,fine_} + incr_ + ~up);
          if (up) begin // increase exposure
            if (coarse_ < ((cam_setup0[3] ? EXP_MAX_30FPS : EXP_MAX_25FPS) >> 9)) begin
              if (agc_plus) begin
                {coarseh_,coarsel_,fineh_,finel_} <= ((cam_setup0[3] ? EXP_MAX_30FPS : EXP_MAX_25FPS) >> 1);
                cam_gain_ <= {cam_gain_, 1'b1}; // increase gain by one step
              end
              else {coarseh_,coarsel_,fineh_,finel_} <= incr_;
            end
          end
          else begin //decrease exposure
            if ({coarse_,fine_} > EXP_MIN) begin // Still exp range left
              if (agc_minus) begin
                {coarseh_,coarsel_,fineh_,finel_} <= ((cam_setup0[3] ? EXP_MAX_30FPS : EXP_MAX_25FPS) >> 1);
                cam_gain_ <= cam_gain_ >> 1;  // decrease gain by one step
              end
              else {coarseh_,coarsel_,fineh_,finel_} <= incr_;
            end
          end
        end
        else if (w9 && !agc) cam_gain_ <= (din <= gain_lim) ? din : gain_lim;
      end
      else begin
        if (w5 )  fineh_ <= din;
        if (w6 )  finel_ <= din;
        if (w7 )  coarseh_ <= din;
        if (w8 )  coarsel_ <= din;
      end

      if (r10)  m00 <= c_d;
      if (r11)  m01 <= c_d;
      if (r12)  m02 <= c_d;
      if (r13)  m10 <= c_d;
      if (r14)  m11 <= c_d;
      if (r15)  m12 <= c_d;
      if (r16)  m20 <= c_d;
      if (r17)  m21 <= c_d;
      if (r18)  m22 <= c_d;

      if (r26)  n00 <= c_d;
      if (r27)  n01 <= c_d;
      if (r28)  n02 <= c_d;
      if (r29)  n10 <= c_d;
      if (r30)  n11 <= c_d;
      if (r31)  n12 <= c_d;
      if (r32)  n20 <= c_d;
      if (r33)  n21 <= c_d;
      if (r34)  n22 <= c_d;

      if (w19)  apcor <= din;
      if (w20)  gamcor <= din;

      if (r21)  vp_control2 <= c_d;
      if (r22)  zcode0 <= c_d;
      if (r23)  zcode1 <= c_d;
      if (r24)  zcode2 <= c_d;
      if (r25)  zcode3 <= c_d;

      if (w39)  vp_control0 <= din;
      if (w40)  vp_control1 <= din;
      if (w41)  thresh <= din;
      if (w42)  vp_test_control <= din;
      if (w43)  vp_dmcode <= din;
      if (w44)  acb_config <= din;
      if (w45)  acb_gnbase <= din;
      if (w46)  acb_mu <= din;
      if (w47)  cam_tms <= din;
      if (w48)  aec_config <= din;
      if (w49)  aec_tl <= din;
      if (w50)  aec_tc <= din;
      if (w51)  aec_th <= din;
      if (!wrb && ad == 52)
        vp_status_reg <= vp_status_reg & din;
      else
        vp_status_reg <= vp_status_reg | irq;
      if (w57)  cam_setup0 <= din;
      if (w58)  cam_setup1 <= din;
      if (w59)  cam_setup2 <= din;
      if (w60)  cam_setup3 <= din;
      if (w61)  defcor_reg <= din;
   end

  /* The threshold state machine
   * The frame average pixel value is compared against
   * aec_tl, aec_tc  & aec_th setting the output flags
   * EN, UP and small_step for the
   * exposure calculation cycle
   *
   *      Prev:  UP      NOP     DOWN
   * Thres      (11)    (00)    (10)    <- {en,up}
   * T2<V       0%      -12%    -12%
   * Tc<V<T2    0%      0%      -1%
   * T1<V<Tc    +1%     0%      0%
   *    V<T1    +12%    +12%    0%
   *
   */
  always @ (posedge mhz14 or negedge rstb) begin
    if (~rstb)
      {en, up, small_step} <= 0;
    else if (eof &  cam_statin[4] & ~cam_statin[1]) begin // ie eodf1
      if (aec_th < exp_acc)
        {en, up, small_step} <= en && up  ? 0 : 3'b100;
      else if (aec_tc < exp_acc)
        {en, up, small_step} <= en && !up ? 3'b101 : 0;
      else if (aec_tl < exp_acc)
        {en, up, small_step} <= en && up  ? 3'b111 : 0;
      else
        {en, up, small_step} <= en && !up ? 0 : 3'b110;
    end
  end


  /* The exposure calculator.
   *
   *
   * Step:      +12%    +1%     0%      -1%     -12%
   * limit Xed
   *  EXP_MAX    0%      0%     0%      -1%     -12%
   * A_MAX_EXP   ++      ++     0%      -1%     -12%
   *  CENTRE    +12%    +1%     0%      -1%     -12%
   * A_MIN_EXP  +12%    +1%     0%       --      --
   *  EXP_MIN   +12%    +1%     0%       0%      0%
   *
   */

  always @ (step_size)
    case (step_size)
      2'b00 : large_step = 3;
      2'b01 : large_step = 4;
      2'b10 : large_step = 5;
      default : large_step = 6;
    endcase


  assign agc_minus = ({coarse_,fine_} < (cam_setup0[3] ? A_MIN_EXP_30FPS : A_MIN_EXP_25FPS)) && agc && (cam_gain_ > GAIN_MIN);
  assign agc_plus  = ({coarse_,fine_} > (cam_setup0[3] ? A_MAX_EXP_30FPS : A_MAX_EXP_25FPS)) && agc && (cam_gain_ < gain_lim);


endmodule //of ch653a
