/*
 *  Description: Receiver output mask
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : VPCKDAT
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/


`timescale 1ns/1ns

module VPCKDAT (
                vp_clk, 
                rstxxa_n, 
                rx_sftrst_n, 
                enph0, 
                DATAIN, 
                CODEIN, 
                NUMBERIN, 
                VALIDIN, 
                IMMINENTIN,
                ABANDONFRAME, 
                SOFDATAIN, 
                SOFVALIDIN, 
                SOFIMMINENTIN, 
                PIXCOUNTIN, 
                DATA_OUT, 
                LINE_CODE, 
                LINE_NUMBER, 
                DATA_VALID,
                DATA_VALID_PRE, 
                DATA_VALID_POSEN, 
                DATA_IMMINENT, 
                SOFDATA_OUT, 
                SOFDATA_VALID, 
                SOFDATA_VALID_negen, 
                SOFDATA_IMMINENT, 
                PIXEL_COUNT
               );

input        vp_clk, 
             rstxxa_n, 
             rx_sftrst_n, 
             enph0;
input  [7:0] DATAIN;
input  [2:0] CODEIN;
input  [8:0] NUMBERIN;
input        VALIDIN, 
             IMMINENTIN;
input        ABANDONFRAME;
input  [7:0] SOFDATAIN;
input        SOFVALIDIN, 
             SOFIMMINENTIN;
input  [8:0] PIXCOUNTIN;

output [7:0] DATA_OUT;
output [2:0] LINE_CODE;
output [8:0] LINE_NUMBER;
output       DATA_VALID, 
             DATA_VALID_PRE, 
             DATA_VALID_POSEN, 
             DATA_IMMINENT;
output [7:0] SOFDATA_OUT;
output       SOFDATA_VALID, 
             SOFDATA_VALID_negen,
             SOFDATA_IMMINENT;
output [8:0] PIXEL_COUNT;

reg          DATA_VALID, 
             DATA_VALID_PRE, 
             DATA_VALID_POSEN, 
             DATA_IMMINENT;
reg          SOFDATA_VALID, 
             SOFDATA_VALID_pre, 
             SOFDATA_IMMINENT;
reg    [7:0] DATA_OUT, 
             SOFDATA_OUT;
reg    [8:0] LINE_NUMBER, 
             PIXEL_COUNT;
reg    [2:0] LINE_CODE;

wire         SOFDATA_VALID_negen = (~SOFDATA_VALID_pre) & SOFDATA_VALID;


always @(ABANDONFRAME or VALIDIN)
   if (!ABANDONFRAME)
      DATA_VALID_PRE <= VALIDIN;
   else 
			DATA_VALID_PRE <= 1'b0; 

always @(DATA_VALID_PRE or DATA_VALID)
	 DATA_VALID_POSEN <= (DATA_VALID_PRE & !DATA_VALID);

always @ (posedge vp_clk or negedge rstxxa_n)
   if (!rstxxa_n) 
      begin
         DATA_OUT         <= 8'b00000000;
         LINE_NUMBER      <= 9'b000000000;
         LINE_CODE        <= 3'b111;
         DATA_VALID       <= 1'b0;
         DATA_IMMINENT    <= 1'b0;
         SOFDATA_OUT      <= 8'b00000000;
         SOFDATA_VALID    <= 1'b0;
         SOFDATA_IMMINENT <= 1'b0;
         PIXEL_COUNT      <= 9'b000000000;
      end
   else  
      if (!rx_sftrst_n) 
         begin
            DATA_OUT         <= 8'b00000000;
            LINE_NUMBER      <= 9'b000000000;
            LINE_CODE        <= 3'b111;
            DATA_VALID       <= 1'b0;
            DATA_IMMINENT    <= 1'b0;
            SOFDATA_OUT      <= 8'b00000000;
            SOFDATA_VALID    <= 1'b0;
            SOFDATA_IMMINENT <= 1'b0;
            PIXEL_COUNT      <= 9'b000000000;
         end
      else
            begin
               DATA_VALID <= DATA_VALID_PRE;
               if (!ABANDONFRAME) 
                  begin
                     DATA_OUT         <= DATAIN;
                     SOFDATA_OUT      <= SOFDATAIN;
                     LINE_NUMBER      <= NUMBERIN;
                     PIXEL_COUNT      <= PIXCOUNTIN;
                     LINE_CODE        <= CODEIN;
                     DATA_IMMINENT    <= IMMINENTIN;
                     SOFDATA_VALID    <= SOFVALIDIN;
                     SOFDATA_IMMINENT <= SOFIMMINENTIN;
                  end
               else 
                  begin
                     DATA_OUT         <= 8'b00000000;
                     LINE_NUMBER      <= 9'b000000000;
                     LINE_CODE        <= 3'b111;
                     DATA_IMMINENT    <= 1'b0;
                     SOFDATA_OUT      <= 8'b00000000;
                     SOFDATA_VALID    <= 1'b0;
                     SOFDATA_IMMINENT <= 1'b0;
                     PIXEL_COUNT      <=  9'b000000000;
                  end
            end


//

always @ (rx_sftrst_n or
          ABANDONFRAME or
          SOFVALIDIN)
   begin
      if (!rx_sftrst_n) 
         SOFDATA_VALID_pre <= 1'b0;
      else
         begin
            if (!ABANDONFRAME) 
               SOFDATA_VALID_pre <= SOFVALIDIN;
            else 
               SOFDATA_VALID_pre <= 1'b0;
         end
   end

   
endmodule 
