/*
 *  Description: Camera plugged-in/out detector
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : CAMDET
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/



module CAMDET (
               gooddata, 
               vp_clk, 
               enph0, 
               rstxxa_n, 
               rx_sftrst_n, 
               ZEROCOUNT, 
               FFCOUNT
              );

input  [3:0] gooddata;
input        vp_clk;
input        enph0;
input        rstxxa_n;
input        rx_sftrst_n;
output       ZEROCOUNT, 
             FFCOUNT;

reg    [4:0] COUNTZERO;
reg    [4:0] COUNTFF;

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n) 
         COUNTZERO <= 5'h0;
      else
         if (!rx_sftrst_n) 
            COUNTZERO <= 5'h0;
         else
            if (enph0)
               if (gooddata == 4'h0)
                  COUNTZERO <= COUNTZERO + 1;
               else
                  COUNTZERO <= 5'h0;
            else
               COUNTZERO <= COUNTZERO;
   end

always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n) 
         COUNTFF <= 5'h0;
      else
         if (!rx_sftrst_n) 
            COUNTFF <= 5'h0;
         else
            if (enph0)
               if (gooddata == 4'hF)
                  COUNTFF <= COUNTFF + 1;
               else
                  COUNTFF <= 5'h0;
            else
               COUNTFF <= COUNTFF;
   end

assign ZEROCOUNT = &COUNTZERO;
assign FFCOUNT = &COUNTFF;

endmodule //   
