/*
 *  Description: BYTEDEC State Machine
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : BYTESM
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
*/



module BYTESM (
               NEWSYNC, 
               vp_clk, 
               enph0, 
               rstxxa_n, 
               SMRESET_n, 
               BYTE_ERROR, 
               DATA_VALID, 
               COMMAND, 
               SUP1, 
               SUP2, 
               EOLCMD, 
               EOLSUP1, 
               EOLSUP2 
              );
  
  // Inputs...
input        NEWSYNC;
input        vp_clk;
input        enph0;
input        rstxxa_n;
input        SMRESET_n;
  // Outputs (and Inouts) ...
output       BYTE_ERROR;
output       DATA_VALID;
output       COMMAND;
output       SUP1;
output       SUP2;
output       EOLCMD;
output       EOLSUP1;
output       EOLSUP2;

  // Input type declarations
wire         NEWSYNC;
wire         CLK;
wire         rstxxa_n;
wire         SMRESET_n;
  
  // Output type declarations
reg          BYTE_ERROR;
reg          DATA_VALID;
reg          COMMAND;
reg          SUP1;
reg          SUP2;
reg          EOLCMD;
reg          EOLSUP1;
reg          EOLSUP2;
  
  
  
// State register values for sm1
parameter sm1_WaitNewLine=4'b0000, 
          sm1_SupByte1=4'b0001, 
          sm1_VidDataByte=4'b0010, 
          sm1_DataError=4'b0011, 
          sm1_SupByte2=4'b0100, 
          sm1_WaitVidData=4'b0101, 
          sm1_EndOfLineCmd=4'b0110, 
          sm1_EndOfLineSup2=4'b0111, 
          sm1_EndOfLineSup1=4'b1000, 
          sm1_CommandByte=4'b1001, 
          sm1_WaitSup1=4'b1010, 
          sm1_WaitSup2=4'b1011, 
          sm1_WaitEOLSup1=4'b1100, 
          sm1_WaitEOLSup2=4'b1101, 
          sm1_ExitDataError=4'b1110;


reg    [3:0] CS_sm1;
  
  //
  // Feedbacks and inputs, outputs and
  // inouts with external names if any.
  //
  
  //
  // Finite State Machine description for sm1
  //
always @ (posedge vp_clk or negedge rstxxa_n)
   begin
      if (!rstxxa_n)
         begin
            BYTE_ERROR <= 1'b0;
            DATA_VALID <= 1'b0;
            COMMAND    <= 1'b0;
            SUP1       <= 1'b0;
            SUP2       <= 1'b0;
            EOLCMD     <= 1'b0;
            EOLSUP1    <= 1'b0;
            EOLSUP2    <= 1'b0;
            CS_sm1     <= sm1_WaitNewLine;
         end  // if RESET triggered
      else
         if (!SMRESET_n)
            begin
               BYTE_ERROR <= 1'b0;
               DATA_VALID <= 1'b0;
               COMMAND    <= 1'b0;
               SUP1       <= 1'b0;
               SUP2       <= 1'b0;
               EOLCMD     <= 1'b0;
               EOLSUP1    <= 1'b0;
               EOLSUP2    <= 1'b0;
               CS_sm1     <= sm1_WaitNewLine;
            end  // if RESET triggered
         else
            if (enph0)
               begin
               // Comment on following line is for synthesis tools
                  case (CS_sm1) // $full
                     sm1_WaitNewLine:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_CommandByte;
                           else
                              CS_sm1     <= sm1_WaitNewLine; // Default transition
                        end                                  // State
      
                     sm1_SupByte1:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b1;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_DataError;
                           else
                              CS_sm1     <= sm1_WaitSup2;
                        end // State
      
                     sm1_VidDataByte:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b1;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_EndOfLineCmd;
                           else
                              CS_sm1     <= sm1_VidDataByte; // Default transition
                        end // State
      
                     sm1_DataError:
                        begin
                           BYTE_ERROR <= 1'b1;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           CS_sm1     <= sm1_ExitDataError;
                        end // State
      
                     sm1_SupByte2:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b1;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_DataError;
                           else
                              CS_sm1     <= sm1_WaitVidData;
                        end // State
      
                     sm1_WaitVidData:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_DataError;
                           else
                              CS_sm1     <= sm1_VidDataByte;
                        end // State
      
                     sm1_EndOfLineCmd:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b1;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_DataError;
                           else
                              CS_sm1     <= sm1_WaitEOLSup1;
                        end // State
      
                     sm1_EndOfLineSup2:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b1;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_DataError;
                           else
                              CS_sm1     <= sm1_WaitNewLine;
                        end // State
      
                     sm1_EndOfLineSup1:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b1;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_DataError;
                           else
                              CS_sm1     <= sm1_WaitEOLSup2;
                        end // State
      
                     sm1_CommandByte:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b1;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_DataError;
                           else
                              CS_sm1     <= sm1_WaitSup1;
                        end // State
      
                     sm1_WaitSup1:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_DataError;
                           else
                              CS_sm1     <= sm1_SupByte1;
                        end // State
      
                     sm1_WaitSup2:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_DataError;
                           else
                              CS_sm1     <= sm1_SupByte2;
                        end // State
      
                     sm1_WaitEOLSup1:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_DataError;
                           else
                              CS_sm1     <= sm1_EndOfLineSup1;
                        end // State
      
                     sm1_WaitEOLSup2:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_DataError;
                           else
                              CS_sm1     <= sm1_EndOfLineSup2;
                        end // State
      
                     sm1_ExitDataError:
                        begin
                           BYTE_ERROR <= 1'b0;
                           DATA_VALID <= 1'b0;
                           COMMAND    <= 1'b0;
                           SUP1       <= 1'b0;
                           SUP2       <= 1'b0;
                           EOLCMD     <= 1'b0;
                           EOLSUP1    <= 1'b0;
                           EOLSUP2    <= 1'b0;
                           if ((NEWSYNC == 1'b1))
                              CS_sm1     <= sm1_CommandByte;
                           else
                              CS_sm1     <= sm1_ExitDataError; // Default transition
                        end // State  
      
                  endcase
               end  // FSM for sm1 
            else
               begin
                  BYTE_ERROR <= BYTE_ERROR;
                  DATA_VALID <= DATA_VALID;
                  COMMAND    <= COMMAND;
                  SUP1       <= SUP1;
                  SUP2       <= SUP2;
                  EOLCMD     <= EOLCMD;
                  EOLSUP1    <= EOLSUP1;
                  EOLSUP2    <= EOLSUP2;
                  CS_sm1     <= CS_sm1;
               end // State  
   end


endmodule
