PROGRAM Triangles;  {Problem F - 1990}

TYPE actualpair = record x, y: real end;
     pair = ^actualpair;

     actualtriple = record x, y, z: real end;
     triple = ^actualtriple;

     Figure = ^pointrec;
     pointrec = record pt: pair; rest: Figure end;

VAR a0, a1, a2, b0, b1, b2: pair;
    poly1, poly2: Figure;
    area: real;
    finished: Boolean;

{**********Start of unit G2Vector***********}
FUNCTION newpair (x, y: real): pair;
VAR p: pair;
begin
new(p); p^.x := x; p^.y := y;
newpair := p;
end;

FUNCTION MakePoint(p:pair):pair;
begin
MakePoint := newpair(p^.x, p^.y);
end;

FUNCTION G2dVector_Mul (p: pair; a: real): pair;
begin
G2dVector_Mul := newpair(p^.x * a, p^.y * a);
end;

FUNCTION G2dVector_Add (p1, p2: pair): pair;
begin
G2dVector_Add := newpair(p1^.x + p2^.x, p1^.y + p2^.y);
end;

FUNCTION G2Vector_Intersect4Points(p1,p2,p3,p4: pair): pair;
VAR D21, D43, x,x1,x2,x3,x4, y,y1,y2,y3,y4 : real;

begin
with p1^ do begin x1 := x; y1 := y end;
with p2^ do begin x2 := x; y2 := y end;
with p3^ do begin x3 := x; y3 := y end;
with p4^ do begin x4 := x; y4 := y end;
{**writeln; writeln('G2VI4P');{**}
{**writeln('(',x1:4:2, ',', y1:4:2, ')');{**}
{**writeln('(',x2:4:2, ',', y2:4:2, ')');{**}
{**writeln('(',x3:4:2, ',', y3:4:2, ')');{**}
{**writeln('(',x4:4:2, ',', y4:4:2, ')');{**}

if (x1=x2) and (x3=x4)
  then begin writeln('Both lines vertical'); HALT end;

if (x1=x2)
  then begin
    D43 := (y3-y4)/(x3-x4);
    y := D43*x1 + (y3 - D43*x3);
    x := x1 end else
if (x3=x4)
  then begin
    D21 := (y2-y1)/(x2-x1);
    y := D21*x3 + (y1 - D21*x1);
    x := x3 end
  else begin
    D21 := (y2-y1)/(x2-x1); D43 := (y3-y4)/(x3-x4);
    if (D21=D43)
      then begin writeln('Parallel lines'); HALT end;

    x := (D21*x1 - D43*x3 + y3 - y1) / (D21-d43);
    y := D21*x - D21*x1 + y1 end;

G2Vector_Intersect4Points := NewPair(x,y);
end;

PROCEDURE ShowPoint(p : pair);
begin writeln(p^.x:14, p^.y:14) end;
{*********End of Unit G2Vector*************}

{**********Start of Unit G3Vector************}
FUNCTION NewTriple (x, y, z: real): triple;
VAR t: triple;
begin
new(t); t^.x := x; t^.y := y; t^.z := z;
newtriple := t;
end;

FUNCTION G3dVector_Cross (t0, t1: triple): triple;
var x, y, z: real;
begin
x := t0^.y * t1^.z - t0^.z * t1^.y;
y := -(t0^.z * t1^.x - t1^.z * t0^.x);
z := t0^.x * t1^.y - t0^.y * t1^.x;
G3dVector_Cross := NewTriple(x, y, z);
end;

FUNCTION G3dVector_Length (t: triple): real;
begin
G3dVector_Length := sqrt(sqr(t^.x) + sqr(t^.y) + sqr(t^.z));
end;
{************End of Unit G3Vector************}

{**********Start of Unit Figures*************}
FUNCTION CopyPoint(f : Figure):pair;
  begin CopyPoint := NewPair(f^.pt^.x, f^.pt^.y) end;

FUNCTION Cons(p:pair; fig : Figure):Figure;
VAR f : Figure;
begin
new(f); with f^ do begin pt := NewPair(p^.x, p^.y); rest := fig end;
Cons := f end;
{************End of Unit Figures*************}

PROCEDURE FindCommonArea; forward;
FUNCTION FindArea (fig: figure): real; forward;
PROCEDURE ReadData (var p: Figure); forward;
FUNCTION ClipConvexFigures (src, clip: Figure): figure; forward;
FUNCTION ClipFigureToLine (fig: Figure; p0, p1: pair): Figure; forward;
FUNCTION ReverseFigure (fig: Figure): Figure; forward;

PROCEDURE FindCommonArea;
{This is the main program - all it does is call everything else}
begin
ReadData(poly1); ReadData(poly2);
if not finished
  then begin
    area := FindArea(Poly1) + FindArea(poly2)
             - 2.0 * FindArea(ClipConvexFigures(poly1, poly2));
    write(area : 8 : 2);
  end;
end;

PROCEDURE ReadData (var p: Figure);
VAR count,i : integer;
    ax, ay: real;
    q: Figure;

begin
if not finished then begin
  read(count); finished := count = 0; p := nil;
  for i := 1 to count do begin
    read(ax, ay);
    new(q);
    with q^ do begin pt := NewPair(ax, ay); rest := p end;
    p := q;
    end;
  readln;
  p := ReverseFigure(p); {Should be SortFigure?}
  end;
end;

FUNCTION FindArea (fig: figure): real;
VAR cog : pair;
    pts : integer;
    p : figure;
    p0,p1 : pair;
    t0,t1 : triple;
    area : real;

begin
cog := NewPair(0.0, 0.0); pts := 0; p := fig;  area := 0.0;
while p <> nil do begin
  cog := G2dVector_Add(cog, p^.pt); pts := pts + 1; p := p^.rest end;
if pts = 0
  then FindArea := 0.0
  else begin
    cog := G2dVector_Mul(cog, 1.0/pts);
    p := fig;
    while p <> nil do begin
      p0 := CopyPoint(p);
      if p^.rest = nil
        then p1 := CopyPoint(fig)
        else p1 := CopyPoint(p^.rest);
      t0 := NewTriple(p0^.x-cog^.x, p0^.y-cog^.y, 0.0);
      t1 := NewTriple(p1^.x-cog^.x, p1^.y-cog^.y, 0.0);
      area := area + G3dVector_length(G3dVector_cross(t0, t1))/2.0;
      p := p^.rest end;
    FindArea := area end;
end;

FUNCTION ClipConvexFigures (src, clip: Figure): figure;
VAR result,p : figure;
    p0,p1 : Pair;

begin
result := nil;
p := src;
while p <> nil do begin
  result := Cons(p^.pt, result); p := p^.rest end;
result := ReverseFigure(result);
p := clip;
if p <> nil then
  repeat
  p0 := CopyPoint(p);
  if p^.rest = nil
    then p1 := CopyPoint(clip)
    else p1 := CopyPoint(p^.rest);
  result := ClipFigureToLine(result, p0, p1);
  p := p^.rest;
 until (p = nil) or (result = nil);
ClipConvexFigures := result;
{**WriteFigure('Clip Convex Figures', result);{**}
end;

FUNCTION ClipFigureToLine (fig: Figure; p0, p1: pair): Figure;
VAR result : Figure;
    oldPt, newPt, firstPt : Pair;
    newIn, OldIn, firstIn : Boolean;
    p : Figure;

  Function OnPlusSide(test, p0, p1 : Pair) : Boolean;
  VAR d0, d1,d : Triple;
  begin
    d0 := NewTriple(p0^.x - test^.x, p0^.y-test^.y, 0.0);
    d1 := NewTriple(p1^.x - test^.x, p1^.y-test^.y, 0.0);
    d := G3dVector_Cross(d0,d1);
    OnPlusSide := d^.z < 0.0;
  end;

  PROCEDURE MakeNewPt;
  VAR {t0,t1 : triple;}
       intersection : pair;

  begin
    if (newIn and not oldin) or (oldin and not newin)
      then begin
        {t0 := G2dVector_Line(p0,p1);                       }
        {t1 := G2dVector_Line(oldPt, newPt);                }
        {intersection := G2dVector_IntersectTwoLines(t0,t1);}
        {                                                   }
        {The above code found the intersection of two lines }
        {joining two pairs of points. The following function}
        {call does the same thing - I hope.                 }

        intersection := G2Vector_intersect4points(p0,p1,oldPt,newPt);
        result := CONS(intersection, result);
        end;
  end;

begin {Clip Figure To Line}
{**  WriteFigure('ClipFigureToLine', fig); ShowLine(p0, p1);writeln;{**}
result := nil;
p := fig;
while p <> nil do begin
  newPt := CopyPoint(p);
  newIn := OnPlusSide(newPt, p0, p1);
{**ShowPoint(newPt); ShowPoint(firstPt); {**}
  if p = fig
    then begin firstPt := MakePoint(newPt); firstIn := NewIn end
    else MakeNewPt;
  if newIn then result := CONS(newPt, result);
  oldPt := MakePoint(newPt); oldIn := newIn;
  p := p^.rest end;
newPt := MakePoint(firstPt);
{**writeln('first',firstin:6);{**}
if firstIn then newin := true else newin := false;
MakeNewPt;
result := ReverseFigure(result);
ClipFigureToLine := result;
{**WriteFigure('ClipFigureToLine',result); readln;{**}
end;

FUNCTION ReverseFigure (fig: Figure): Figure;
VAR result,p : Figure;

begin
result := nil;
p := fig;
while p <> nil do begin
  result := CONS(p^.pt, result); p := p^.rest end;
ReverseFigure := result;
end;

begin {Main}
finished := false;
while not finished do FindCommonArea;
writeln;
end.
