#include <stdio.h>
#include <stdlib.h>

#define PLAYERS 5

#define HEARTS 'H'
#define DIAMONDS 'D'
#define CLUBS 'C'
#define SPADES 'S'
#define NO_SUIT 'N'

struct card {
    char suit;
    int rank;
    int hand;
    struct card *next;
};

struct card *read_deck(void);
struct card **highest_card(struct card **list);
struct card **follower_high(struct card **list, char suit);
struct card *trick_high(struct card *list, char suit);
static int suitrank(char suit);

struct card *hands[PLAYERS];
int score[PLAYERS];

char trumps;


int main()
{
    struct card *deck, *ptr;
    int i, j;
    int lead;

    while (1) {
	deck = read_deck();

	for (i = 0; i < PLAYERS; i++) {
	    hands[i] = 0;
	    score[i] = 0;
	}

	/*
	 * Make the deal.
	 */
	for (i = 0; i < 10; i++) {
	    for (j = 0; j < PLAYERS; j++) {
		ptr = deck;
		deck = deck->next;
		ptr->next = hands[j];
		hands[j] = ptr;
		hands[j]->hand = j;
	    }
	}

	/*
	 * Done the deal---now play the game.
	 */
	trumps = NO_SUIT;
	trumps = (*highest_card(&deck))->suit;

	lead = 0;
	for (i = 0; i < 10; i++) {
	    char suit_lead;
	    struct card **best_card;
	    struct card *trick, *tmp;

	    best_card = highest_card(&hands[lead]);
	    trick = *best_card;
	    *best_card = trick->next;
	    trick->next = 0;
	    suit_lead = trick->suit;

	    for (j = 0; j < PLAYERS; j++) {
		if (j == lead) {
		    continue;
		}
		best_card = follower_high(&hands[j], suit_lead);
		tmp = *best_card;
		*best_card = tmp->next;
		tmp->next = trick;
		trick = tmp;
	    }
	    lead = trick_high(trick, suit_lead)->hand;
	    for (; trick; trick = trick->next) {
		if (trick->suit == HEARTS) {
		    score[lead] += trick->rank;
		}
	    }
	}

	printf("%3d", score[PLAYERS-1]);
	for (i = 0; i < PLAYERS - 1; i++) {
	    printf("%3d", score[i]);
	}
	printf("\n");
    }
}
	    

    struct card *
read_deck(void)
{
    struct card *head, *tail, *new;
    char buff[100];
    int i, j;
    static FILE *in_file = 0;

    if (!in_file) {
/*	if ((in_file = fopen("PROBLEMC.DAT", "r")) == 0) {
	    fprintf(stderr, "Failed to open file SP93_02.DAT\n");
	    exit(1);
	} */
	in_file = stdin;
    }

    head = 0;
    for (i = 0; i < 4; i++) {
	fgets(buff, sizeof(buff), in_file);
	if (*buff == '#') {
	    exit(0);
	}
	for (j = 0; j < 13; j++) {
	    new = malloc(sizeof(*new));

	    new->suit = buff[j*3+1];
	    switch(buff[j*3]) {
	      case '2': new->rank = 2; break;
	      case '3': new->rank = 3; break;
	      case '4': new->rank = 4; break;
	      case '5': new->rank = 5; break;
	      case '6': new->rank = 6; break;
	      case '7': new->rank = 7; break;
	      case '8': new->rank = 8; break;
	      case '9': new->rank = 9; break;
	      case 'T': new->rank = 10; break;
	      case 'J': new->rank = 11; break;
	      case 'Q': new->rank = 12; break;
	      case 'K': new->rank = 13; break;
	      case 'A': new->rank = 14; break;
	    }
	    new->next = 0;
	    if (head) {
		tail->next = new;
	    } else {
		head = new;
	    }
	    tail = new;
	}
    }
    return head;
}


    struct card **
highest_card(struct card **list)
{
    struct card **high = list;

    if (*list) {
	list = &(*list)->next;
    }
    for (; *list; list = &(*list)->next) {
	/*
	 * highest ranking card is what we're after
	 */
	if ((*list)->rank > (*high)->rank ||
	    ((*list)->rank == (*high)->rank && 
	     suitrank((*list)->suit) > suitrank((*high)->suit))) {
	    high = list;
	}
    }
    return high;
}


    struct card **
follower_high(struct card **list, char suit)
{
    struct card **high = list;

    if (*list) {
	list = &(*list)->next;
    }
    for (; *list; list = &(*list)->next) {
	/*
	 * If the cards are the same suit then choose the
	 * highest ranking one.
	 */
	if ((*list)->suit == (*high)->suit) {
	    if ((*list)->rank > (*high)->rank) {
		high = list;
	    }
	    continue;
	}

	/*
	 * Cards are different suits.  If list is the desired suit then
	 * choose it.
	 */
	if ((*list)->suit == suit) {
	    high = list;
	    continue;
	}
	
	/*
	 * If we get here then we'll stick with list if its the suit we're
	 * after or if its trumps.
	 */
	if ((*high)->suit == trumps || (*high)->suit == suit) {
	    continue;
	}

	/*
	 * If list is trumps then choose it.
	 */
	if ((*list)->suit == trumps) {
	    high = list;
	    continue;
	}

	/*
	 * Neither card is a trump or of the suit we are looking for.
	 * Go for the highest.
	 */
	if ((*list)->rank > (*high)->rank ||
	    ((*list)->rank == (*high)->rank && 
	     suitrank((*list)->suit) > suitrank((*high)->suit))) {
	    high = list;
	    continue;  /* for symmetry */
	}
    }
    return high;
}


    struct card *
trick_high(struct card *list, char suit)
{
    struct card *high = list;

    if (list) {
	list = list->next;
    }
    for (; list; list = list->next) {
	/*
	 * Check ranks if they both have the same suit.
	 */
	if (list->suit == high->suit) {
	    if (list->rank > high->rank) {
		high = list;
	    }
	    continue;
	}

	/*
	 * trumps are better than non-trumps.
	 */
	if (high->suit == trumps) {
	    continue;
	}

	/*
	 * Otherwise go for list if it is trumps or the right suit.
	 */
	if (list->suit == trumps || list->suit == suit) {
	    high = list;
	    continue;
	}
    }
    return high;
}


   static int
suitrank(char suit)
{
    if (suit == trumps) {
	return 5;
    }
    switch (suit) {
      case SPADES: return 4;      
      case HEARTS: return 3;
      case DIAMONDS: return 2;
      case CLUBS: return 1;
    }
}
