program NAVIGATE;

const
	kMax = 49;

type
	DirectionType = (north, south, east, west);
	Byte = -128..127;
	PenaltyArray = packed array[0..kMax, 0..kMax, north..west] of byte;
	DistanceArray = array[0..kMax, 0..kMax, north..west] of Integer;

	ptr = ^rec;
	rec = record
			a, s: Integer;
			dist: Integer;
			direction: DirectionType;
			next: ptr;
		end;

   proc = (SaveFirstProc, SaveSecondProc, InitheadProc);


var
	penalty: ^penaltyArray;
	distance: ^distanceArray;
	a, s, i, j: Integer;
	k: DirectionType;
	house1, house2, roadNum, startHouse, endHouse: Integer;
	startNum, endNum: Integer;
	ch, startRoad, endRoad: Char;
	head, tail: ptr;

  	firstA, firstS, secondA, secondS: Integer;
		firstK, secondK: DirectionType;
		firstD, secondD: Integer;


{$F+}
procedure SaveFirst (a, s: Integer; k: DirectionType; dist: Integer);

		begin
		firstA := a;
		firstS := s;
		firstK := k;
		firstD := dist;
		end;


	procedure SaveSecond (a, s: Integer;
									k: DirectionType;
									dist: Integer);
		begin
		secondA := a;
		secondS := s;
		secondK := k;
		secondD := dist;
		end;


procedure InitHead (avenue, street: Integer; theDir: DirectionType;
		    theDist: Integer);

	begin
	distance^[avenue, street, theDir] := theDIst;
	new(head);
	with head^ do
		begin
		a := avenue;
		s := street;
		direction := theDir;
		dist := theDist;
		next := nil;
{writeln('Head is ', a, s, direction, dist);}

		end;
	tail := head;
	end;

procedure Doit(a, s: Integer; k: DirectionType; dist: Integer; call: proc);
begin
case call of
    SaveFirstProc: SaveFirst(a, s, k, dist);
    SaveSecondProc: SaveSecond(a, s, k, dist);
    InitheadProc: Inithead(a, s, k, dist);
    end
end;


{$F-}
procedure Add (avenue, street: Integer;
								theDir: DirectionType;
								theDist: Integer);

	begin
	if (theDist < distance^[avenue, street, theDir]) then
		begin
		distance^[avenue, street, theDir] := theDIst;
		new(tail^.next);
		tail := tail^.next;
		with tail^ do
			begin
			a := avenue;
			s := street;
			direction := theDir;
			dist := theDist;
			next := nil;
{writeln ( 'Adding ' , a , s , direction , dist );{}
			end;
		end;
	end;


function MinDist (avenue, street: integer;
								direction: DirectionType): integer;
	var
		min: integer;
		dir: DirectionType;

	begin
	min := MaxInt;
	for dir := north to west do
		if (dir <> direction) and (min > distance^[avenue, street, dir]) then
			min := distance^[avenue, street, dir];
	MinDist := min;
	end;


procedure FindIntersection (startRoad: Char; startNum, startHouse: Integer;
			    call: proc);

	var
		m, d: Integer;

	begin
	d := startHouse div 100;
	m := startHouse mod 100;
	if (startRoad = 'A') then
		if (m < penalty^[startNum, d, south]) then
			if odd(startHouse) then
				DoIt(startNum, d, south, penalty^[startNum, d, south] - (m + 1) div 2, call)
			else
				DoIt(startNum, d, south, m div 2, call)
		else if (penalty^[startNum, d, south] >= 0) then
			if odd(startHouse) then
				DoIt(startNum, d + 1, north, (99 - m) div 2, call)
			else
				DoIt(startNum, d + 1, north, penalty^[startNum, d + 1, north] - (100 - m) div 2, call)
		else if odd(startHouse) then
			DoIt(startNum, d + 1, north, (99 - m) div 2, call)
		else
			DoIt(startNum, d, south, m div 2, call)
	else
		begin
		if (m < penalty^[d, startNum, west]) then
			if odd(startHouse) then
				DoIt(d, startNum, west, penalty^[d, startNum, west] - (m + 1) div 2, call)
			else
				DoIt(d, startNum, west, m div 2, call)
		else if (penalty^[d, startNum, west] >= 0) then
			if odd(startHouse) then
				DoIt(d + 1, startNum, east, (99 - m) div 2, call)
			else
				DoIt(d + 1, startNum, east, penalty^[d + 1, startNum, east] - (100 - m) div 2, call)
		else if odd(startHouse) then
			DoIt(d + 1, startNum, east, (99 - m) div 2, call)
		else
			DoIt(d, startNum, west, m div 2, call);
		end;
	end;


procedure Process;

	var
		a, s, m, d: Integer;
		dir, k: DirectionType;
		temp: ptr;


	begin
	FindIntersection(startRoad, startNum, startHouse, SaveFirstProc);
	FindIntersection(endRoad, endNum, endHouse, SaveSecondProc);
	if (startRoad = endRoad) and (startHouse div 100 = endHouse div 100) and
  (startNum = endNum) and (firstA = secondA) and (firstS = secondS) and
  (firstD > secondD) then
		writeln(firstD - secondD - 1:1)
	else
		begin
		for a := 0 to kMax do
			for s := 0 to kMax do
				for k := north to west do
					distance^[a, s, k] := MaxInt;

		FindIntersection(startRoad, startNum, startHouse, InitHeadProc);

		while (head <> nil) do
			begin
			temp := head;

			with temp^ do
				begin
{writeln('Processing ', a, s, dir);}
				for dir := north to west do
					if (dir <> direction) then
						if (penalty^[a, s, dir] < 0) then
							case dir of
							north: 
								Add(a, s - 1, south, dist + 50);
							south:
								Add(a, s + 1, north, dist + 50);
							east: 
								Add(a - 1, s, west, dist + 50);
							west: 
								Add(a + 1, s, east, dist + 50);
							end
						else if penalty^[a, s, dir] > 0 then
							add(a, s, dir, dist + penalty^[a, s, dir]);
				end;

			head := head^.next;
			dispose(temp);
			end;

		d := endHouse div 100;
		m := endHouse mod 100;
		if (endRoad = 'A') then
			if (m < penalty^[endNum, d, south]) then
				if odd(endHouse) then
					writeln(MinDist(endNum, d, south) + m div 2:1)
				else
					writeln(MinDist(endNum, d, south) + penalty^[endnum, d, south] - (m + 2) div 2:1)
			else if (penalty^[endNum, d, south] >= 0) then
				if odd(endHouse) then
					writeln(MinDist(endNum, d + 1, north) + penalty^[endNum, d + 1, north] - (101 - m) div 2:1)
				else
					writeln(MinDist(endNum, d + 1, north) + (99 - m) div 2:1)
			else if odd(endHouse) then
				writeln(MinDist(endNum, d, south) + m div 2:1)
			else
				writeln(MinDist(endNum, d + 1, north) + (99 - m) div 2:1)
		else
			begin
			if (m < penalty^[d, endNum, west]) then
				if odd(endHouse) then
					writeln(MinDist(d, endNum, west) + m div 2:1)
				else
					writeln(MinDist(d, endNum, west) + penalty^[d, endnum, west] - (m + 2) div 2:1)
			else if (penalty^[d, endNum, west] >= 0) then
				if odd(endHouse) then
					writeln(MinDist(d + 1, endNum, east) + penalty^[d + 1, endNum, east] - (101 - m) div 2:1)
				else
					writeln(MinDist(d + 1, endNum, east) + (99 - m) div 2:1)
			else if odd(endHouse) then
				writeln(MinDist(d, endNum, west) + m div 2:1)
			else
				writeln(MinDist(d + 1, endNum, east) + (99 - m) div 2:1)
			end;
		end;
	end;


begin
New(penalty);
New(distance);

for a := 0 to kMax do
	for s := 0 to kMax do
		for k := north to west do
			penalty^[a, s, k] := -1;

for a := 0 to kMax do
	begin
{penalty^[10, a, east] := 0;{}
{penalty^[14, a, west] := 0;{}
{penalty^[a, 14, north] := 0;{}
{penalty^[a, 18, south] := 0;{}
	penalty^[0, a, east] := 0;
	penalty^[kMax, a, west] := 0;
	penalty^[a, 0, north] := 0;
	penalty^[a, kMax, south] := 0;
	end;

repeat
	read(ch);
	if (ch <> '#') then
		begin
		readln(roadNum, house1, house2);
		if (ch = 'S') then
			begin
			penalty^[house1 div 100, roadNum, west] := house1 mod 100;
			penalty^[house2 div 100 + 1, roadNum, east] := 98 - house2 mod 100;
			for i := house1 div 100 + 1 to house2 div 100 do
				begin
				penalty^[i, roadNum, east] := 0;
				penalty^[i, roadNum, west] := 0;
				end;
			end
		else
			begin
			penalty^[roadNum, house1 div 100, south] := house1 mod 100;
			penalty^[roadNum, house2 div 100 + 1, north] := 98 - house2 mod 100;
			for i := house1 div 100 + 1 to house2 div 100 do
				begin
				penalty^[roadNum, i, north] := 0;
				penalty^[roadNum, i, south] := 0;
				end;
			end;
		end;
until ch = '#';
readln;

repeat
	read(ch);
	if (ch <> '#') then
		begin
		startRoad := ch;
		read(startNum, startHouse, ch);
		while (ch = ' ') do
			read(ch);
		endRoad := ch;
		readln(endNum, endHouse);
		Process;
		end;
until ch = '#';
end.