program whatever;

#include "str.h"

type
	ByteSet = set of 0..255;
	BigType = array[1..250] of string;
	BigTypePtr = ^BigType;

var
	numP, numT: Integer;
	numWords, i, j: Integer;
	infile: text;
	ch: char;
	aline: string;
	profile: BigType;
	aWord: BigTypePtr;

#undef inc
procedure Inc (var num: Integer; amount: Integer);

	begin
	num := num + amount;
	end;

procedure Tidy (var line: string);

	var
		i: Integer;

	begin
	for i := Length(line) downto 1 do
		if line[i] in ['A'..'Z'] then
			line[i] := Chr(Ord(line[i]) + 32)
		else if not (line[i] in ['a'..'z', ' ']) then
			Delete(line, i, 1);
	line := ' ' + line + ' ';
	while (pos('  ', line) <> 0) do
		Delete(line, Pos('  ', line), 1);
	end;


procedure doit;

	var
		result: array[1..250] of ByteSet;
		threshold: array[1..250] of Integer;
		finished: Boolean;
		line: string;
		i, j: Integer;
		first: Boolean;


	procedure Process;

		var
			p, i, j, pos1, pos2: Integer;
			found: Boolean;
			ch: Char;

		begin
		for p := 1 to numP do
			begin
			found := False;
			i := 1;
			while (not found) and (i < numWords) do
				begin
				pos1 := Pos(' ' + aWord^[i] + ' ', profile[p]);
				ch := profile[p][pos1 + 1];
				profile[p][pos1 + 1] := Chr(0);
				j := i + 1;
				if (pos1 > 0) then
					while (not found) and (j <= numWords) and (j <= i + threshold[p] + 1) do
						begin
						pos2 := Pos(' ' + aWord^[j] + ' ', profile[p]);
						found := (pos1 > 0) and (pos2 > 0);
						j := j + 1;
						end;
				profile[p][pos1 + 1] := ch;
				inc(i, 1);
				end;
			if found then
				result[p] := result[p] + [numT];
			end;
		end;


	begin
	numP := 0;
	repeat
		read(ch);
		if (ch = 'P') then
			begin
			inc(numP, 1);
			readln(ch, threshold[numP], profile[numP]);
			tidy(profile[numP]);
			result[numP] := [];
			end;
	until (ch = 'T');

	numT := 0;
	while (ch = 'T') do
		begin
		Inc(numT, 1);
		readln(ch, line);
		numWords := 0;
		repeat
			finished := line[length(line)] = '|';
			tidy(line);
			Delete(line, 1, 1);
			while (line <> '') do
				begin
				inc(numWords, 1);
				aWord^[numWords] := Copy(line, 1, Pos(' ', line) - 1);
				Delete(line, 1, Pos(' ', line));
				end;
			if not finished then
				readln(line);
		until finished;

		Process;

		read(ch);
		end;

	for i := 1 to numP do
		begin
		write(i : 1, ':');
		first := true;
		for j := 1 to numT do
			if (j in result[i]) then
				begin
				if first then write(' ');
				first := false;
				write(j : 1);
				result[i] := result[i] - [j];
				if result[i] <> [] then
					write(',');
				end;
		writeln;
		end;
	end;

begin
new(aword);
doit;
end.