program trial (input, output);

#include "str.h"

type
  char_set = set of char;

var
  line: string;



procedure replace (a, b: string);

(* replace all occurances of 'a' with 'b' *)

  var
    p, start, finish: integer;

  begin
  p := pos(a, line);
  while (p <> 0) do
    begin
    delete(line, p, length(a));
    insert(b, line, p);
    p := pos(a, line);
    end;
  end;


function In_set (start, finish: integer;
                the_set: char_set): boolean;

  var
    ok: boolean;
    loop: integer;

  begin
  ok := TRUE;
  for loop := start to finish do
    ok := ok AND (line[loop] in the_set);
  in_set := ok;
  end;


function valid: boolean;

  var
    loop, ptr, start, finish: integer;
    ok: boolean;
    tidy_line: string;
    ch: char;

  begin
  ok := TRUE;
  ok := in_set(1, length(line), ['A'..'Z', '"', '.', ' ', '0'..'9']);

(* single spaced *)
  replace('  ', ' ');
  tidy_line := line;

(* sign = "signwords" *)
(* signwords = s-word OR signwords s-word *)
(* s-word = letter OR s-word (no intervening space) letter *)
(* letter = A..Z OR . *)
  ok := ok and (pos('""', line) = 0) and (pos('" "', line) = 0);
  start := pos('"', line);
  while ok and (start > 0) do
    begin
    line[start] := '*';
    finish := pos('"', line);
    ok := (finish <> 0) and in_set(start + 1, finish - 1, ['A'..'Z', '.', ' ']);
    if ok then
      begin
      delete(line, start, finish - start + 1);
      insert('sign', line, start);
      end;
    start := pos('"', line);
    end;

  if ok then
    begin
(* nnn = digit OR nnn (no intervening space) digit *)
(* digit = 0 .. 9 *)
    for ch := '0' to '9' do
      replace(ch, 'dgt');
    replace('dgtdgt', 'dgt');
    replace('dgt', 'nnn');

(* cas = CHANGE AVERAGE SPEED OR CAS *)
    replace('CHANGE AVERAGE SPEED', 'cas');
    replace('CAS', 'cas');

(* time-keeping = record OR change *)
(* record = RECORD TIME *)
(* change = cas TO nnn KMH *)
    replace('RECORD TIME', 'time');
    replace('cas TO nnn KMH', 'time');

(* where = AT sign *)
    replace('AT sign', 'where');

(* when = FIRST OR SECOND OR THIRD *)
    replace('FIRST', 'when');
    replace('SECOND', 'when');
    replace('THIRD', 'when');

(* direction = RIGHT OR LEFT *)
    replace('RIGHT', 'direction');
    replace('LEFT', 'direction');

(* how = GO OR GO when OR KEEP *)
    replace('GO when', 'how');
    replace('GO', 'how');
    replace('KEEP', 'how');

(* directional = how direction OR how direction where *)
    replace('how direction where', 'd');
    replace('how direction', 'd');

(* navagational = directional OR navagational AND THEN directional *)
    replace('d AND THEN d', 'd');
    replace('d', 'n');

(* instruction = navagational OR time-keeping OR navigational AND time-keeping *)
    replace('n AND time', 'i');
    replace('n', 'i');
    replace('time', 'i');

    ok := (line = 'i');
    end;

  line := tidy_line;
  valid := ok;
  end;


procedure doit;

  var
    line_number: integer;

  begin
  line_number := 0;
  readln(line);
  while (line <> '#') do
    begin
    line_number := line_number + 1;
  write(line_number : 3, '. ');
    if valid then
      writeln(line)
    else
      writeln('Trap!');
    readln(line);
    end;
  end;


begin
doit;
end.

