#include <stdio.h>
FILE *inp, *outp;

int board[2][30][30];
char centipede[10];
int  curr,next,num_cent;

void copy_collides(void)
{ int x,y;
	for (x=0; x<30; x++)
	{ for (y=0; y<30; y++)
		{ if (board[curr][x][y] == 255)
			{ board[next][x][y] = 255; }
		}
	}
}

void read_sim(void)
{ int i, x, y, len;

	curr=0; next=1;
	memset ( &(board[curr][0][0]), -1, sizeof(int)*30*30 );
	fscanf(inp,"%d", &num_cent);
	fscanf(inp,"\n");

	for (i=0; i<num_cent; i++)
	{ fscanf(inp,"%c %d %d %d", &(centipede[i]), &len, &x, &y);
		fscanf(inp,"\n");
		for ( ; len; len--)
		{ board[curr][x][y]=i;
			switch(centipede[i])
			{ case 'U': y--; break;
				case 'D': y++; break;
				case 'L': x++; break;
				case 'R': x--; break;
			}
		}
	}
}

void print_sim(void)
{ int x,y;

	fprintf(outp,"   0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2\n");
	fprintf(outp,"   0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9\n");
	for (y=29; y>=0; y--)
	{ fprintf(outp,"%02d",y);
		for (x=0; x<30; x++)
		{ if (board[curr][x][y] == -1)
			{ fprintf(outp," ."); }
			else
			{ fprintf(outp," X"); }
		}
		fprintf(outp,"\n");
	}
	fprintf(outp,"\n");
}

void run_sim(void)
{ int movement,x,tx,y,ty,c;

	movement=1;
	while (movement)
	{ memset ( &(board[next][0][0]), -1, sizeof(int)*30*30 );
		copy_collides();
		movement=0;
		for (c=0; c<num_cent; c++)
		{ for (x=0; x<30; x++)
			{ for (y=0; y<30; y++)
				{ if (c == board[curr][x][y])
					{ movement=1;
						if ( (board[next][x][y] != c) && (board[next][x][y] !=-1) )
																				 /* A lower-numbered centipede may */
						{ board[next][x][y] = 255; } /* have moved on top of us ...    */
						else                         /* do not move.                   */
						{ tx=x; ty=y;
							switch (centipede[c])
							{ case 'U': ty++; break;
								case 'D': ty--; break;
								case 'L': tx--; break;
								case 'R': tx++; break;
							}
							if ( (tx>=0) && (tx<30) && (ty>=0) && (ty<30) )
							{ if (board[next][tx][ty] != -1)
								{ board[next][tx][ty]=255; }
								else
								{ board[next][tx][ty]=c; }
							}
						}
					}
				}
			}
		}
		next=1-next; curr=1-curr;
	}
}

void main(void)
{ int  i, j;

	inp=fopen("collide.in","r");
	outp=fopen("collide.out","w");

	while (!feof(inp))
	{ read_sim();
		run_sim();
		print_sim();
	}
	fclose(inp);
	fclose(outp);
}