/*  Contest: Southwestern European Regionals 1997
 *  Problem: Island of Logic
 *  Author : Mark Dettinger 
 */

#include <stdio.h>
#include <string.h>
#include <assert.h>

#define DIVINE 1
#define EVIL 2
#define HUMAN 4
#define NOTDIVINE 6
#define NOTEVIL 5
#define NOTHUMAN 3
#define ANYTHING 7

#define LYING 8
#define NOTLYING 16

#define DAY 1
#define NIGHT 2
#define UNKNOWN 3

#define NATURE -1

#define MAX(a,b) ((a)>(b)?(a):(b))
#define DBG(x)

typedef struct
{
  int who;    /* who made the statement? */
  int about;  /* about whom? */
  int what;   /* what did he say about him? */
}
statement;

FILE *input;
int kase=0;
statement st[100];
int numstatements;  /* number of statements given */
int numpeople;      /* number of people involved */

int time;           /* current time: day or night */
int status[20];     /* status[i] = status of person i */ 

int time_possible;  /* possible values for time */
int possible[20];   /* possible races for people */
int solutions;      /* number of worlds consistent with statements */

int read_case()
{
  char line[100],what[20],who,about;
  int i;

  fscanf(input,"%d ",&numstatements);
  if (numstatements==0) return 0;
  numpeople = 0;
  for (i=0; i<numstatements; i++)
    {
      fscanf(input,"%c: %[^\n] ",&who, line);
      DBG(printf("%s\n",line));
      st[i].who = who-'A';
      numpeople = MAX(numpeople,st[i].who+1);
      if (0==strcmp(line,"It is day."))
	{
	  st[i].about = NATURE;
	  st[i].what = DAY;
	}
      else if (0==strcmp(line,"It is night."))
	{
	  st[i].about = NATURE;
	  st[i].what = NIGHT;
	}
      else
	{
	  if(line[2] == 'a')
	    {
	      sscanf(line,"I am %[^.]", what);
	      about = who;
	    }
	  else
	    sscanf(line,"%c is %[^.]",&about, what);
	  st[i].about = about-'A';
	  numpeople = MAX(numpeople,st[i].about+1);
	  if (0==strcmp(what,"divine"))
	    st[i].what = DIVINE;
	  else if (0==strcmp(what,"evil"))
	    st[i].what = EVIL;
	  else if (0==strcmp(what,"human"))
	    st[i].what = HUMAN;
	  else if (0==strcmp(what,"not divine"))
	    st[i].what = NOTDIVINE;
	  else if (0==strcmp(what,"not evil"))
	    st[i].what = NOTEVIL;
	  else if (0==strcmp(what,"not human"))
	    st[i].what = NOTHUMAN;
	  else if (0==strcmp(what,"lying"))
	    st[i].what = LYING;
	  else if (0==strcmp(what,"not lying"))
	    st[i].what = NOTLYING;
	  else
	    {
	      printf("Error in input file!\n");
	      exit(1);
	    }
	}
    }
  return 1;
}

void visit (int person)
{
  int i,truth;

  if (person==numpeople)
    {
      /* check statements */
      for (i=0; i<numstatements; i++)
	{
	  /* check statement i */	 
	  if (status[st[i].who]==DIVINE ||
	      (status[st[i].who]==HUMAN && time==DAY))  /* statement should be true */
	    {
	      if (st[i].about==NATURE)
		{
		  if (st[i].what!=time) return;
		}
	      else
		{
		  truth = status[st[i].about]==DIVINE || (status[st[i].about]==HUMAN && time==DAY);
		  if (truth && st[i].what==LYING) return;
		  if (truth && st[i].what==NOTLYING) continue;
		  if (!truth && st[i].what==LYING) continue;
		  if (!truth && st[i].what==NOTLYING) return;
		  if ((status[st[i].about] & st[i].what) == 0) return;
		}
	    }
	  else  /* statement should be false */
	    {
	      if (st[i].about==NATURE)
		{
		  if (st[i].what==time) return;
		}
	      else
		{
		  truth = status[st[i].about]==DIVINE || (status[st[i].about]==HUMAN && time==DAY);
		  if (truth && st[i].what==LYING) continue;
		  if (truth && st[i].what==NOTLYING) return;
		  if (!truth && st[i].what==LYING) return;
		  if (!truth && st[i].what==NOTLYING) continue;
		  if ((status[st[i].about] & st[i].what) != 0) return;
		}
	    }
	}
      /* constellation is possible */
      solutions++;
      time_possible |= time;
      for (i=0; i<numpeople; i++)
	possible[i] |= status[i];
      return;
    }
  /* try out the three possibilities for person #person */
  status[person] = DIVINE;
  visit(person+1);
  status[person] = EVIL;
  visit(person+1);
  status[person] = HUMAN;
  visit(person+1);
}

void check_for_conclusions()
{
  int i,conclusions=0;
  
  if (solutions==0)
    {
      printf("This is impossible.\n");
      return;
    }
  for (i=0; i<numpeople; i++)
    switch (possible[i])
      {
      case DIVINE:    printf("%c is divine.\n",i+'A'); conclusions++; break;
      case EVIL:      printf("%c is evil.\n",i+'A');   conclusions++; break;
      case HUMAN:     printf("%c is human.\n",i+'A');  conclusions++; break;
      /*case NOTDIVINE: printf("%c is not divine.\n",i+'A'); conclusions++; break;*/
      /*case NOTEVIL:   printf("%c is not evil.\n",i+'A');   conclusions++; break;*/
      /*case NOTHUMAN:  printf("%c is not human.\n",i+'A');  conclusions++; break;*/
      /*case ANYTHING:  printf("%c can be anything.\n",i+'A'); break;*/
      }
  switch (time_possible)
    {
    case DAY:     printf("It is day.\n"); conclusions++; break;
    case NIGHT:   printf("It is night.\n"); conclusions++; break;
    /*case UNKNOWN: printf("Can't determine whether it's day or night.\n"); break;*/
    }
  if (conclusions==0) printf("No facts are deducible.\n");
}

void try_all()
{
  int i;

  solutions = 0;
  time_possible = 0;
  for (i=0; i<numpeople; i++)
    possible[i] = 0;
  time = DAY;
  visit(0);
  time = NIGHT;
  visit(0);
}

void solve_case()
{
  printf("Conversation #%d\n",++kase);
  try_all();
  check_for_conclusions();
  DBG(printf("There are %d possible constellations.\n",solutions));
  printf("\n");
}

int main ()
{
  input = fopen("island.in","r");
  assert(input!=NULL);
  while (read_case()) solve_case();
  fclose(input);
  return 0;
}

