/*

1995-96 ACM International Collegiate Programming Contest
Southwestern European Regional Contest
ETH Zurich, Switzerland
December 9, 1995


Problem: Triangle

Idea and first implementation:	Berni Seybold, ETH Zurich
Implementation:					Manuel Bleichenbacher, Head Judge

This program analyzes triangle.out and compares it against triangle.sol.
It knows about the messages "More than one solution." and "Invalid input."
and it does floating-point comparison with a epsilon.

*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include <string.h>


typedef enum {
	FALSE = 0,
	TRUE = 1
} bool;


const char* cFileIn =	"triangle.in";
const char* cFileOut = 	"triangle.out";
const char* cFileSol =	"triangle.sol";

const double cEps = 0.00001;


FILE* gFin;		/* test input */
FILE* gFout;	/* program output */
FILE* gFsol;	/* correct program output */


bool CheckEOF();
void PutError( char* lineIn, char* lineOut, char* lineSol, int line, char* msg );
bool TestTriangle();

double pi;


bool CheckEOF()
{
	if (feof(gFin)) {
		printf("Not enough lines in file \"%s\".", cFileIn);
		return TRUE;
	}
	if (feof(gFout)) {
		printf("Not enough lines in file \"%s\".", cFileOut);
		return TRUE;
	}
	if (feof(gFsol)) {
		printf("Not enough lines in file \"%s\".", cFileSol);
		return TRUE;
	}
	return FALSE;
}


void PutError( char* lineIn, char* lineOut, char* lineSol, int line, char* msg )
{
	printf("Error on line %d: %s.\n", line, msg);
	printf("  %s : %s\n", cFileIn, lineIn);
	printf("  %s: %s\n", cFileOut, lineOut);
	printf("  %s: %s\n", cFileSol, lineSol);
}


bool TestTriangle()
{
	int n, i;
	int dummy;
	char lineIn[256], lineOut[256], lineSol[256];
	double pout[6];
	double psol[6];
	int j;
	bool okay = TRUE;
			
	
	gFout = fopen(cFileOut, "r");
	if (gFout == 0) {
		printf("File \"%s\" not found.\n", cFileOut);
		return FALSE;
	}
	
	gFin = fopen(cFileIn, "r");
	if (gFin == 0) {
		printf("File \"%s\" not found.\n", cFileIn);
		return FALSE;
	}
	
	gFsol = fopen(cFileSol, "r");
	if (gFsol == 0) {
		printf("File \"%s\" not found.\n", cFileSol);
		return FALSE;
	}
	
	fgets( lineIn, 256, gFin );
	dummy = sscanf( lineIn, "%d", &n );
	assert( dummy == 1 );
	
	for (i = 0; i < n; i++) {
		if ( CheckEOF() )
			return FALSE;
		
		fgets( lineIn, 256, gFin );
		if (lineIn[strlen(lineIn)-1] == '\n')
			lineIn[strlen(lineIn)-1] = '\0';
		fgets( lineOut, 256, gFout );
		if (lineOut[strlen(lineOut)-1] == '\n')
			lineOut[strlen(lineOut)-1] = '\0';
		fgets( lineSol, 256, gFsol );
		if (lineSol[strlen(lineSol)-1] == '\n')
			lineSol[strlen(lineSol)-1] = '\0';
		
		if (lineSol[0] == 'M' || lineSol[0] == 'I') {	/* no numbers on this line */
			assert(strcmp("More than one solution.",lineSol)==0||strcmp("Invalid input.",lineSol)==0);
			if ( strcmp(lineOut, lineSol) != 0 ) {
				PutError( lineIn, lineOut, lineSol, i, "different message");
				okay = FALSE;
			}
		} else {	/* try parsing the numbers */
			dummy = sscanf( lineSol, "%lf %lf %lf %lf %lf %lf",
					&psol[0], &psol[1], &psol[2], &psol[3], &psol[4], &psol[5] );
			assert( dummy == 6 );
			dummy = sscanf( lineOut, "%lf %lf %lf %lf %lf %lf",
					&pout[0], &pout[1], &pout[2], &pout[3], &pout[4], &pout[5] );
			if (dummy != 6) {
				PutError( lineIn, lineOut, lineSol, i, "not six numbers found" );
				okay = FALSE;
			} else {
				for (j = 0; j < 6; j++) {
					if ( fabs( psol[j] - pout[j] ) > cEps * psol[j] ) {
						PutError( lineIn, lineOut, lineSol, i, "different numbers" );
						okay = FALSE;
						break;
					}
				}
			}
		}
		
	}
	return okay;
}
	

int main(int argc, char* argv[])
{
	pi = atan(1) * 4.0;
	
	if ( TestTriangle() )
		printf("PROGRAM ACCEPTED.\n");
	else
		printf("WRONG OUTPUT.\n");
	
	if (gFin != 0)
		fclose( gFin );
	if (gFout != 0)
		fclose( gFout );
	if (gFsol != 0)
		fclose( gFsol );
		
	return 0;
}
