clear; 
Ts=0.1;      %sampling time
data_n=5;   %the number of training data
A=[ 7  -12  
    1   0]
B=[1 0]'
C=[1 0]
D=0                                      
pole=eig(A)      
controlbi=[B A*B];
rankn=rank(controlbi);
pause
[Ad,Bd,Cd,Dd]=c2dm(A,B,C,D,Ts,'zoh')

%% choose a desired model and get training data
F=[-7  -12
    1   0 ]
desireP=eig(F)
pause
[Fd,Gd,Hd,Id]=c2dm(F,B,C,D,Ts,'zoh');                  

%%% training data
des_gap(1)=0;des_dgap(1)=0;
sys_gap(1)=0;sys_dgap(1)=0;
ind=[1:1:data_n-1];                                                            
for j=ind,
 stad_r(j)=1;
 des_gap(j+1)=Fd(1,1)*des_gap(j)+Fd(1,2)*des_dgap(j)+Gd(1,1)*stad_r(j);
 sys_gap(j+1)=Ad(1,1)*sys_gap(j)+Ad(1,2)*sys_dgap(j)+Bd(1,1)*stad_r(j);

 des_dgap(j+1)=Fd(2,1)*des_gap(j)+Fd(2,2)*des_dgap(j)+Gd(2,1)*stad_r(j);
 sys_dgap(j+1)=Ad(2,1)*sys_gap(j)+Ad(2,2)*sys_dgap(j)+Bd(2,1)*stad_r(j);
end;      

Xk(1)=0;
j=ind;                                                                
Xk(j+1)=(des_gap(j+1)-(Ad(1,1)*sys_gap(j)+Ad(1,2)*sys_dgap(j)))/Bd(1,1);

u=ones(data_n,1);
u(1,1)=0;
trn_data=[u Xk' des_gap'];

%%% Train ANFIS
NumMfs = 2;
MfType = 'gbellmf';
NumEpochs = 15;
ErrorGoal = 0.01;
StepSize = 0.1;
InputFismat = genfis1(trn_data, NumMfs, MfType);
OutputFismat = anfis(trn_data, InputFismat, [NumEpochs ErrorGoal StepSize]);

%%% Control
% initialize  
new_gap(1)=0.5;new_dgap(1)=0;
ref_gap(1)=1;ref_dgap(1)=0;
k=1;
U=1;
% start to simulate 
while abs(new_gap(k)- ref_gap(k))>0.001,

input=[U,new_gap(k)]
plantI(k) = evalfis(input , OutputFismat);
                                            
new_gap(k+1)=Ad(1,1)*new_gap(k)+Ad(1,2)*new_dgap(k)+Bd(1,1)*plantI(k);
new_dgap(k+1)=Ad(2,1)*new_gap(k)+Ad(2,2)*new_dgap(k)+Bd(2,1)*plantI(k);
ref_gap(k+1)=Fd(1,1)*ref_gap(k)+Fd(1,2)*ref_dgap(k)+Gd(1,1)*U;
ref_dgap(k+1)=Fd(2,1)*ref_gap(k)+Fd(2,2)*ref_dgap(k)+Gd(2,1)*U;

InputFismat = OutputFismat;
l=length(trn_data);
ref_Xk=(ref_gap(k+1)-(Ad(1,1)*new_gap(k)+Ad(1,2)*new_dgap(k)))/Bd(1,1);
trn_data=[trn_data(2:l,:)
          U new_gap(k) ref_Xk];
[OutputFismat,error] = anfis(trn_data, InputFismat, [NumEpochs ErrorGoal StepSize]);
k=k+1;

end;


%%% plot step response of original system
figure
step(A,B,C,D)
title('Step response of original system(order 2)')

%%% plot the process
T=[0:0.1:0.1*(k-1)];
figure;                           
plot(T,new_gap,'r-',T,ref_gap,'g--');  
title('Specialized learning(order 2, TD_n=5)');
xlabel('Time');  ylabel('Position');
                    
figure;
plot(error);
title('Root mean squared error(order 2, TD_n=5)');
