function [ret,x0,str,ts,xts]=fproj_1_(t,x,u,flag);
%FPROJ_1_	is the M-file description of the SIMULINK system named FPROJ_1_.
%	The block-diagram can be displayed by typing: FPROJ_1_.
%
%	SYS=FPROJ_1_(T,X,U,FLAG) returns depending on FLAG certain
%	system values given time point, T, current state vector, X,
%	and input vector, U.
%	FLAG is used to indicate the type of output to be returned in SYS.
%
%	Setting FLAG=1 causes FPROJ_1_ to return state derivatives, FLAG=2
%	discrete states, FLAG=3 system outputs and FLAG=4 next sample
%	time. For more information and other options see SFUNC.
%
%	Calling FPROJ_1_ with a FLAG of zero:
%	[SIZES]=FPROJ_1_([],[],[],0),  returns a vector, SIZES, which
%	contains the sizes of the state vector and other parameters.
%		SIZES(1) number of states
%		SIZES(2) number of discrete states
%		SIZES(3) number of outputs
%		SIZES(4) number of inputs
%		SIZES(5) number of roots (currently unsupported)
%		SIZES(6) direct feedthrough flag
%		SIZES(7) number of sample times
%
%	For the definition of other parameters in SIZES, see SFUNC.
%	See also, TRIM, LINMOD, LINSIM, EULER, RK23, RK45, ADAMS, GEAR.

% Note: This M-file is only used for saving graphical information;
%       after the model is loaded into memory an internal model
%       representation is used.

% the system will take on the name of this mfile:
sys = mfilename;
new_system(sys)
simver(1.3)
if (0 == (nargin + nargout))
     set_param(sys,'Location',[132,196,714,555])
     open_system(sys)
end;
set_param(sys,'algorithm',     'RK-45')
set_param(sys,'Start time',    '0')
set_param(sys,'Stop time',     '10000')
set_param(sys,'Min step size', '0.0001')
set_param(sys,'Max step size', '0.01')
set_param(sys,'Relative error','1e-3')
set_param(sys,'Return vars',   '')
set_param(sys,'Load callback',['fismat=genfis1([2 2 0;-2 -2 0]);fismat=setfis(fismat,''outmfparams'', rand(4,3));']);
set_param(sys,'AssignSampleTimeColors','on');
set_param(sys,'AssignWideVectorLines','on');


%     Subsystem  'On-line ANFIS'.

new_system([sys,'/','On-line ANFIS'])
set_param([sys,'/','On-line ANFIS'],'Location',[125,491,330,691])

add_block('built-in/Inport',[sys,'/','On-line ANFIS/in_2'])
set_param([sys,'/','On-line ANFIS/in_2'],...
		'Port','2',...
		'position',[15,115,35,135])

add_block('built-in/Outport',[sys,'/','On-line ANFIS/out_1'])
set_param([sys,'/','On-line ANFIS/out_1'],...
		'position',[190,90,210,110])

add_block('built-in/Inport',[sys,'/','On-line ANFIS/in_1'])
set_param([sys,'/','On-line ANFIS/in_1'],...
		'position',[15,60,35,80])

add_block('built-in/S-Function',[sys,'/','On-line ANFIS/ANFIS1'])
set_param([sys,'/','On-line ANFIS/ANFIS1'],...
		'function name','sfanfis1',...
		'parameters','fismat,lambda_ss,sample_time,out_fis_name',...
		'position',[115,74,170,126])

add_block('built-in/Mux',[sys,'/','On-line ANFIS/Mux4'])
set_param([sys,'/','On-line ANFIS/Mux4'],...
		'hide name',0,...
		'inputs','2',...
		'position',[65,80,90,120])
add_line([sys,'/','On-line ANFIS'],[40,125;60,110])
add_line([sys,'/','On-line ANFIS'],[175,100;185,100])
add_line([sys,'/','On-line ANFIS'],[40,70;60,90])
add_line([sys,'/','On-line ANFIS'],[95,100;110,100])
set_param([sys,'/','On-line ANFIS'],...
		'Mask Display','plot(0, -0.3, 6, -0.3, 0, 1.2, 6, 1.2, [0 6], [0 0], [1 2 3],[0 1 0],[2 3 4],[0 1 0],[3 4 5],[0 1 0])',...
		'Mask Type','ANFIS')
set_param([sys,'/','On-line ANFIS'],...
		'Mask Dialogue','FIS|FIS Matrix:|Forgetting factor:|Step size:|Sample time:|Output FIS matrix (a string):')
set_param([sys,'/','On-line ANFIS'],...
		'Mask Translate','fismat=@1;lambda=@2;ss=@3;sample_time=@4;lambda_ss=[lambda,ss];out_fis_name=@5;',...
		'Mask Help','On-line ANFIS block',...
		'Mask Entries','fismat\/0.99\/0.01\/1\/''out_fismat''\/')


%     Finished composite block 'On-line ANFIS'.

set_param([sys,'/','On-line ANFIS'],...
		'position',[390,91,450,149])

add_block('built-in/Unit Delay',[sys,'/','Unit Delay'])
set_param([sys,'/','Unit Delay'],...
		'hide name',0,...
		'position',[195,83,220,107])

add_block('built-in/Note',[sys,'/','x(k-1)'])
set_param([sys,'/','x(k-1)'],...
		'position',[245,75,250,80])

add_block('built-in/Note',[sys,'/','x(k)'])
set_param([sys,'/','x(k)'],...
		'position',[240,95,245,100])

add_block('built-in/Note',[sys,'/','inputs'])
set_param([sys,'/','inputs'],...
		'position',[355,80,360,85])

add_block('built-in/Note',[sys,'/','desired output'])
set_param([sys,'/','desired output'],...
		'position',[325,130,330,135])


%     Subsystem  'plant'.

new_system([sys,'/','plant'])
set_param([sys,'/','plant'],'Location',[179,211,654,479])
open_system([sys,'/','plant'])

add_block('built-in/Mux',[sys,'/','plant/Mux2'])
set_param([sys,'/','plant/Mux2'],...
		'hide name',0,...
		'position',[115,35,140,75])

add_block('built-in/Outport',[sys,'/','plant/out_1'])
set_param([sys,'/','plant/out_1'],...
		'position',[445,45,465,65])

add_block('built-in/Note',[sys,'/','plant/x(k)  '])
set_param([sys,'/','plant/x(k)  '],...
		'position',[165,25,170,30])

add_block('built-in/Fcn',[sys,'/','plant/Fcn1'])
set_param([sys,'/','plant/Fcn1'],...
		'Expr','1.0819*u[2]+0.0101*u[3]-0.029*u[4]-0.009*u[1]',...
		'position',[230,15,270,35])

add_block('built-in/Fcn',[sys,'/','plant/Fcn2'])
set_param([sys,'/','plant/Fcn2'],...
		'Expr','16.4903*u[2]+1.0456*u[3]-4.2466*u[4]-2.3103*u[1]',...
		'position',[230,70,270,90])

add_block('built-in/Fcn',[sys,'/','plant/Fcn3'])
set_param([sys,'/','plant/Fcn3'],...
		'Expr','0.0513*u[2]+0.0046*u[3]+0.0619*u[4]+0.2819*u[1]',...
		'position',[230,115,270,135])

add_block('built-in/Note',[sys,'/','plant/x(k+1)'])
set_param([sys,'/','plant/x(k+1)'],...
		'position',[305,40,310,45])

add_block('built-in/Note',[sys,'/','plant/x(k) '])
set_param([sys,'/','plant/x(k) '],...
		'position',[425,15,430,20])

add_block('built-in/Unit Delay',[sys,'/','plant/Unit Delay2'])
set_param([sys,'/','plant/Unit Delay2'],...
		'hide name',0,...
		'position',[315,113,340,137])

add_block('built-in/Unit Delay',[sys,'/','plant/Unit Delay1'])
set_param([sys,'/','plant/Unit Delay1'],...
		'hide name',0,...
		'position',[320,68,345,92])

add_block('built-in/Unit Delay',[sys,'/','plant/Unit Delay'])
set_param([sys,'/','plant/Unit Delay'],...
		'hide name',0,...
		'position',[365,13,390,37])

add_block('built-in/Inport',[sys,'/','plant/in_1'])
set_param([sys,'/','plant/in_1'],...
		'position',[50,30,70,50])

add_block('built-in/Note',[sys,'/','plant/plant characteristics:'])
set_param([sys,'/','plant/plant characteristics:'],...
		'position',[255,230,260,235])
add_line([sys,'/','plant'],[395,25;440,55])
add_line([sys,'/','plant'],[75,40;110,40])
add_line([sys,'/','plant'],[410,38;410,210;70,210;85,50;110,50])
add_line([sys,'/','plant'],[145,55;180,55;225,25])
add_line([sys,'/','plant'],[275,25;360,25])
add_line([sys,'/','plant'],[275,80;315,80])
add_line([sys,'/','plant'],[275,125;310,125])
add_line([sys,'/','plant'],[350,80;390,80;390,195;85,195;90,60;110,60])
add_line([sys,'/','plant'],[345,125;365,125;365,180;100,180;110,70])
add_line([sys,'/','plant'],[145,55;180,55;180,80;225,80])
add_line([sys,'/','plant'],[145,55;180,55;180,125;225,125])


%     Finished composite block 'plant'.

set_param([sys,'/','plant'],...
		'move name',0,...
		'position',[110,70,150,120])

add_block('built-in/Mux',[sys,'/','Mux2'])
set_param([sys,'/','Mux2'],...
		'hide name',0,...
		'inputs','2',...
		'position',[280,85,305,125])


%     Subsystem  'Tunable FLC1'.

new_system([sys,'/','Tunable FLC1'])
set_param([sys,'/','Tunable FLC1'],'Location',[145,478,390,718])

add_block('built-in/Mux',[sys,'/','Tunable FLC1/Mux'])
set_param([sys,'/','Tunable FLC1/Mux'],...
		'inputs','2',...
		'position',[70,106,105,139])

add_block('built-in/S-Function',[sys,'/','Tunable FLC1/Tunable FLC'])
set_param([sys,'/','Tunable FLC1/Tunable FLC'],...
		'function name','sffis1',...
		'parameters','fismatrix',...
		'position',[135,99,190,151])

add_block('built-in/Inport',[sys,'/','Tunable FLC1/in_1'])
set_param([sys,'/','Tunable FLC1/in_1'],...
		'position',[15,105,35,125])

add_block('built-in/Outport',[sys,'/','Tunable FLC1/out_1'])
set_param([sys,'/','Tunable FLC1/out_1'],...
		'position',[230,115,250,135])

add_block('built-in/Inport',[sys,'/','Tunable FLC1/in_2'])
set_param([sys,'/','Tunable FLC1/in_2'],...
		'Port','2',...
		'position',[15,120,35,140])
add_line([sys,'/','Tunable FLC1'],[110,125;130,125])
add_line([sys,'/','Tunable FLC1'],[40,115;65,115])
add_line([sys,'/','Tunable FLC1'],[195,125;225,125])
add_line([sys,'/','Tunable FLC1'],[40,130;65,130])
set_param([sys,'/','Tunable FLC1'],...
		'Mask Display','plot(0, -0.3, 6, -0.3, 0, 1.2, 6, 1.2, [0 6], [0 0], [1 2 3],[0 1 0],[2 3 4],[0 1 0],[3 4 5],[0 1 0])',...
		'Mask Type','FIS',...
		'Mask Dialogue','FIS|FIS Matrix:')
set_param([sys,'/','Tunable FLC1'],...
		'Mask Translate','fismatrix = @1;',...
		'Mask Help','Fuzzy Inference System',...
		'Mask Entries','fismat\/')


%     Finished composite block 'Tunable FLC1'.

set_param([sys,'/','Tunable FLC1'],...
		'position',[335,217,390,268])

add_block('built-in/Note',[sys,'/',['FIS',13,'parameters']])
set_param([sys,'/',['FIS',13,'parameters']],...
		'position',[525,125,530,130])

add_block('built-in/Scope',[sys,'/','x(k) and r(k)'])
set_param([sys,'/','x(k) and r(k)'],...
		'Vgain','2.000000',...
		'Hgain','100.000000',...
		'Vmax','4.000000',...
		'Hmax','200.000000',...
		'Window',[542,194,867,533])
open_system([sys,'/','x(k) and r(k)'])
set_param([sys,'/','x(k) and r(k)'],...
		'position',[295,287,315,313])


%     Subsystem  'More Info1'.

new_system([sys,'/','More Info1'])
set_param([sys,'/','More Info1'],'Location',[128,280,487,453])
set_param([sys,'/','More Info1'],...
		'Mask Display','Initial\nSurface',...
		'Mask Dialogue','eval([''figure;gensurf(fismat);set(gca,''''box'''',''''on'''');frot3d on;'']);')


%     Finished composite block 'More Info1'.

set_param([sys,'/','More Info1'],...
		'hide name',0,...
		'Drop Shadow',4,...
		'position',[376,28,427,66])

add_block('built-in/Signal Generator',[sys,'/',['Reference',13,'input r(k)']])
set_param([sys,'/',['Reference',13,'input r(k)']],...
		'Peak','1.000000',...
		'Peak Range','5.000000',...
		'Freq','0.100000',...
		'Freq Range','0.500000',...
		'Wave','Sin',...
		'Units','Rads',...
		'position',[90,223,135,257])

add_block('built-in/Note',[sys,'/','u(k)'])
set_param([sys,'/','u(k)'],...
		'position',[85,75,90,80])

add_block('built-in/Unit Delay',[sys,'/','Unit Delay1'])
set_param([sys,'/','Unit Delay1'],...
		'hide name',0,...
		'position',[95,123,120,147])

add_block('built-in/Note',[sys,'/','u(n-1)'])
set_param([sys,'/','u(n-1)'],...
		'position',[150,130,155,135])


%     Subsystem  'More Info2'.

new_system([sys,'/','More Info2'])
set_param([sys,'/','More Info2'],'Location',[128,280,487,453])
set_param([sys,'/','More Info2'],...
		'Mask Display','Final\nSurface',...
		'Mask Dialogue','eval([''figure;gensurf(out_fismat);set(gca,''''box'''',''''on'''');frot3d on;'']);')


%     Finished composite block 'More Info2'.

set_param([sys,'/','More Info2'],...
		'hide name',0,...
		'Drop Shadow',4,...
		'position',[441,28,492,66])

add_block('built-in/Mux',[sys,'/','Mux'])
set_param([sys,'/','Mux'],...
		'hide name',0,...
		'inputs','2',...
		'position',[210,21,245,54])

add_block('built-in/Scope',[sys,'/','u(k) and x(k)'])
set_param([sys,'/','u(k) and x(k)'],...
		'Vgain','2.000000',...
		'Hgain','100.000000',...
		'Vmax','4.000000',...
		'Hmax','200.000000',...
		'Window',[358,270,687,600],...
		'position',[290,27,310,53])

add_block('built-in/Mux',[sys,'/','Mux3'])
set_param([sys,'/','Mux3'],...
		'hide name',0,...
		'inputs','2',...
		'position',[210,210,235,250])

add_block('built-in/Note',[sys,'/','r(k)'])
set_param([sys,'/','r(k)'],...
		'position',[190,240,195,245])

add_block('built-in/Constant',[sys,'/','Constant'])
set_param([sys,'/','Constant'],...
		'position',[150,295,170,315])
add_line(sys,[250,40;285,40])
add_line(sys,[155,95;190,95])
add_line(sys,[225,95;275,95])
add_line(sys,[175,95;175,115;275,115])
add_line(sys,[310,105;385,105])
add_line(sys,[175,95;175,45;205,45])
add_line(sys,[125,135;385,135])
add_line(sys,[175,115;175,220;205,220])
add_line(sys,[240,230;330,230])
add_line(sys,[455,120;490,120;490,170;310,170;310,255;330,255])
add_line(sys,[395,245;405,245;405,200;70,200;70,135;90,135])
add_line(sys,[70,135;70,95;105,95])
add_line(sys,[70,95;70,30;205,30])
add_line(sys,[265,230;265,300;290,300])
add_line(sys,[175,305;185,305;185,240;205,240])

drawnow

% Return any arguments.
if (nargin | nargout)
	% Must use feval here to access system in memory
	if (nargin > 3)
		if (flag == 0)
			eval(['[ret,x0,str,ts,xts]=',sys,'(t,x,u,flag);'])
		else
			eval(['ret =', sys,'(t,x,u,flag);'])
		end
	else
		[ret,x0,str,ts,xts] = feval(sys);
	end
else
	drawnow % Flash up the model and execute load callback
end
