import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import bsh.EvalError;
import bsh.Interpreter;

public class Mathenobita2 extends JFrame {
	//user define
	public static final double RANGE = 30; //XbkiZ
	public static final int WIDTH = 800;
	public static final int HEIGHT = 600;
	String toEvaluate;
	Interpreter interpreter = new Interpreter();
	
	private double function(double x) {
		String head = toEvaluate.substring(0,toEvaluate.lastIndexOf('x'));
		String tail = toEvaluate.substring(toEvaluate.lastIndexOf('x')+1);
		String expression = head + "(" + x + ")" + tail;
		try {
			return Double.parseDouble(interpreter.eval(expression).toString());
		} catch (NumberFormatException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (EvalError e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		//return Math.cos(x);
		return 0;
	}
	//

	private DrawPanel panel;
	private double[] x,y;
	private int width, height;
	public Mathenobita2(int width, int height) {
		this.width = width;
		this.height = height;
		x = new double[width];
		y = new double[width];
		panel = new DrawPanel(width, height);
		toEvaluate = JOptionPane.showInputDialog(null,"Please enter the function to draw");
		calculate();
		setTitle("Mathenobita");
		setBounds(50,50, width, height+30);
		setResizable(false);
		Container c = getContentPane();
		c.add(panel);
		setBackground(Color.WHITE);
		show();
	}

	private void calculate() {
		double max = Double.MIN_VALUE;
		double pivot = 0;
		double inc = RANGE/width;
		for(int i=width/2; i<width; i++) {
			x[i] = pivot;
			y[i] = function(x[i]);
			if(Math.abs(y[i]) > max) {
				max = Math.abs(y[i]);
			}
			pivot+=inc;
		}
		inc*=-1;
		pivot=inc;
		for(int i=width/2-1; i>=0; i--) {
			x[i] = pivot;
			y[i] = function(x[i]);
			if(Math.abs(y[i]) > max) {
				max = Math.abs(y[i]);
			}
			pivot+=inc;
		}
		//f(x)ӤjAyϫu
		if( max > 3*RANGE) {
			max = RANGE;
		}
		double mapping = height/(2*max);
		for(int i=0; i<width; i++) {
			y[i]=y[i]*mapping;
		}
		panel.setMaxY(max);
		panel.setXY(x,y);

	}
	
	public static void main(String[] args) {
		Mathenobita2 obj = new Mathenobita2(Mathenobita2.WIDTH,Mathenobita2.HEIGHT);
		obj.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
}
