import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.*;
import org.apache.commons.httpclient.params.HttpMethodParams;
import java.io.*;

public class TimeRetriever {

	private static final TimeRetriever instance = new TimeRetriever();

	private TimeRetriever() {}

	public static TimeRetriever getInstance() {
		return instance;
	}

	public String getTime() {
		HttpClient client = new HttpClient();
		HttpMethod method = new GetMethod("http://www.che.kuas.edu.tw/aseip_folder/time.asp");
		method.getParams().setParameter(HttpMethodParams.RETRY_HANDLER, new DefaultHttpMethodRetryHandler(3, false));

		try {
			// Execute the method.
			int statusCode = client.executeMethod(method);
			if (statusCode != HttpStatus.SC_OK) {
				System.err.println("Method failed: " + method.getStatusLine());
			}
			byte[] responseBody = method.getResponseBody();
			String content = new String(responseBody);
			int start = content.indexOf("<body>") + 6;
			int end = content.indexOf("</body>");
			content=content.substring(start, end).trim();
			return content;
		}
		catch(IOException e) {
			e.printStackTrace();
		}
		finally {
			method.releaseConnection();
		}
		return "Error";
	}

}