import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;


public class BoPoMoWriter extends FilterWriter {

	protected BoPoMoWriter(Writer writer) {
		super(writer);
	}

	public void write(int i) throws IOException {
		char c = (char) i;
		switch(c) {
		case '':
			c = '';
			break;
		case '': 
		case 'a':
		case '':
			c = 't';
			break;
		case '':
		case 'o':
			c = 'x';
			break;
		case '':
		case '':
			c = '';
			break;
		case '':
		case '':
			c = '~';
			break;
		case 'L':
		case 'o':
			c = 'y';
			break;
		case '':
			c = 'v';
			break;
		case 'O':
			c = 'z';
			break;
		case '':
			c = '}';
			break;
		case '':
			c = '';
			break;
		case '':
		case '@':
			c = '';
			break;
		}
		super.write(c);
	}
	
	@Override
	public void write(char[] buff, int off, int len) throws IOException {
		for(int i=0; i<len; i++) {
			write(buff[i+off]);
		}
	}
	
	@Override
	public void write(String str, int off, int len) throws IOException {
		for(int i=0; i<len; i++) {
			write(str.charAt(off+i));
		}
	}
}


