import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;

import javax.swing.event.MouseInputAdapter;

/*
 * Created on 2004/5/22
 *
 * EasyMove.java
 */

/**
 * @author Duncan
 *
 * EasyMove.java create at 2004/5/22 U 11:47:03
 */
public class EasyMove extends MouseInputAdapter {
	int x, y;

	public void install(Component c)
	{
		if (c == null) return;

		if (puppet != null) {
			uninstall();
		}
		puppet = c;
		puppet.addMouseListener(this);
		puppet.addMouseMotionListener(this);
	}

	public void uninstall()
	{
		if (puppet != null) {
			puppet.removeMouseListener(this);
			puppet.removeMouseMotionListener(this);
			puppet = null;
		}
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 */
	public void mouseDragged(MouseEvent e)
	{
		int dx = e.getX() - x;
		int dy = e.getY() - y;

		Point at = puppet.getLocation();
		at.translate(dx, dy);
		puppet.setLocation(at);
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(MouseEvent e)
	{
		x = e.getX();
		y = e.getY();
	}

	private Component puppet;
}
