import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EndianTranslation {

	// NInputStreamŪXӪȡAgiOutputStream
	public void writeTo(InputStream in, OutputStream out) throws IOException {
		int tmp;
		while ((tmp = in.read()) != -1) {
			out.write(tmp);
		}
	}

	// ŪɮתơAഫEndianLùW
	public void readFile(String fileName) throws IOException {
		InputStream bis = new BufferedInputStream(
				new EndianTranslationInputStream(new FileInputStream(fileName)));
		/*
		 * new FileInputStream: Ūɮ new EndianTranslationInputStream: ǴEndian
		 * new BufferedInputStream: QBuffer[tŪt
		 */
		int tmp;
		while ((tmp = bis.read()) != -1) {
			System.out.print(Integer.toHexString(tmp) + " ");
		}

		bis.close();
	}

	public static void main(String[] args) throws Exception {
		String s = "Arbalest ARX-7"; // եΦr
		String cs = "UTF-16BE"; // rsX

		EndianTranslation et = new EndianTranslation();
		InputStream in;
		byte[] b = s.getBytes(cs); // οwsXNrѽXByte array

		// LXlrꪺByte array
		System.out.println("Original String: " + s);
		System.out.println("Original byte array (" + cs + "):");
		for (int i = 0; i < b.length; i++) {
			System.out.print(Integer.toHexString(b[i] & 0xff) + " ");
		}
		System.out.println();

		// NByte arrayഫEndianXout.txt
		System.out
				.print("Byte array write to \"out.txt\" (Translate write) ... ");
		/*
		 * new ByteArrayInputStream: Byte arrayإinput stream
		 */
		in = new ByteArrayInputStream(b);

		/*
		 * NOutputStream@EndianOutputTranslationStream o˼gJɴN|۰ഫEndian
		 */
		OutputStream out = new BufferedOutputStream(
				new EndianTranslationOutputStream(new FileOutputStream(
						"out.txt")));

		/*
		 * QwrtieTo methodNInputStreamƼgOutputStream Ooڭ̪output
		 * stream[WEndianTranslationOutputStreamAҥH|ഫEndian
		 */
		et.writeTo(in, out);
		// inߺDΧstreamnclose
		in.close();
		out.close();
		System.out.println("Done!");

		/*
		 * }out.txtAṊƦLX ӲzӬO쥻Byte arrayഫL᪺G
		 */
		System.out.println("Read file \"out.txt\" (Direct read):");
		in = new BufferedInputStream(new FileInputStream("out.txt"));
		int tmp;

		while ((tmp = in.read()) != -1) {
			System.out.print(Integer.toHexString(tmp) + " ");
		}
		in.close();
		System.out.println();

		/*
		 * QreadFile method}ɩML
		 * OoreadFileInputStream[WEndianTranslationInputStream
		 * ]LXӪGOɮ׸ഫEndianG ]NOlByte arrayۦP
		 */
		System.out.println("Read file \"out.txt\" (Translate read):");
		et.readFile("out.txt");
		System.out.println();

		/*
		 * {槹HAQΥiܽsXrs边(Notepad++, Madedit...)}out.txt
		 * UTF-16LEsXAӥiHݨlrӫDýX
		 */

	}

}
