import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EndianTranslationOutputStream extends FilterOutputStream {

	private int byteUnit = 2;
	private byte[] buf;
	private int pos;

	public EndianTranslationOutputStream(OutputStream in) {
		super(in);
		buf = new byte[byteUnit];
		pos = 0;
	}

	/*
	 * giӪbytesbuf bufFNNbyteg쩳hOutputStream
	 */
	public void write(int b) throws IOException {
		buf[pos++] = (byte) (b & 0xff);
		if (pos == byteUnit) {
			while (pos > 0) {
				out.write(buf[--pos]);
			}
		}
	}

	/*
	 * oNbj餤Nb̪byteAQwrite()gUhOutputStream
	 */
	public void write(byte[] b, int off, int len) throws IOException {
		if (len % byteUnit != 0) {
			throw new IllegalArgumentException("Write length % byteUnit != 0");
		}

		while (len-- > 0) {
			write(b[off++]);
		}
	}
}
