#ifndef __IO_H
#define __IO_H

#include "algebra3.h"

#define MAX_FRAME 1024

// A convenient function to convert numbers between 0 and 1 to colors.
void colorBar(float f, unsigned char* RGB);

vec3 dominantAxis(vec3 v);

class Camera {
  public:
    vec3 COP;      // center of projection
    vec3 a, b, c;  // Vectors a, b, c as in McMillan's paper

    void fromArray(float* arr);
    void toArray(float* arr);
    void toMat3(mat3& P) const;
    void fromLookAt(vec3 eye, vec3 lookat, vec3 up, float fovY,
                    int width, int height);
    void toLookAt(vec3& eye, vec3& lookat, vec3& up, float& fovY,
                  int width, int height);
    void dump();
    Camera interpolate(Camera cam2, float t);
};

class DepthImage {
    unsigned char*   color;
    unsigned char*   connectivity;
    float*           disparity;
    float*           normal;
  public:
	// I was lazy, so I made the following public.
    int              width, height;
    Camera           camera;

    DepthImage();
    ~DepthImage();
	void		   saveRawFile(char* fname);
	void		   loadRawFile(char* fname);
    void           closeFile();
    unsigned char* getColor(int x, int y) const;
    float*         getNormal(int x, int y) const;
    float          getDisparity(int x, int y) const;
    void           setDisparity(int x, int y, float disp);
    void           generateNormals();
    vec3           location_R3(int x, int y, float xOffset=0, float yOffset=0) const;
};

class FrameBuffer {
    unsigned char* color;
    float*         Z;
  public:
    int            width, height;

    FrameBuffer();
    ~FrameBuffer();
    void           setSize(int width, int height, int noZ=0);
    void           writeColor(int x, int y, unsigned char* RGB);
    unsigned char* readColor(int x, int y);
    void           writeZ(int x, int y, float z);
    float          readZ(int x, int y);
    int            inside(int x, int y);
    void           flipY();
    void           from(const DepthImage& im);
    void           from(unsigned char* rgb, int w, int h);
    //void           displayTIFF(char* fname);
    void           display();
};

#endif
