/*****************************************************************************
*	room.h
*
*	The TQuad type and the information about roomPolys[] in room.c 
*   are moved to this header file to make them available to rad.c and
*   draw.c, so that the elements may be "glued" back together in order
*   to reconstruct the vertice colors.
*
*	4/2002 Chun-Fa Chang	
******************************************************************************/

#ifndef __ROOM__
#define __ROOM__

/* a quadrilateral */
typedef struct {
	short verts[4];	/* vertices of the quadrilateral */
	short patchLevel; /* patch subdivision level (how fine to subdivide the quadrilateral?) */
	short elementLevel; /* element subdivision level (how fine to subdivide a patch?) */
	float area; /* area of the quadrilateral */
	TVector3f normal; /* normal of the quadrilateral */
	TSpectra* reflectance; /* diffuse reflectance of the quadrilateral */
	TSpectra* emission; /* emission of the quadrilateral */
} TQuad;

#define numberOfPolys 	18
extern TQuad roomPolys[numberOfPolys];

#endif