
function [x,y] = muller(fun, x1, x2, tol, kmax)
% Muller's method for solving nonlinear equation.
% This code is copied from LVF textbook.
% Input
%    fun : function to be solved.
%    x1, x2 : initial interval
%    tol : tolerable error 
%    kmax : maximum number of iterations
% Output
%    x : history of x
%    y : history of f(x)
%

% find three points and their function values
  x(1) = x1;
  x(2) = x2;
  x(3) = (x1+x2)/2;
  y(1) = feval(fun, x1);
  y(2) = feval(fun, x2);
  y(3) = feval(fun, x(3));

% c1, c2, d1 and s are auxiliary variables for generating x_{k+1}
  c(1) = (y(1)-y(3))/(x(1)-x(3));
  for k = 3:kmax
    c(k-1) = (y(k-1)-y(k))/(x(k-1)-x(k));
    d(k-2) = (c(k-2)-c(k-1))/(x(k-2)-x(k-1));
    s = c(k-1)+(x(k)-x(k-1))*d(k-2);
    x(k+1) = x(k)-2*y(k)/(s+sign(s)*sqrt(s^2-4*y(k)*d(k-2)));
    y(k+1) = feval(fun, x(k+1));
    if (abs(x(k+1)-x(k))) < tol
      disp('Muller method has converged');
      return;
    end
  end
  disp('Zero not found to desired tolerance');  
endfunction
