
//////////////////////////////////////////////////////////////////////////
// Timing Parameters Define
//////////////////////////////////////////////////////////////////////////
specify
  `ifdef clk_100
    specparam tclk_min  = 10;           // Clock Period
    specparam tch_min   = 3;            // Clock High Time
    specparam tcl_min   = 3;            // Clock Low Time
    specparam tsi_min   = 2;            // Input Setup Times DQM#/CS#
    specparam thi_min   = 1;            // Input Hold Times DQM#/CS#
    specparam tohz_max  = 9;            // Output Valid To Z max
    specparam tsrx_min  = 1*tclk_min;   // Self Refresh Exit Time
  `else
    specparam tclk_min  = 15;           // Clock Period
    specparam tch_min   = 5;            // Clock High Time
    specparam tcl_min   = 5;            // Clock Low Time
    specparam tsi_min   = 3;            // Input Setup Times DQM#/CS#
    specparam thi_min   = 1.5;          // Input Hold Times DQM#/CS#
   specparam tohz_max  = 12;           // Output Valid To Z max
    specparam tsrx_min  = 10*tclk_min;  // Self Refresh Exit Time
  `endif

  // SPD option
  `ifdef SPD
    specparam trp_min   = 2*tclk_min;   // RAS Precharge Time
    specparam trc_min   = 7*tclk_min;   // RAS Cycle Time
    specparam trcd_min  = 2*tclk_min;   // Activate to Command Delay Time
  `else
    specparam trp_min   = 3*tclk_min;   // RAS Precharge Time
    specparam trc_min   = 8*tclk_min;   // RAS Cycle Time
    `ifdef clk_100
      specparam trcd_min= 3*tclk_min;   // Activate to Command Delay Time
    `else
      specparam trcd_min= 2*tclk_min;   // Activate to Command Delay Time
    `endif
  `endif

  // Common Timing Parameters
  specparam tac_max     = 6;            // Output Valid From Clock  
  specparam toh_min     = 3;            // Output Hold From Clock
  specparam tohz_min    = 3;            // Output Valid To Z min
  specparam tccd_min    = 1*tclk_min;   // CAS to CAS Delay
  specparam tcbd_min    = 1*tclk_min;   // CAS Bank Delay
  specparam tcke_min    = 1*tclk_min;   // CKE to Clock Disable
  specparam tras_min    = 5*tclk_min;   // RAS Active Time
  specparam trrd_min    = 2*tclk_min;   // RAS to RAS Bank Activate Delay
  specparam tdqd_min    = 0*tclk_min;   // DQM to Input Data Delay
  specparam tdwd_min    = 0*tclk_min;   // Write Cmd. to Input Data Delay
  specparam tmrd_min    = 3*tclk_min;   // Mode Register set to Active delay
  specparam tdqz_min    = 2*tclk_min;   // DQM to Data in HiZ for read
  specparam tdqm_min    = 0*tclk_min;   // DQM to Data Mask for write
  specparam tdpl_min    = 1*tclk_min;   // Data-in to PRE Command Period
  specparam tdal_min    = 4*tclk_min;   // Data-in to ACT Command Period
  specparam tsb_max     = 1*tclk_min;   // Power Down Mode Entry
  specparam tpde_min    = 1*tclk_min;   // Power Down Exit Setup Time
  specparam tclkstp_min = 200*tclk_min; // Clock Stop During Self Refresh
  specparam tref_min    = 15600;        // Refresh rate/row
endspecify
//////////////////////////////////////////////////////////////////////////
// End of Timing Parameters Define
////////////////////////////////////////////////////////////////////////// 

