//
// File: main2.v
// Author:  Vincent H.-J. Chiou
// Date: 10/21/98
// Version:
// Abstract: main prograam
//
// Modification History:
// Date     By      Version  Change Description
// --------------------------------------------
// 10/20/98  v       1.0      original
// 11/02/98          3.0
// 11/25/98          6.0      modify aq_sel and output_con

module SDRAM_CON(clk,      // clock
                 rst_n,      // reset
                 request,  // request for sent 
                 we_n_p,     // write enable
                 addr_p,     // addr from processor
                 data_p_i,     // data from processor
                 data_p_o,
                 
                 oen,
                 vaild,
                 ready_s,
                 cke_s,
                 cs_n_s,
                 ras_n_s,
                 cas_n_s,
                 we_n_s,
                 dqm_s,
                 bs_s,
                 addr_bits_s,
                 dq_s_i,
                 dq_s_o,
                 se,
                 sin,
                 sout);
                 
  parameter ADDR_BIT_WIDTH=`BS_WIDTH+`ROW_WIDTH+`COL_WIDTH;
  parameter ADDR_WIDTH=`BS_WIDTH+`ROW_WIDTH+`COL_WIDTH;
  input se;
  input sin;
  
  input clk;
  input rst_n;
  input request;
  input we_n_p;
  input [ADDR_WIDTH-1:0] addr_p;
  
  input [`BANDWIDTH-1:0] data_p_i;
  output [`BANDWIDTH-1:0] data_p_o;
  output oen;
  output vaild;
  output ready_s;
  output cke_s;
  output cs_n_s;
  output ras_n_s;
  output cas_n_s;
  output we_n_s;
  output dqm_s;
  output [`BS_WIDTH-1:0] bs_s;
  output [`ROW_WIDTH-1:0] addr_bits_s;
  output sout;
  input  [`DATA_WIDTH-1:0] dq_s_i;
  output [`DATA_WIDTH-1:0] dq_s_o;
  
  wire vaild;
  wire ready_s;
  wire cke_s;
  wire cs_n_s;
  wire ras_n_s;
  wire cas_n_s;
  wire we_n_s;
  wire [`BS_WIDTH-1:0] bs_s;
  wire [`ROW_WIDTH-1:0] addr_bits_s;
  
  
  wire [`BANDWIDTH-1:0] data_p_i;
  wire [`DATA_WIDTH-1:0] dq_s_i;
  wire [`BANDWIDTH-1:0] data_p_o;
  wire [`DATA_WIDTH-1:0] dq_s_o;
  
  /************** local variable *************************/
  
  wire ready;
  wire qs;
  wire [`Q_BIT_WIDTH-1:0] q_row,
                          d_row,
                          o_row;

  wire q_we_n,
       d_we_n,
       o_we_n;
  
  wire en_1_n,
       en_2_n,
       d_en_d_n,
       o_en_n;
  wire [`BANDWIDTH-1:0] b1_data_out_2,
                        b2_data_out_2,
                        b1_data_out_3,
                        b2_data_out_3,
                        m_data,
                        a_data,
                        o_data;
  wire start;
  wire [ADDR_BIT_WIDTH:0] b1_reg_0,
                          b1_reg_1,
                          b1_reg_2,
                          b1_reg_3;
  wire [ADDR_BIT_WIDTH:0] b2_reg_0,
                          b2_reg_1,
                          b2_reg_2,
                          b2_reg_3;
  wire [ADDR_BIT_WIDTH:0] reg_0,
                          reg_1,
                          reg_2,
                          reg_3;
  wire b1_notempty,b2_notempty,notempty;
  wire [`Q_BIT_WIDTH:0] b1_mode,b2_mode;//,mode_reg;
  wire m1b1_en_n,m1b2_en_n,m2b1_en_n,m2b2_en_n,m3b1_en_n,m3b2_en_n; 
   
  assign ready_s=ready;
  assign oen=~we_n_p;
                         
  INPUT_C input_c(.clk(clk),      // clock
                  .rst_n(rst_n),      // reset
                  .ready(ready),    // ready to receive
                  .we_n(we_n_p),     // write enable
               
                  .qs(qs),       // queue select
                  .q_row(q_row),    // queue index
                  .we_d_n(q_we_n),   // queue data write enable
                  .en_a1_n(en_a1_n),   // address queue enable 
                  .en_a2_n(en_a2_n));  // data to queue
  
  QS_SWITCH qs_sw(.qs1(o_qs),
                  .qs2(o2_qs),
                  .qs_switch(qs_switch),
                  .sqs(sqs));
                  
  ABRITRATE abritate(.m1_qs(qs),
                     .m1_en_n(q_we_n), // signal from INPUT_C
                 
                     .m2_qs_n(o2_qs),
                     .m2_en_n(d_en_d_n), // signal from DATA2PRO
                 
                     .m3_qs(sqs),
                     .m3_en_n(o_en_n), // signal from OUTPUT_CON
                 
                     .m1b1_en_n(m1b1_en_n),
                     .m1b2_en_n(m1b2_en_n),
                     .m2b1_en_n(m2b1_en_n),
                     .m2b2_en_n(m2b2_en_n),
                     .m3b1_en_n(m3b1_en_n),
                     .m3b2_en_n(m3b2_en_n));
                
             
                                 
  ADDR_MEM addr_mem_b1(.clk(clk),          // clk
                       .en_n(en_a1_n),         // address mem enable
                       .q_row(q_row),        // queue index
                       .q_addr({we_n_p,addr_p}),       // address info to store
                
                       .start(start),        // ready to output
                       .mode(b1_mode),
                       .reg_out_0(b1_reg_0),
                       .reg_out_1(b1_reg_1),
                       .reg_out_2(b1_reg_2),
                       .reg_out_3(b1_reg_3));   
                       
  ADDR_MEM addr_mem_b2(.clk(clk),          // clk
                       .en_n(en_a2_n),         // address mem enable
                       .q_row(q_row),        // queue index
                       .q_addr({we_n_p,addr_p}),       // address info to store
                
                       .start(),        // ready to output
                       .mode(b2_mode),
                       .reg_out_0(b2_reg_0),
                       .reg_out_1(b2_reg_1),
                       .reg_out_2(b2_reg_2),
                       .reg_out_3(b2_reg_3)); 
   
  
              
  START_REG start_reg(.start_in(start),  // from ADDR_MEM start
                      .start_out(start_out));  
                      
                    
  BANK bank_b1(.clk(clk),     

               .en_n_1(m1b1_en_n),      // access enable
               .we_n_1(m1b1_en_n),      // write enable
               .row_1(q_row),       // row address
               .data_in_1(data_p_i),   // data write to data mem
               
            
               .en_n_2(m2b1_en_n),      // access enable
               .we_n_2(d_we_n),      // write enable
               .row_2(d_row),       // row address
               .data_out_2(b1_data_out_2),   // data write to data mem
            
               .en_n_3(m3b1_en_n),      // access enable
               .we_n_3(o_we_n),      // write enable
               .row_3(o_row),       // row address
               .data_in_3(o_data),   // data write to data mem            
               .data_out_3(b1_data_out_3)); // data read from data mem
                                                   
                                        
  BANK bank_b2(.clk(clk),     

               .en_n_1(m1b2_en_n),      // access enable
               .we_n_1(m1b2_en_n),      // write enable
               .row_1(q_row),       // row address
               .data_in_1(data_p_i),   // data write to data mem
               
            
               .en_n_2(m2b2_en_n),      // access enable
               .we_n_2(d_we_n),      // write enable
               .row_2(d_row),       // row address
               .data_out_2(b2_data_out_2),   // data write to data mem
            
               .en_n_3(m3b2_en_n),      // access enable
               .we_n_3(o_we_n),      // write enable
               .row_3(o_row),       // row address
               .data_in_3(o_data),   // data write to data mem          
                
               .data_out_3(b2_data_out_3)); // data read from data mem
                                                   
               
                       
  DATA2PRO data_2pro(.clk(clk),
                     .rst_n(rst_n),
                     .qs(o2_qs),
                     .notempty(notempty),   // data queue not empty
                     .data_in(m_data),    // data from data mem
                     .vaild(vaild),
                     .row(d_row),        // row addr of data mem
                     .we_n(d_we_n),       // data mem write enable
                     .en_d_n(d_en_d_n),     // data mem access enable
                     .data_out(data_p_o));  // data out to processor
  
                
  MUX1 mux1(.qs(o2_qs),
            .b1_notempty(b1_notempty),
            .b2_notempty(b2_notempty),
            .notempty(notempty)); 
            
  MUX2 mux2(.qs(o2_qs),
            .b1_data(b1_data_out_2),
            .b2_data(b2_data_out_2),
            
            .data_r(m_data));
            
  OUT_CON out_con(.clk(clk),        // clock
                  .rst_n(rst_n),        // reset
                  .start(start_out),      // start to output
                  .request(request),    // request for input 
                  .qs(qs),         // queue select from input control
                  .reg_0(reg_0),      // address info from queue
                  .reg_1(reg_1),
                  .reg_2(reg_2),
                  .reg_3(reg_3),
                  .data_in(a_data),    // data from data mem
                  .dq_in(dq_s_i),      // data from SDRAM
                  .mode_reg0(b1_mode),
                  .mode_reg1(b2_mode),
                  .ready(ready),      // ready to receive 
               
                  .cke(cke_s),        // clock enable
                  .cs_n(cs_n_s),       // chip select
                  .ras_n(ras_n_s),      // ras 
                  .cas_n(cas_n_s),      // cas
                  .we_n(we_n_s),       // write enable
                  .bs(bs_s),         // bank select
                  .dqm(dqm_s),        // dqm               
                  .addr_bits(addr_bits_s),  // address bits to SDRAM    
                  .dq_out(dq_s_o),     // data output to SDRAM
               
                  .o_qs(o_qs),       // from ic[`Q_BIT_WIDTH] 
                  .o2_qs(o2_qs),
                  .qs_switch(qs_switch),
                  .q_we_n(o_we_n),     // data mem write enablle
                  .en_d_n(o_en_n),     // data mem enable
                  .row(o_row),        // data mem row address
                  .data_out(o_data),  // data output to data mem 
                  
                  .se(se),
                  .sin(sin),
                  .sout(sout));  
  
                  
                
  AQ_SEL aq_sel(.qs(o_qs),  // from OUT_CON ic[`Q_BIT_WIDTH]
                .b1_reg_0(b1_reg_0),   // address info from queue 1
                .b1_reg_1(b1_reg_1),
                .b1_reg_2(b1_reg_2),
                .b1_reg_3(b1_reg_3),
            //    .b1_mode(b1_mode),
                .b1_data(b1_data_out_3),
              
                .b2_reg_0(b2_reg_0),   // address info from queue 2
                .b2_reg_1(b2_reg_1),
                .b2_reg_2(b2_reg_2),
                .b2_reg_3(b2_reg_3),
            //    .b2_mode(b2_mode),
                .b2_data(b2_data_out_3),
              
                .reg_0(reg_0),   
                .reg_1(reg_1),
                .reg_2(reg_2),
                .reg_3(reg_3),
            //    .mode_reg(mode_reg),
                .data_r(a_data)); 
                
  NOT_EMPTY not_empty(.clk(clk),
                      .rst_n(rst_n),
                      .qs(o2_qs),  //from OUT_CON out_count[`QBIT_WIDTH]
                      .q_we_n(o_we_n),
                      .en_d_n(o_en_n),
                      .b1_notempty(b1_notempty),
                      .b2_notempty(b2_notempty));  
                      
endmodule
           
