//
// File: data2pro.v
// Author:  Vincent H.-J. Chiou
// Date: 10/13/98
// Version:
// Abstract: data to processor control
//
// Modification History:
// Date     By      Version  Change Description
// --------------------------------------------
// 10/13/98  v               original
// 11/02/98  v               change positive trigger to negative trigger

module MUX1(qs,
           b1_notempty,
           b2_notempty,
           notempty); 
  input qs;
  input b1_notempty;
  input b2_notempty;
  output notempty;
  reg notempty;
  
  always @(qs or b1_notempty or b2_notempty)
    begin
      case (qs)
        0:
          begin
            notempty=b2_notempty;
          end
        1:
          begin
            notempty=b1_notempty;
          end
      endcase
    end
endmodule

module MUX2(qs,
            b1_data,
            b2_data,
            
            data_r);
  input qs;
  input [`BANDWIDTH-1:0] b1_data;
  input [`BANDWIDTH-1:0] b2_data;
  
  output [`BANDWIDTH-1:0] data_r;
  reg [`BANDWIDTH-1:0] data_r;
  
  always @(qs or b1_data or b2_data)
    begin
      case (qs)
        0:
          begin
            data_r=b2_data;
          end
        1:
          begin
            data_r=b1_data;
          end
      endcase
    end
endmodule

  

module DATA2PRO(clk,
                rst_n,
                qs,         // from output_con o2_qs
                notempty,   // data queue not empty
                data_in,    // data from data mem
                
                vaild,      // data is vaild on data bus
                row,        // row addr of data mem
                we_n,       // data mem write enable
                en_d_n,     // data mem access enable
                data_out);  // data out to processor
  parameter  S0=0,S1=1;
               
  input clk;
  input rst_n;
  input notempty;
  input qs;
  input [`BANDWIDTH-1:0] data_in;
  
  output vaild;
  output [`Q_BIT_WIDTH-1:0] row;
  output we_n;
  output en_d_n;
  output [`BANDWIDTH-1:0] data_out;
  
  reg vaild;
  reg [`Q_BIT_WIDTH-1:0] row;
  reg we_n;
  reg en_d_n;
  reg [`BANDWIDTH-1:0] data_out;

  /******** local variable ******************************/
  reg state_reg;
  reg [`Q_BIT_WIDTH:0] ic;
  reg ready_out;
  reg go;
  reg pre_qs;
  wire rst;
  
  assign rst=~rst_n;
  always @(data_in or vaild)
    if (vaild) data_out=data_in;
    else data_out='hz;
    
  always @(negedge clk or negedge rst_n)
    begin
      if (!rst_n)
        begin
          vaild=0;
        end
      else
        if (ready_out)
          begin
         //   data_out=data_in;
            vaild=1;
          end
        else
          begin
      //    data_out='hz;
            vaild=0;
          end
      end
    
    
  always @(qs or pre_qs)
    go=pre_qs^qs;
    
    
  always @(posedge clk or posedge rst)
    begin
      if (rst)
        begin
          pre_qs=0;
          ready_out=0;
          en_d_n=1;
          state_reg=S0;
        end
      else
        begin
          case (state_reg)
            S0:
              begin
                if (go)
                  begin
                    ic=~0;
                    state_reg=S1;
                  end
                else
                  begin
                    state_reg=S0;
                  end
              end
              
            S1:
              begin
                pre_qs=qs;
                if (notempty)
                  begin
                    ic=ic+1;
                    row=ic;
                    we_n=1;  // read
                    en_d_n=0; 
                    ready_out=1;
                    if (ic[`Q_BIT_WIDTH]) 
                      begin
                        en_d_n=1;
                        ready_out=0;
                        state_reg=S0;
                      end
                    else state_reg=S1;                  
                  end
                else
                  begin
                    en_d_n=1;
                    ready_out=0;
                    state_reg=S0;
                  end
               
              end
          endcase
        end
    end
endmodule
