//
// File: addr_con.v
// Author:  Vincent H.-J. Chiou
// Date:  10/29/98
// Version: 1.0
// Abstract: store and reorder commands
//
// Modification History:
// Date     By      Version  Change Description
// --------------------------------------------
// 10/29/98 vincent 1.0      original



module START_REG(start_in,  // from ADDR_MEM start
                 start_out);

  input start_in;
  output start_out;
  wire start_out;
  
  assign start_out=start_out|start_in;
  /*always @(start_in or start_out)
    start_out=start_out|start_in;*/
endmodule
                          

module ADDR_MEM(clk,          // clk
                en_n,         // address mem enable
                q_row,        // queue index
                q_addr,       // address info to store
                
                start,         // ready to output
                mode,         // conflict mode register
                reg_out_0,
                reg_out_1,
                reg_out_2,
                reg_out_3);
  parameter ADDR_BIT_WIDTH=`BS_WIDTH+`ROW_WIDTH+`COL_WIDTH;
  parameter COL_MAX=4;
  parameter BANK_MASK=25'b0_11_000000000000_0000000000;
  parameter ROW_MASK=25'b0_00_111111111111_0000000000;

  
  input clk;

  input [`Q_BIT_WIDTH-1:0] q_row;
  input en_n;
  input [ADDR_BIT_WIDTH:0] q_addr; //we_n,bs,row,col,q_row
  
  output start;
  output [`BS_WIDTH:0] mode;
  output [ADDR_BIT_WIDTH:0] reg_out_0;
  output [ADDR_BIT_WIDTH:0] reg_out_1;
  output [ADDR_BIT_WIDTH:0] reg_out_2;
  output [ADDR_BIT_WIDTH:0] reg_out_3;
  

  reg start;
  reg [`BS_WIDTH:0] mode;
  wire [ADDR_BIT_WIDTH:0] reg_out_0;
  wire [ADDR_BIT_WIDTH:0] reg_out_1;
  wire [ADDR_BIT_WIDTH:0] reg_out_2;
  wire [ADDR_BIT_WIDTH:0] reg_out_3;
  
  reg [ADDR_BIT_WIDTH:0] register [COL_MAX-1:0];

  
  


  always @(negedge clk ) 
    begin  /* store command */
      if (!en_n) 
        begin
          register[q_row]=q_addr;
        end
    end
    
  always @(register[0] or register[1] or register[2] or register[3] )
    begin
      if ((register[0]&BANK_MASK)!=(register[1]&BANK_MASK))
        mode[0]=0;
      else 
        if ((register[0]&ROW_MASK)==(register[1]&ROW_MASK))
          mode[0]=0;
        else mode[0]=1;

      if ((register[1]&BANK_MASK)!=(register[2]&BANK_MASK))
        mode[1]=0;
      else 
        if ((register[1]&ROW_MASK)==(register[2]&ROW_MASK))
          mode[1]=0;
        else mode[1]=1;
              
      if ((register[2]&BANK_MASK)!=(register[3]&BANK_MASK))
        mode[2]=0;
      else 
        if ((register[2]&ROW_MASK)==(register[3]&ROW_MASK))
          mode[2]=0;
        else mode[2]=1;
     end
   
  always @(en_n or q_row)
    begin
      if (!en_n & q_row) start=1;
      else start=0;
    end  

/*  
  always @(register[0] or register[1] or register[2] or register[3] )
    begin
      case ({en_n,q_row})
        3'b001:
          begin
            if ((register[0]&BANK_MASK)!=(register[1]&BANK_MASK))
              mode[0]=0;
            else 
              if ((register[0]&ROW_MASK)==(register[1]&ROW_MASK))
                mode[0]=0;
              else mode[0]=1;
            start=0;
          end
        3'b010:
          begin
            if ((register[1]&BANK_MASK)!=(register[2]&BANK_MASK))
              mode[1]=0;
            else 
              if ((register[1]&ROW_MASK)==(register[2]&ROW_MASK))
                mode[1]=0;
              else mode[1]=1;
            start=0;
          end
        3'b011:
          begin
            if ((register[2]&BANK_MASK)!=(register[3]&BANK_MASK))
              mode[2]=0;
            else 
              if ((register[2]&ROW_MASK)==(register[3]&ROW_MASK))
                mode[2]=0;
              else mode[2]=1;
            start=1;
          end
        default:
          begin
            start=0;
          end
      endcase
      
    end
  
*/  
  assign reg_out_0=register[0];
  assign reg_out_1=register[1];
  assign reg_out_2=register[2];
  assign reg_out_3=register[3];
  

endmodule

