/*
 *  Description: Video Engine Top Level
 *
 *  Designer : Stewart G. Smith
 *  Company  : VLSI Vision Ltd.
 *  Module   : vpe653a
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
 * 05-JUN-97:  Update and expand dmcode
 * 06-JUN-97:  Introduce bypass mode and yuvnot
 * 06-JUN-97:  Introduce colctrl module, use f_int as run control
 * 09-JUN-97:  12-bit [rgb ]acci from m-mon to colctrl
 * 25-AUG-97:  acbs wired to main.rcoffs (PL)
*/

module vpe653a(
  vjog, 
  vp_clk, 
  qcif, 
  hz30, 
  evenfirst, 
  self_timing,
  ycof22, 
  ycof21, 
  ycof20, 
  ycof12, 
  ycof11, 
  ycof10, 
  ycof02, 
  ycof01,
  ycof00, 
  rcof22, 
  rcof21, 
  rcof20, 
  rcof12, 
  rcof11, 
  rcof10, 
  rcof02,
  rcof01, 
  rcof00, 
  gamcor, 
  apthresh, 
  apcor, 
  zcode3, 
  zcode2, 
  zcode1,
  zcode0, 
  accscale, 
  ve_end_of_frame, 
  thresh, 
  exp_acc, 
  racc, 
  gacc,
  bacc, 
  vo, 
  fclk, 
  lacc7, 
  lacc6, 
  lacc5, 
  lacc4, 
  lacc3, 
  lacc2,
  lacc1, 
  lacc0, 
  black_acc, 
  hjog, 
  rx_do, 
  offset, 
  rcomp, 
  g2comp,
  g1comp, 
  bcomp, 
  filtercode, 
  correct, 
  defcor, 
  color_bars, 
  rx_DATA_IMMINENT,
  data_valid, 
  rx_VP_PCLK, 
  resetb, 
  linespace, 
  rx_ld, 
  rxlcnt, 
  skip,
  zoom, 
  vp_dmcode,
  f_int, 
  fst,
  lst,
  odd,
  yuvnot,
  acb_gnbase,
  acb_mu,
  acb_remote,
  acb_freeze,
  acb_pregain,
  acb22, 
  acb21, 
  acb20, 
  acb12, 
  acb11, 
  acb10, 
  acb02,
  acb01, 
  acb00 
);

  input        vjog;
  input        vp_clk;
  input        qcif;
  input        hz30;
  input        evenfirst;
  input        self_timing;
  input  [7:0] ycof22;
  input  [7:0] ycof21;
  input  [7:0] ycof20;
  input  [7:0] ycof12;
  input  [7:0] ycof11;
  input  [7:0] ycof10;
  input  [7:0] ycof02;
  input  [7:0] ycof01;
  input  [7:0] ycof00;
  input  [7:0] rcof22;
  input  [7:0] rcof21;
  input  [7:0] rcof20;
  input  [7:0] rcof12;
  input  [7:0] rcof11;
  input  [7:0] rcof10;
  input  [7:0] rcof02;
  input  [7:0] rcof01;
  input  [7:0] rcof00;
  input  [3:0] gamcor;
  input  [3:0] apthresh;
  input  [3:0] apcor;
  input  [7:0] zcode3;
  input  [7:0] zcode2;
  input  [7:0] zcode1;
  input  [7:0] zcode0;
  input  [2:0] accscale;

  output       ve_end_of_frame;

  input  [7:0] thresh;

  output [7:0] exp_acc;
  output [7:0] racc;
  output [7:0] gacc;
  output [7:0] bacc;
  output [7:0] vo;

  output       fclk;

  output [7:0] lacc7;
  output [7:0] lacc6;
  output [7:0] lacc5;
  output [7:0] lacc4;
  output [7:0] lacc3;
  output [7:0] lacc2;
  output [7:0] lacc1;
  output [7:0] lacc0;
  output [7:0] black_acc;

  input        hjog;

  input  [7:0] rx_do;
  input  [7:0] offset;
  input  [7:0] rcomp;
  input  [7:0] g2comp;
  input  [7:0] g1comp;
  input  [7:0] bcomp;

  input  [1:0] filtercode;

  input        correct;

  input  [4:0] defcor;

  input        color_bars;
  input        rx_DATA_IMMINENT;
  input        data_valid;
  input        rx_VP_PCLK;
  input        resetb;

  input  [3:0] linespace;

  input  [2:0] rx_ld;

  input  [8:0] rxlcnt;

  input        skip;
  input        zoom;
  
  input  [7:0] vp_dmcode;

  output       f_int;
  output       fst;
  output       lst;
  input        odd;
  input        yuvnot;

  input  [3:0] acb_gnbase;
  input  [7:0] acb_mu;
  input        acb_remote;
  input        acb_freeze;
  input        acb_pregain;

  output [7:0] acb22;
  output [7:0] acb21;
  output [7:0] acb20;
  output [7:0] acb12;
  output [7:0] acb11;
  output [7:0] acb10;
  output [7:0] acb02;
  output [7:0] acb01;
  output [7:0] acb00;

  wire  [8:0] ag_baraddr;
  wire  [8:0] ag_addr1;
  wire  [8:0] ad_addr0;
  wire  [8:0] ag_olcnt;
  wire  [7:0] rc_o0;
  wire  [7:0] rc_o1;
  wire  [7:0] rc_o2;
  wire  [7:0] rams_o0;
  wire  [7:0] rams_o1;
  wire  [7:0] rams_o2;
  wire  [7:0] rams_o3;
  wire  [7:0] rc_o3;
  wire  [7:0] ip_out;

  wire  [11:0] racci;
  wire  [11:0] gacci;
  wire  [11:0] bacci;

  supply1 VDD;
  supply0 VSS;

  wire ugo1st = vp_dmcode[0];
  wire edg656 = vp_dmcode[1];
  wire stndrd = vp_dmcode[2];
  wire vsolid = vp_dmcode[3];
  wire frerun = vp_dmcode[4];
  wire intpix = vp_dmcode[5];
  wire fldid = vp_dmcode[6] & odd;
  wire bypass = vp_dmcode[7];

  wire [7:0] racc = racci[11:4];
  wire [7:0] gacc = gacci[11:4];
  wire [7:0] bacc = bacci[11:4];


  main      ma (
                .apcor(apcor[3:0]), 
                .vp_clk(vp_clk), 
                .gamcorreg(gamcor[3:0]), 
                .gseflag(ag_gseflag), 
                .lin0(rc_o0[7:0]),
                .lin1(rc_o1[7:0]), 
                .lin2(rc_o2[7:0]), 
                .lin3(rc_o3[7:0]), 
                .oenv(ag_oenv), 
                .rx_VP_PCLK(rx_VP_PCLK), 
                .rcof00(acb00[7:0]),
                .rcof01(acb01[7:0]), 
                .rcof02(acb02[7:0]), 
                .rcof10(acb10[7:0]), 
                .rcof11(acb11[7:0]), 
                .rcof12(acb12[7:0]),
                .rcof20(acb20[7:0]), 
                .rcof21(acb21[7:0]), 
                .rcof22(acb22[7:0]), 
                .resetb(resetb), 
                .rsflag(ag_rsflag),
                .ycof00(ycof00[7:0]), 
                .ycof01(ycof01[7:0]), 
                .ycof02(ycof02[7:0]), 
                .ycof10(ycof10[7:0]), 
                .ycof11(ycof11[7:0]),
                .ycof12(ycof12[7:0]), 
                .ycof20(ycof20[7:0]), 
                .ycof21(ycof21[7:0]), 
                .ycof22(ycof22[7:0]), 
                .vo(vo[7:0]),
                .menv(ag_menv), 
                .fclk(fclk), 
                .vlenv(ag_vlenv), 
                .accscale(accscale[2:0]), 
                .thresh(thresh[7:0]),
                .zonecode0(zcode0[7:0]), 
                .zonecode1(zcode1[7:0]), 
                .zonecode2(zcode2[7:0]), 
                .zonecode3(zcode3[7:0]),
                .expacc(exp_acc[7:0]), 
                .bacci(bacci[11:0]), 
                .gacci(gacci[11:0]), 
                .racci(racci[11:0]), 
                .apthresh(apthresh[3:0]),
                .ve_end_of_frame(ve_end_of_frame), 
                .sof(start_of_frame), 
                .intskip(ag_intskip), 
                .intqcif(ag_intqcif), 
                .intzoom(ag_intzoom),
                .f_int(f_int), 
                .flenv(flenv), 
                .llenv(llenv), 
                .eofe(ma_eofe), 
                .olcnt(ag_olcnt[8:0]), 
                .ugo1st(ugo1st),
                .edg656(edg656),
                .stndrd(stndrd),
                .vsolid(vsolid),
                .frerun(frerun),
                .intpix(intpix),
                .fldid(fldid),
                .bypass(bypass),
                .yuvnot(yuvnot),
                .remote(acb_remote),
                .qlinekill(ag_qlinekill)
               );

  inproc    ip (
                .baraddr(ag_baraddr[8:0]), 
                .barsrq(color_bars), 
                .bcomp(bcomp[7:0]), 
                .defcor(defcor[4:0]),
                .filtercode(filtercode[1:0]), 
                .correct(correct), 
                .rx_DATA_IMMINENT(rx_DATA_IMMINENT), 
                .data_valid(data_valid), 
                .eof(ma_eofe),
                .evenfirst(evenfirst), 
                .g1comp(g1comp[7:0]), 
                .g2comp(g2comp[7:0]), 
                .hjog(hjog), 
                .ienv(ag_ienv),
                .intqcif(ag_intqcif), 
                .rx_do(rx_do[7:0]), 
                .lcnt(rxlcnt[8:0]), 
                .rx_ld(rx_ld[2:0]), 
                .lefthalf(ag_lefthalf),
                .lefthalfd1(ag_lefthalfd1), 
                .linespace(linespace[3:0]), 
                .offset(offset[7:0]), 
                .pclkd1(ag_pclkd1),
                .pclkd2(ag_pclkd2),
                .rcomp(rcomp[7:0]), 
                .resetb(resetb), 
                .rflag(ag_rflag), 
                .vjog(vjog), 
                .blackacc(black_acc[7:0]),
                .lacc0(lacc0[7:0]), 
                .lacc1(lacc1[7:0]), 
                .lacc2(lacc2[7:0]), 
                .lacc3(lacc3[7:0]), 
                .lacc4(lacc4[7:0]),
                .lacc5(lacc5[7:0]), 
                .lacc6(lacc6[7:0]), 
                .lacc7(lacc7[7:0]), 
                .out(ip_out),
                .pclkd4(ag_pclkd4), 
                .vp_clk(vp_clk)
               );

  addrgen   ag (
                .resetb(resetb), 
                .vp_clk(vp_clk), 
                .rx_VP_PCLK(rx_VP_PCLK), 
                .zoom(zoom), 
                .qcif(qcif), 
                .hz30(hz30), 
                .auto(self_timing), 
                .evenfirst(evenfirst), 
                .hjog(hjog), 
                .vjog(vjog),
                .stndrd(stndrd),
                .vsolid(vsolid),
                .skip(skip), 
                .sof(start_of_frame), 
                .rxlcnt(rxlcnt[8:0]), 
                .rx_DATA_IMMINENT(rx_DATA_IMMINENT),
                .addr0(ad_addr0[8:0]), 
                .addr1(ag_addr1[8:0]), 
                .baraddr(ag_baraddr[8:0]), 
                .ceb0(ag_ceb0), 
                .ceb1(ag_ceb1), 
                .ceb2(ag_ceb2), 
                .ceb3(ag_ceb3), 
                .web0(ag_web0), 
                .web1(ag_web1), 
                .web2(ag_web2), 
                .web3(ag_web3),
                .rcatch0_posen(rcatch0_posen), 
                .rcatch1_posen(rcatch1_posen), 
                .rcatch2_posen(rcatch2_posen), 
                .rcatch3_posen(rcatch3_posen), 
                .ienv(ag_ienv), 
                .qlinekill(ag_qlinekill),
                .menv(ag_menv), 
                .oenv(ag_oenv), 
                .ramadd(ag_ramadd), 
                .rsflag(ag_rsflag), 
                .gseflag(ag_gseflag), 
                .vlenv(ag_vlenv),
                .pclkd1(ag_pclkd1), 
                .pclkd2(ag_pclkd2), 
                .pclkd4(ag_pclkd4), 
                .rflag(ag_rflag), 
                .lefthalf(ag_lefthalf), 
                .lefthalfd1(ag_lefthalfd1),
                .f_int(f_int), 
                .fst(fst), 
                .lst(lst),
                .flenv(flenv), 
                .llenv(llenv), 
                .olcnt(ag_olcnt[8:0]), 
                .intzoom(ag_intzoom), 
                .intqcif(ag_intqcif), 
                .intskip(ag_intskip)
               );

  ramcatch  rc (
                .vp_clk(vp_clk),
                .rcatch0_posen(rcatch0_posen),
                .rcatch1_posen(rcatch1_posen),
                .rcatch2_posen(rcatch2_posen),
                .rcatch3_posen(rcatch3_posen),
                .in0(rams_o0[7:0]),
                .in1(rams_o1[7:0]), 
                .in2(rams_o2[7:0]), 
                .in3(rams_o3[7:0]), 
                .resetb(resetb), 
                .out0(rc_o0[7:0]),
                .out1(rc_o1[7:0]), 
                .out2(rc_o2[7:0]), 
                .out3(rc_o3[7:0]), 
                .intqcif(ag_intqcif), 
                .rsflag(ag_rsflag),
                .ramadd(ag_ramadd)
               );

  rgbrams rams (
                .out3(rams_o3[7:0]), 
                .out2(rams_o2[7:0]), 
                .out1(rams_o1[7:0]), 
                .out0(rams_o0[7:0]), 
                .web3(ag_web3),
                .web2(ag_web2), 
                .web1(ag_web1), 
                .web0(ag_web0), 
                .in3(rc_o2[7:0]), 
                .in2(rc_o1[7:0]), 
                .in1(rc_o0[7:0]),
                .in0(ip_out),
                .ceb3(ag_ceb3), 
                .ceb2(ag_ceb2), 
                .ceb1(ag_ceb1), 
                .ceb0(ag_ceb0), 
                .ad1(ag_addr1[8:0]), 
                .ad0(ad_addr0[8:0])
               );

  colctrl acb (
                .clk(vp_clk),
                .resetb(resetb),
//                .run(acb_run),
                .run(f_int),
                .racc(racci[11:0]),
                .gacc(gacci[11:0]),
                .bacc(bacci[11:0]),
                .remote(acb_remote),
                .freeze(acb_freeze),
                .pregain(acb_pregain),
                .rinr(rcof00[7:0]),
                .ginr(rcof01[7:0]),
                .binr(rcof02[7:0]),
                .ring(rcof10[7:0]),
                .ging(rcof11[7:0]),
                .bing(rcof12[7:0]),
                .rinb(rcof20[7:0]),
                .ginb(rcof21[7:0]),
                .binb(rcof22[7:0]),
                .gnbase(acb_gnbase[3:0]),
                .mu(acb_mu),
                .m_rinr(acb00[7:0]),
                .m_ginr(acb01[7:0]),
                .m_binr(acb02[7:0]),
                .m_ring(acb10[7:0]),
                .m_ging(acb11[7:0]),
                .m_bing(acb12[7:0]),
                .m_rinb(acb20[7:0]),
                .m_ginb(acb21[7:0]),
                .m_binb(acb22[7:0])
               );

endmodule
