/*
 *  Description: Video Processor + Pads
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : vp653a
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
 * 23-MAY-97:  Host serial I/F added.
 *  5-JUN-97:  fst made bidir (for hsif)
 * 12-JUN-97:  lst,pclk,vo made tri-state
 * 13-JUN-97:  fst made tri-state, f_int made bidir (for hsif) 
*/

module vp653a(wr_n, rd_n, sd, vi, clk14, vo, fclk, sclk, rstxxa_n,
  sda, scl, ale, vpen, int, lst, fst, f_int, hsda, hscl, xtali, xtalo);

  input  wr_n;
  input  rd_n;
  inout  [7:0] sd;
  input  [3:0] vi;
  input  clk14;
  output [7:0] vo;
  output fclk;
  output sclk;
  input  rstxxa_n;
  inout  sda, hsda, scl;
  input  hscl;
  input  ale;
  input  vpen;
  output int;
  output lst;
  inout  fst;
  output f_int;
  input  xtali;
  output xtalo;

  
  wire [7:0] dout, p_sd, p_d, p_vo;
  wire [3:0] p_vi, b_vi;
  wire [1:0] oe_n;
  vm653a vm (
    .wr_n(p_wrb), .scl(p_scl), .sda_(sda_), .rd_n(p_rdb), .dataout(dout),
    .datain(p_sd), .vi(p_vi), .clk14(p_clk14), .vo(p_vo), .fclk(p_fclk),
    .sclk(p_sclk), .rstxxa_n(p_rstxxa_n), .sda(p_sda), .ale(p_ale), .lst(p_lst),
    .fst(p_fst), .vpen(p_vpen), .rdb(rdb), .int(p_int), .f_int(p_f_int),
    .oe_n(oe_n), .scl_(scl_), .hscl(p_hscl), .hsda(p_hsda), .hsda_(hsda_),
    .sad(sad), .sad_(sad_), .ckin(p_xclk), .voeb(voeb));

    PDU02C vo0_i (.PAD(vo[0]), .I(p_vo[0]), .OEN(voeb));
    PDU02C vo1_i (.PAD(vo[1]), .I(p_vo[1]), .OEN(voeb));
    PDU02C vo2_i (.PAD(vo[2]), .I(p_vo[2]), .OEN(voeb));
    PDU02C vo3_i (.PAD(vo[3]), .I(p_vo[3]), .OEN(voeb));
    PDU02C vo4_i (.PAD(vo[4]), .I(p_vo[4]), .OEN(voeb));
    PDU02C vo5_i (.PAD(vo[5]), .I(p_vo[5]), .OEN(voeb));
    PDU02C vo6_i (.PAD(vo[6]), .I(p_vo[6]), .OEN(voeb));
    PDU02C vo7_i (.PAD(vo[7]), .I(p_vo[7]), .OEN(voeb));
    PDU02C fclk_i (.PAD(fclk), .I(p_fclk), .OEN(voeb));
    PDU02C lst_i (.PAD(lst), .I(p_lst), .OEN(voeb));
    PDU02C fst_i (.PAD(fst), .I(p_fst), .OEN(voeb));

    PDO02C int_i (.PAD(int), .I(p_int));
    PDT02C sclk_2 (.PAD(sclk), .I(p_sclk), .OEN(oe_n[0]));
    PDT04C sclk_4 (.PAD(sclk), .I(p_sclk), .OEN(oe_n[1]));

    PDU02C hsda_i (.PAD(hsda), .C(b_hsda), .I(1'b0), .OEN(hsda_));
      ICS0 hsda_b (.C(b_hsda), .IN(p_hsda));
    PDU02C scl_i (.PAD(scl), .C(b_scl), .I(1'b0), .OEN(scl_));
      ICS0 scl_b (.C(b_scl), .IN(p_scl));
    PDU02C sda_i (.PAD(sda), .C(b_sda), .I(1'b0), .OEN(sda_));
      ICS0 sda_b (.C(b_sda), .IN(p_sda));
    PDD02C f_int_i (.PAD(f_int), .C(b_sad), .I(p_f_int), .OEN(sad_));
      ICS0 sad_b (.C(b_sad), .IN(sad));
    PDU02C sd0_i (.PAD(sd[0]), .C(p_sd[0]), .I(dout[0]), .OEN(rdb));
    PDU02C sd1_i (.PAD(sd[1]), .C(p_sd[1]), .I(dout[1]), .OEN(rdb));
    PDU02C sd2_i (.PAD(sd[2]), .C(p_sd[2]), .I(dout[2]), .OEN(rdb));
    PDU02C sd3_i (.PAD(sd[3]), .C(p_sd[3]), .I(dout[3]), .OEN(rdb));
    PDU02C sd4_i (.PAD(sd[4]), .C(p_sd[4]), .I(dout[4]), .OEN(rdb));
    PDU02C sd5_i (.PAD(sd[5]), .C(p_sd[5]), .I(dout[5]), .OEN(rdb));
    PDU02C sd6_i (.PAD(sd[6]), .C(p_sd[6]), .I(dout[6]), .OEN(rdb));
    PDU02C sd7_i (.PAD(sd[7]), .C(p_sd[7]), .I(dout[7]), .OEN(rdb));
    
    PDU rstxxa_i (.PAD(rstxxa_n), .C(b_rstxxa_n));
      ICS0 clr_b (.C(b_rstxxa_n), .IN(p_rstxxa_n));
    PDU hscl_i (.PAD(hscl), .C(b_hscl));
      ICS0 hscl_b (.C(b_hscl), .IN(p_hscl));
    PDD vi0_i (.PAD(vi[0]), .C(b_vi[0])); IC0 vi0_b (.C(b_vi[0]), .IN(p_vi[0]));
    PDD vi1_i (.PAD(vi[1]), .C(b_vi[1])); IC0 vi1_b (.C(b_vi[1]), .IN(p_vi[1]));
    PDD vi2_i (.PAD(vi[2]), .C(b_vi[2])); IC0 vi2_b (.C(b_vi[2]), .IN(p_vi[2]));
    PDD vi3_i (.PAD(vi[3]), .C(b_vi[3])); IC0 vi3_b (.C(b_vi[3]), .IN(p_vi[3]));
    PDD ale_i (.PAD(ale), .C(b_ale));    IC0 ale_b (.C(b_ale), .IN(p_ale));
    PDD vpen_i (.PAD(vpen), .C(b_vpen)); IC0 vpen_b (.C(b_vpen), .IN(p_vpen));
    PDD ck14_i (.PAD(clk14), .C(b_clk14)); IC0 clk14_b (.C(b_clk14), .IN(p_clk14));
    PDU wr_n_i (.PAD(wr_n), .C(b_wrb));   IC0 wrb_b (.C(b_wrb), .IN(p_wrb));
    PDU rd_n_i (.PAD(rd_n), .C(b_rdb));   IC0 rdb_b (.C(b_rdb), .IN(p_rdb));
    PDX02 xtal_i (.XIN(xtali), .XOUT(xtalo), .IN(p_xclk));


endmodule // of vp653a
