/*
 *  Description: Video Processor Top Level
 *
 *  Designer : Paul Likoudis
 *  Company  : VLSI Vision Ltd.
 *  Module   : vm653a
 *
 * Revision History:
 * DD-MMM-YY:  Comment
 * 21-MAY-97:  Copy from CPiA original
 *  2-SEP-97:  tri-state on reset, "aux" input
*/

module vm653a(wr_n, scl_, sda_, rd_n, dataout, datain, vi, clk14, vo,
        fclk, sclk, rstxxa_n, sda, ale, vpen, oe_n, int, lst, fst,
        f_int, rdb, scl, hsda, hscl, hsda_, sad, sad_, ckin, voeb);

  input  wr_n;
  output scl_;
  output sda_;
  input  rd_n;
  output [7:0] dataout;
  input  [7:0] datain;
  input  [3:0] vi;
  input  clk14;
  output [7:0] vo;
  output fclk;
  output sclk;
  input  rstxxa_n;
  input  sda;
  input  ale;
  input  vpen;
  output [1:0] oe_n;
  output int;
  output lst;
  output fst;
  output f_int;
  output rdb;
  input  scl;
  input  hsda;
  input  hscl;
  output hsda_;
  input  sad;
  output sad_;
  input  ckin;
  output voeb;

  wire  [4:0] irq;
  wire  [1:0] sft_rst;
  wire  [7:0] ad, ss_dout, ss_din;
  wire  [20:0] ch_allx;
  wire  [1:0] sif;
  wire  [6:0] si_ram_add;
  wire  [15:0] dr_out;
  wire  [15:0] dr_in;
  wire  [7:0] rx_do;
  wire  [2:0] rx_ld;
  wire  [1:0] filtercode;
  wire  [6:0] dr_add;
  wire  [7:0] vo_;


  wire            fineh;

  wire      [7:0] finel;

  wire            coarseh;

  wire      [7:0] coarsel;

  wire      [2:0] cam_gain;

  wire      [7:0] racc,
                  gacc,
                  bacc,
                  black_acc,
                  exp_acc,
                  lacc0,
                  lacc1,
                  lacc2,
                  lacc3,
                  lacc4,
                  lacc5,
                  lacc6,
                  lacc7,
                  acb22,
		  acb21,
		  acb20,
		  acb12,
		  acb11,
		  acb10,
		  acb02,
		  acb01,
		  acb00;
 
  wire            scl_sif,
                  sda_sif;

  wire      [8:0] LINE_NUMBER;

  wire      [1:0] HOT_PHASEOUT;

  wire      [7:0] cam_devicel,
                  cam_deviceh;

  wire      [5:0] cam_statin;

  wire      [7:0] offset,
                  rcomp,
                  g1comp,
                  g2comp,
                  bcomp,
                  m00,
                  n00,
                  m01,
                  n01,
                  m02,
                  n02,
                  m10,
                  n10,
                  m11,
                  n11,
                  m12,
                  n12,
                  m20,
                  n20,
                  m21,
                  n21,
                  m22,
                  n22,
                  apcor;

  wire      [3:0] gamcor;

  wire      [3:0] linespace;

  wire      [2:0] accscale;

  wire      [7:0] zcode0,
                  zcode1,
                  zcode2,
                  zcode3;

  wire      [1:0] CLKDIV,
                  HOT_PHASEIN;

  wire            OVERRIDE,
                  hjog,
                  vjog,
                  evenfirst,
                  skip,
                  qcif,
                  zoom;

  wire      [7:0] thresh;

  wire            color_bars,
                  self_timing,
                  ERROR_MASK,
                  fast_serial,
                  acc_sda_scl;

  wire      [7:0] vp_dmcode,
                  acb_config,
                  acb_gnbase,
                  acb_mu,
                  cam_tms;

  wire      [7:0] cam_setup0,
                  cam_setup1,
                  cam_setup2,
                  cam_setup3;

  wire      [5:0] defcor;

  wire            vp_clk;

 
  supply0 VSS;

  wire odd = cam_statin[4];

  wire mhz14 = clk14 | ckin;

ve653a    ve(
  .vp_clk(vp_clk),
  .rx_VP_PCLK(rx_VP_PCLK),
  .rx_ld(rx_ld),
  .data_valid(data_valid),
  .rx_DATA_IMMINENT(rx_DATA_IMMINENT),
  .rstxxa_n(rstxxa_n),
  .rx_do(rx_do[7:0]),
  .correct(correct),
  .filtercode(filtercode[1:0]),
  .offset(offset),
  .rcomp(rcomp),
  .g1comp(g1comp),
  .g2comp(g2comp),
  .bcomp(bcomp),
  .m00(m00),
  .n00(n00),
  .m01(m01),
  .n01(n01),
  .m02(m02),
  .n02(n02),
  .m10(m10),
  .n10(n10),
  .m11(m11),
  .n11(n11),
  .m12(m12),
  .n12(n12),
  .m20(m20),
  .n20(n20),
  .m21(m21),
  .n21(n21),
  .m22(m22),
  .n22(n22),
  .apcor(apcor),
  .gamcor(gamcor),
  .linespace(linespace),
  .accscale(accscale),
  .zcode0(zcode0),
  .zcode1(zcode1),
  .zcode2(zcode2),
  .zcode3(zcode3),
  .hjog(hjog),
  .vjog(vjog),
  .evenfirst(evenfirst),
  .skip(skip),
  .qcif(qcif),
  .zoom(zoom),
  .thresh(thresh),
  .color_bars(color_bars),
  .self_timing(self_timing),
  .vp_dmcode(vp_dmcode),
  .acb_config(acb_config),
  .acb_gnbase(acb_gnbase),
  .acb_mu(acb_mu),
  .LINE_NUMBER(LINE_NUMBER),
  .hz30(cam_setup0[3]),
  .defcor(defcor),
  .racc(racc),
  .gacc(gacc),
  .bacc(bacc),
  .black_acc(black_acc),
  .exp_acc(exp_acc),
  .lacc0(lacc0),
  .lacc1(lacc1),
  .lacc2(lacc2),
  .lacc3(lacc3),
  .lacc4(lacc4),
  .lacc5(lacc5),
  .lacc6(lacc6),
  .lacc7(lacc7),
  .acb22(acb22), 
  .acb21(acb21), 
  .acb20(acb20), 
  .acb12(acb12), 
  .acb11(acb11), 
  .acb10(acb10), 
  .acb02(acb02),
  .acb01(acb01), 
  .acb00(acb00),
  .vo(vo_),
  .fclk(fclk_),
  .ve_end_of_frame(ve_end_of_frame),
  .f_int(f_int),
  .fst(fst),
  .lst(lst), 
  .odd(odd),
  .yuvnot(yuvnot)
);

rx653a    rx(
  .vi(vi[3:0]),
  .clk14(mhz14),
  .rstxxa_n(rstxxa_n),
  .CAMERA_X(irq[4]),
  .SOFDATA_IMMINENT(sof),
  .DATA_OUT(rx_do[7:0]),
  .LINE_CODE(rx_ld),
  .DATA_VALID(data_valid),
  .DATA_VALID_PRE(rx_DATA_VALID_PRE),
  .DATA_VALID_POSEN(rx_DATA_VALID_POSEN),
  .DATA_IMMINENT(rx_DATA_IMMINENT),
  .PHASE_ERROR(irq[0]),
  .NIBBLE_ERROR(irq[1]),
  .BYTE_ERROR(irq[2]),
  .SENSOR_CLOCK(sclk),
  .vp_clk(vp_clk),
  .rx_VP_PCLK(rx_VP_PCLK),
  .CLKDIV(CLKDIV),
  .HOT_PHASEIN(HOT_PHASEIN),
  .OVERRIDE(OVERRIDE),
  .self_timing(self_timing),
  .ERROR_MASK(ERROR_MASK),
  .fineh(fineh),
  .finel(finel),
  .coarseh(coarseh),
  .coarsel(coarsel),
  .cam_gain(cam_gain),
  .LINE_NUMBER(LINE_NUMBER),
  .HOT_PHASEOUT(HOT_PHASEOUT),
  .cam_devicel(cam_devicel),
  .cam_deviceh(cam_deviceh),
  .cam_statin(cam_statin),
  .sft_rst(sft_rst[1:0]) 
);

ch653a    ch(
  .ad(ad[7:0]),
  .din(ss_din),
  .dout(ss_dout),
  .wr63(ch_wr63),
  .wr_n(ss_wrb),
  .rd_n(rd_n),
  .ale(ss_ale),
  .vpen(ss_vpen),
  .si_act(si_active),
  .mhz14(mhz14),
  .rstb(rstxxa_n),
  .fineh(fineh),
  .finel(finel),
  .coarseh(coarseh),
  .coarsel(coarsel),
  .cam_gain(cam_gain),
  .racc(racc),
  .gacc(gacc),
  .bacc(bacc),
  .black_acc(black_acc),
  .exp_acc(exp_acc),
  .lacc0(lacc0),
  .lacc1(lacc1),
  .lacc2(lacc2),
  .lacc3(lacc3),
  .lacc4(lacc4),
  .lacc5(lacc5),
  .lacc6(lacc6),
  .lacc7(lacc7),
  .scl_sif(scl_sif),
  .sda_sif(sda_sif),
  .LINE_NUMBER(LINE_NUMBER),
  .HOT_PHASEOUT(HOT_PHASEOUT),
  .cam_devicel(cam_devicel),
  .cam_deviceh(cam_deviceh),
  .cam_statin(cam_statin),
  .offset(offset),
  .rcomp(rcomp),
  .g1comp(g1comp),
  .g2comp(g2comp),
  .bcomp(bcomp),
  .m00(m00),
  .n00(n00),
  .m01(m01),
  .n01(n01),
  .m02(m02),
  .n02(n02),
  .m10(m10),
  .n10(n10),
  .m11(m11),
  .n11(n11),
  .m12(m12),
  .n12(n12),
  .m20(m20),
  .n20(n20),
  .m21(m21),
  .n21(n21),
  .m22(m22),
  .n22(n22),
  .apcor(apcor),
  .gamcor(gamcor),
  .linespace(linespace),
  .accscale(accscale),
  .zcode0(zcode0),
  .zcode1(zcode1),
  .zcode2(zcode2),
  .zcode3(zcode3),
  .CLKDIV(CLKDIV),
  .HOT_PHASEIN(HOT_PHASEIN),
  .OVERRIDE(OVERRIDE),
  .hjog(hjog),
  .vjog(vjog),
  .evenfirst(evenfirst),
  .skip(skip),
  .qcif(qcif),
  .zoom(zoom),
  .yuvnot(yuvnot),
  .thresh(thresh),
  .color_bars(color_bars),
  .self_timing(self_timing),
  .ERROR_MASK(ERROR_MASK),
  .fast_serial(fast_serial),
  .acc_sda_scl(acc_sda_scl),
  .vp_dmcode(vp_dmcode),
  .acb_config(acb_config),
  .acb_gnbase(acb_gnbase),
  .acb_mu(acb_mu),
  .cam_tms(cam_tms),
  .cam_setup0(cam_setup0),
  .cam_setup1(cam_setup1),
  .cam_setup2(cam_setup2),
  .cam_setup3(cam_setup3),
  .defcor(defcor),
  .all_x(ch_allx[20:0]),
  .irq(irq[4:0]),
  .eof(ve_end_of_frame),
  .wrb(ch_wrb),
  .rdb(rdb),
  .int(int),
  .oe_n(oe_n[1:0]),
  .voeb(voeb_),
  .f_int(f_int),
  .sif(sif[1:0]),
  .acb22(acb22), 
  .acb21(acb21), 
  .acb20(acb20), 
  .acb12(acb12), 
  .acb11(acb11), 
  .acb10(acb10), 
  .acb02(acb02),
  .acb01(acb01), 
  .acb00(acb00)
);

             
dc653a    dc(
  .map(map),
  .ram_data(dr_out[15:0]),
  .correct(correct),
  .filter_code(filtercode[1:0]),
  .ram_address(dr_add[6:0]),
  .ram_ceb(dr_ceb),
  .sof(sof),
  .vp_clk(vp_clk),
  .e2read(e2read),
  .ram_waddress(si_ram_add[6:0]),
  .ram_wceb(si_ram_ceb),
  .ram_web(dr_web),
  .resetb(rstxxa_n),
  .data_valid_posen(rx_DATA_VALID_POSEN),
  .data_valid_pre(rx_DATA_VALID_PRE)
);

si653a    si(
  .mhz14(mhz14),
  .clrb(rstxxa_n),
  .wr63(ch_wr63),
  .wrb(ch_wrb),
  .scl(scl),
  .sda(sda),
  .sif(sif[1:0]),
  .ad(ad[7:0]),
  .din2(ss_din[2]),
  .din0(ss_din[0]),
  .all_x(ch_allx[20:0]),
  .fast_serial(fast_serial),
  .acc_sda_scl(acc_sda_scl),
  .cam_tms(cam_tms),
  .cam_setup0(cam_setup0),
  .cam_setup1(cam_setup1),
  .cam_setup2(cam_setup2),
  .cam_setup3(cam_setup3),
  .scl_sif(scl_sif),
  .sda_sif(sda_sif),
  .scl_(scl_),
  .sda_(sda_),
  .active(si_active),
  .nak(irq[3]),
  .sft_rst(sft_rst[1:0]),
  .ram_ceb(si_ram_ceb),
  .ram_address(si_ram_add[6:0]),
  .ram_data(dr_in[15:0]),
  .e2read(e2read),
  .map(map)
);

             
RAM128X16 dr(
  .A(dr_add[6:0]),
  .CEB(dr_ceb),
  .IN(dr_in[15:0]),
  .WEB(dr_web),
  .OUT(dr_out[15:0]),
  .OEB(VSS)
);

ss653a ss (
  .clk14(mhz14),
  .rstxxa_n(rstxxa_n),
  .sda(hsda),
  .scl(hscl),
  .din(datain),
  .dout(dataout),
  .ale(ale),
  .wrb(wr_n),
  .vpen(vpen),
  .ss_vpen(ss_vpen),
  .ss_din(ss_din),
  .ss_dout(ss_dout),
  .ss_ale(ss_ale),
  .ss_wrb(ss_wrb),
  .hsda_(hsda_),
  .active(active),
  .sad(sad),
  .sad_(ss_sad)
);

  assign voeb = voeb_ | ~rstxxa_n; 
  assign sad_ = ss_sad | voeb_;
  assign {vo,fclk} = (~vpen && ~wr_n && !oe_n) ? {ad,rd_n} : {vo_,fclk_}; 

endmodule
